/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.product;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.product.UFOProductLineDAO;
import com.ufo.product.entity.ProductLineEntity;
import java.util.Vector;

public class UFOProductLineWB
extends UFOBaseWB {
    public UFOProductLineWB() {
    }

    public UFOProductLineWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchLineList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("LIST", dao.searchLineList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchLineLvList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("LIST", dao.searchLineLvList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_LV_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchProductLineTabLvList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("LIST", dao.searchProductLineTabLvList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_TAB_LV_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectLineInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("VIEW", dao.selectLineInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertLineInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                info.put("lineCd", dao.getNewLineCd(info));
                this.startTransaction();
                resCnt = dao.insertLineInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateLineInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateLineInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteLineInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("lineCd", info.getString("lineCd"));
                temp.put("useFl", "");
                Vector lineList = dao.searchLineLvList(temp);
                this.startTransaction();
                if (lineList != null) {
                    int i = 0;
                    while (i < lineList.size()) {
                        ProductLineEntity entity = (ProductLineEntity)lineList.get(i);
                        UFORequest temp2 = new UFORequest(info.getRequest());
                        temp2.put("lineCd", entity.lineCd);
                        resCnt1 += dao.deleteLinePrdtInfo(entity.toRequest());
                        resCnt += dao.deleteLineInfo(entity.toRequest());
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchLinePrdtList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchLinePrdtListPaging(info));
                    result.put("TOTCNT", dao.getLinePrdtListCnt(info));
                } else {
                    result.put("LIST", dao.searchLinePrdtList(info));
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_PRODUCT_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectLinePrdtInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("VIEW", dao.selectLinePrdtInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_PRODUCT_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertLinePrdtInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertLinePrdtInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_PRODUCT_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateLinePrdtInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateLinePrdtInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_PRODUCT_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteLinePrdtInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteLinePrdtInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LINE_PRODUCT_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectLineCategoryInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOProductLineDAO dao = new UFOProductLineDAO(this.getConnection(this));
                result.put("VIEW", dao.selectLineCategoryInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PRODUCT_CATEGORY_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

