/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.ppg.template;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.ppg.entity.TabTemplateEntity;
import com.ufo.ppg.template.UFOPPGTemplateMngDAO;
import com.ufo.ppg.template.UFOTabTemplateMngDAO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class UFOPPGTemplateMngWB
extends UFOBaseWB {
    public UFOPPGTemplateMngWB() {
    }

    public UFOPPGTemplateMngWB(String siteCd) {
        super(siteCd);
    }

    public String loadFileContent(String path, String readEnc) throws UFOException {
        StringBuffer sb = null;
        try {
            sb = new StringBuffer();
            String read = null;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(path)), readEnc));
            while ((read = br.readLine()) != null) {
                sb.append(read);
                sb.append("\n");
            }
            br.close();
        }
        catch (Exception ex) {
            throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]loadTemplateFile", ex);
        }
        return sb.toString();
    }

    public UFOResult insertTemplate(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                this.startTransaction();
                int resultCnt = 0;
                info.put("ppgClCd", dao.getPpgClCd(info));
                UFORequest seqReq = info.cloneReq("");
                seqReq.put("column", "PPGTEMPSEQ");
                seqReq.put("tableNm", "UPPG02MT");
                info.put("ppgTempSeq", dao.getNewSeq(seqReq));
                seqReq = info.cloneReq("");
                seqReq.put("column", "ATTCHSEQ");
                seqReq.put("tableNm", "UPPG02FT");
                info.put("attchSeq", dao.getNewSeq(seqReq));
                resultCnt = dao.insertPPGTemplate(info);
                dao.insertPPGTemplateIcon(info);
                if (resultCnt > 0) {
                    result.put("flag", true);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.commit();
                } else {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\ufffd\ufffd\u5fe1 \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                ex.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]insertTemplate", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchTemplateList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                result.put("LIST", dao.searchTemplateList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchTemplateList", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectTemplateInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                result.put("VIEW", dao.selectTemplateInfo(info));
                String[] tabTempSeq = info.getArray("tabTempSeq");
                String[] tabInfoNm = info.getArray("tabInfoNm");
                String[] postScptFl = info.getArray("postScptFl");
                String[] tabCd = info.getArray("tabCd");
                if (tabTempSeq != null && tabTempSeq.length > 0) {
                    UFOTabTemplateMngDAO dao2 = new UFOTabTemplateMngDAO(this.getConnection(this));
                    Vector<TabTemplateEntity> v = new Vector<TabTemplateEntity>();
                    int i = 0;
                    while (i < tabTempSeq.length) {
                        if (tabTempSeq[i] != null && !"".equals(tabTempSeq[i])) {
                            info.put("tabTempSeq", tabTempSeq[i]);
                            TabTemplateEntity tabEntity = dao2.searchTemplateInfo(info);
                            tabEntity.tabInfoNm = tabInfoNm[i];
                            tabEntity.tabCd = tabCd[i];
                            tabEntity.postScptFl = postScptFl[i];
                            v.add(tabEntity);
                        }
                        ++i;
                    }
                    result.put("tabTempList", v);
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectTemplateInfos", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBuilderTemplateInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                result.put("VIEW", dao.selectTemplateInfo(info));
                UFOTabTemplateMngDAO dao2 = new UFOTabTemplateMngDAO(this.getConnection(this));
                result.put("tabTempList", dao2.searchBuilderTemplate(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectTemplateInfos", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateTemplate(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                this.startTransaction();
                int resultCnt = 0;
                resultCnt = dao.updateTemplate(info);
                if (info.get("file_icon_info") != null) {
                    dao.updatePPGTemplateIcon(info);
                }
                if (resultCnt > 0) {
                    result.put("flag", true);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.commit();
                } else {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]updateTemplate", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteTemplate(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGTemplateMngDAO dao = new UFOPPGTemplateMngDAO(this.getConnection(this));
                int resultCnt = 0;
                if (dao.existPPGTemplate(info) == null) {
                    resultCnt = dao.deleteTemplate(info);
                    dao.deletePPGTemplateIcon(info);
                    if (resultCnt > 0) {
                        result.put("flag", true);
                        result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.commit();
                    } else {
                        result.put("flag", false);
                        result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.rollback();
                    }
                } else {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\u0634\ufffd \ufffd\ufffd\ufffd\u00f8\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u0534\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]deleteTemplate", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

