/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.ppg.template;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.ppg.entity.PPGTemplateEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;

public class UFOPPGTemplateMngDAO
extends UFOBaseDAO {
    public UFOPPGTemplateMngDAO(Connection con) {
        super(con);
    }

    public int getNewSeq(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        String column = info.getString("column");
        String tableNm = info.getString("tableNm");
        StringBuffer strSql = new StringBuffer();
        strSql.append("/* \ufffd\ufffd\ufffd\u03bf\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\u0223\ufffd\ufffd \ufffd\ufffd\u022f\ufffd\u0474\ufffd. */");
        strSql.append("\n").append("    SELECT NVL(MAX(" + column + "),0)+1 AS SEQ FROM " + tableNm);
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewSeq", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getPpgClCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("    SELECT /* NEW_MAX_SEQ */ LPAD(TO_NUMBER(NVL(MAX(PPGCLCD), '000')) + 1, 3, 0) FROM UPPG02MT WHERE SITECD = ? AND PPGTPCD = ?");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("ppgTpCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getPpgClCd", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPPGTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT /* PPG_TEMPLATES_INSERT */ INTO UPPG02MT(            ");
        strSql.append("\n").append("    PPGTEMPSEQ,                                     ");
        strSql.append("\n").append("    FILESAVEPATH,                                   ");
        strSql.append("\n").append("    TEMPCNT,                                        ");
        strSql.append("\n").append("    MODID,                                          ");
        strSql.append("\n").append("    REGID,                                          ");
        strSql.append("\n").append("    SITECD,                                         ");
        strSql.append("\n").append("    PPGTPCD,                                        ");
        strSql.append("\n").append("    PPGCLCD,                                        ");
        strSql.append("\n").append("    ICONIMGSEQ,                                     ");
        strSql.append("\n").append("    FNLMODDATE,                                     ");
        strSql.append("\n").append("    FSTREGDATE                                      ");
        strSql.append("\n").append(") VALUES( ?                                         ");
        strSql.append("\n").append("            , ?, EMPTY_CLOB(), ?, ?, ? ,? ,?, ?, sysdate, sysdate)  ");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* PPG_TEMPLATES_INSERT_CONTENTS */    ");
        clobSql.append("\n").append("               TEMPCNT FROM UPPG02MT                  ");
        clobSql.append("\n").append("           WHERE PPGTEMPSEQ  = ?                      ");
        clobSql.append("\n").append("          FOR UPDATE                                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("ppgTempSeq"));
                pstmt.setString(index++, info.getArray("filePath")[0]);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("ppgTpCd"));
                pstmt.setString(index++, info.getString("ppgClCd"));
                pstmt.setInt(index++, info.getInt("attchSeq"));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(clobSql.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("ppgTempSeq"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("tempCnt")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPPGTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPPGTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT /* TEMPLATE_ICON_INSERT */ INTO UPPG02FT (           ");
        strSql.append("\n").append("        ATTCHSEQ,                                           ");
        strSql.append("\n").append("        FILEEXT,                                            ");
        strSql.append("\n").append("        FILESIZE,                                           ");
        strSql.append("\n").append("        FILEPATH,                                           ");
        strSql.append("\n").append("        FILENM,                                             ");
        strSql.append("\n").append("        FSTREGDATE,                                         ");
        strSql.append("\n").append("        REGID                                              ");
        strSql.append("\n").append(") VALUES ((SELECT NVL(MAX(ATTCHSEQ),0)+1 AS ATTCHSEQ FROM UPPG02FT), ?, ?, ?, ?, SYSDATE, ?)              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                Map iconInfo = (Map)info.get("file_icon_info");
                pstmt.setString(index++, (String)iconInfo.get("fileExt"));
                pstmt.setInt(index++, Integer.parseInt((String)iconInfo.get("fileSize")));
                pstmt.setString(index++, (String)iconInfo.get("filePath"));
                pstmt.setString(index++, (String)iconInfo.get("fileNm"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPPGTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchTemplateList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT   /* SEARCH_TEMPLATE */                              ");
        strSql.append("\n").append("    M.PPGTEMPSEQ,                                           ");
        strSql.append("\n").append("    M.FILESAVEPATH,                                         ");
        strSql.append("\n").append("    M.TEMPCNT,                                              ");
        strSql.append("\n").append("    M.FSTREGDATE,                                           ");
        strSql.append("\n").append("    M.REGID,                                                ");
        strSql.append("\n").append("    M.SITECD,                                               ");
        strSql.append("\n").append("    M.PPGTPCD,                                              ");
        strSql.append("\n").append("    M.PPGCLCD,                                              ");
        strSql.append("\n").append("    M.FNLMODDATE,                                           ");
        strSql.append("\n").append("    M.MODID,                                                ");
        strSql.append("\n").append("    M.ICONIMGSEQ,                                           ");
        strSql.append("\n").append("    F.FILEPATH,                                             ");
        strSql.append("\n").append("    F.FILENM,                                            ");
        strSql.append("\n").append("    M.TEMPDESC                                          ");
        strSql.append("\n").append("FROM UPPG02MT M INNER JOIN UPPG02FT F                   ");
        strSql.append("\n").append("ON M.ICONIMGSEQ = F.ATTCHSEQ                            ");
        strSql.append("\n").append("WHERE 1 = 1                                             ");
        strSql.append("\n").append("AND SITECD =  ?                                         ");
        strSql.append("\n").append("AND PPGTPCD =  ?                                        ");
        strSql.append("\n").append("ORDER BY PPGTEMPSEQ DESC                                ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("ppgTpCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.PPGTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchTemplateList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public PPGTemplateEntity selectTemplateInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PPGTemplateEntity result = new PPGTemplateEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT /* PPG_TEMPLATE_SELECT */ M.PPGTEMPSEQ,                    ");
        strSql.append("\n").append("    M.FILESAVEPATH,                   ");
        strSql.append("\n").append("    M.TEMPCNT,                        ");
        strSql.append("\n").append("    M.FSTREGDATE,                     ");
        strSql.append("\n").append("    M.REGID,                          ");
        strSql.append("\n").append("    M.SITECD,                         ");
        strSql.append("\n").append("    M.PPGTPCD,                        ");
        strSql.append("\n").append("    M.PPGCLCD,                        ");
        strSql.append("\n").append("    M.FNLMODDATE,                     ");
        strSql.append("\n").append("    M.MODID,                          ");
        strSql.append("\n").append("    M.ICONIMGSEQ,                      ");
        strSql.append("\n").append("    F.FILENM,                      ");
        strSql.append("\n").append("    M.TEMPDESC                    ");
        strSql.append("\n").append("FROM UPPG02MT M INNER JOIN UPPG02FT F   ");
        strSql.append("\n").append("ON M.ICONIMGSEQ = F.ATTCHSEQ   ");
        strSql.append("\n").append("WHERE M.PPGTEMPSEQ = ?                ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgTempSeq"));
                rs = pstmt.executeQuery();
                result = (PPGTemplateEntity)DAOHelper.makeEntity(rs, "com.ufo.ppg.entity.PPGTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectTemplateInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchBuilderTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                     ");
        strSql.append("\n").append("FROM UPPG03MT                       ");
        strSql.append("\n").append("WHERE PPGCD = ?      ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.TabTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE /* PPG_TEMPLATES_UPDATE */ UPPG02MT SET   ");
        strSql.append("\n").append("TEMPCNT = EMPTY_CLOB(),          ");
        strSql.append("\n").append("TEMPDESC= ?,                     ");
        strSql.append("\n").append("FNLMODDATE = SYSDATE,            ");
        strSql.append("\n").append("MODID = ?                        ");
        strSql.append("\n").append("WHERE PPGTEMPSEQ = ?             ");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* PPG_TEMPLATES_UPDATE_CONTENTS */    ");
        clobSql.append("\n").append("               TEMPCNT FROM UPPG02MT                  ");
        clobSql.append("\n").append("           WHERE PPGTEMPSEQ  = ?                      ");
        clobSql.append("\n").append("          FOR UPDATE                                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("tempDesc"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setInt(index++, info.getInt("ppgTempSeq"));
                result = pstmt.executeUpdate();
                if (result > 0 && info.isExist("tempCnt")) {
                    pstmt2 = this.con.prepareStatement(clobSql.toString());
                    index = 1;
                    pstmt2.setString(index++, info.getString("ppgTempSeq"));
                    rs = pstmt2.executeQuery();
                    String[] arrVal = new String[]{info.getString("tempCnt")};
                    DAOHelper.putClobData(rs, arrVal);
                }
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int updatePPGTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE /* TEMPLATE_ICON_UPDATE */ UPPG02FT SET            ");
        strSql.append("\n").append("        FILEEXT = ?,                                            ");
        strSql.append("\n").append("        FILESIZE = ?,                                           ");
        strSql.append("\n").append("        FILEPATH = ?,                                           ");
        strSql.append("\n").append("        FILENM = ?                                             ");
        strSql.append("\n").append("WHERE ATTCHSEQ = ?                                           ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                Map fileInfo = (Map)info.get("file_icon_info");
                pstmt.setString(index++, (String)fileInfo.get("fileExt"));
                pstmt.setInt(index++, Integer.parseInt((String)fileInfo.get("fileSize")));
                pstmt.setString(index++, (String)fileInfo.get("filePath"));
                pstmt.setString(index++, (String)fileInfo.get("fileNm"));
                pstmt.setString(index++, info.getString("iconImgSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updatePPGTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE FROM /* PPG_TEMPLATES_DELETE */ UPPG02MT   ");
        strSql.append("\n").append("WHERE PPGTEMPSEQ = ?  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setInt(index++, info.getInt("ppgTempSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deleteTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deletePPGTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE FROM /* PPG_TEMPLATES_DELETE */ UPPG02FT   ");
        strSql.append("\n").append("WHERE ATTCHSEQ = ?  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setInt(index++, info.getInt("iconImgSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deletePPGTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public PPGTemplateEntity existPPGTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PPGTemplateEntity result = new PPGTemplateEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                            ");
        strSql.append("\n").append("    FROM UPPG01MT                   ");
        strSql.append("\n").append("    WHERE PPGTEMPSEQ = ?            ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgTempSeq"));
                rs = pstmt.executeQuery();
                result = (PPGTemplateEntity)DAOHelper.makeEntity(rs, "com.ufo.ppg.entity.PPGTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PPGTemplateEntity", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

