/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.ppg.builder;

import com.ufo.base.UFOSiteInfoDAO;
import com.ufo.base.entity.SiteInfoEntity;
import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.ppg.builder.UFOPPGBuilderMngDAO;
import com.ufo.ppg.entity.PPGBuilderEntity;
import com.ufo.ppg.entity.TabBuilderEntity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class UFOPPGBuilderMngWB
extends UFOBaseWB {
    public UFOPPGBuilderMngWB() {
    }

    public UFOPPGBuilderMngWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchBuilderList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                result.put("LIST", dao.searchBuilderListPaging(info));
                result.put("TOTCNT", dao.searchBuilderListCnt(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchBuilderList", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBuilderInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                PPGBuilderEntity entity = dao.searchBuilderInfo(info);
                result.put("VIEW", entity);
                result.put("TABLIST", dao.searchBuilderTabList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectBuilderInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertPPG(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resultCnt = 0;
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                this.startTransaction();
                String ppgCd = this.createPPGCode(info);
                info.put("ppgCd", dao.getPpgSeq(ppgCd));
                String content = info.getString("ppgCnt");
                info.put("ppgCnt", content);
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                SiteInfoEntity siteEntity = siteDao.selectSite(info);
                info.put("fileCreatePath", String.valueOf(siteEntity.warRootPath) + "ppg_template/");
                resultCnt = dao.insertPPG(info);
                if (resultCnt > 0) {
                    if ("D".equals(info.getString("ppgTpCd"))) {
                        String tabCd = String.valueOf(CmUtil.leftPad(info.getString("siteCd"), 5, "0")) + "TAB";
                        int tabCdIdx = dao.getTabSeq(tabCd);
                        if (!"".equals(info.getString("TAB_TEMP_SEQ_0"))) {
                            resultCnt = 0;
                        }
                        int i = 0;
                        while (i < 6) {
                            if (!"".equals(info.getString("TAB_TEMP_SEQ_" + i))) {
                                info.put("tabCnt", info.getString("TAB_" + i));
                                info.put("tabTempSeq", info.getString("TAB_TEMP_SEQ_" + i));
                                info.put("tabCd", info.getString("TAB_CD_" + i));
                                info.put("tabPpgCd", String.valueOf(tabCd) + CmUtil.leftPad(String.valueOf(++tabCdIdx), 10, "0"));
                                resultCnt = dao.insertPPGTab(info);
                            }
                            ++i;
                        }
                    }
                    if (resultCnt > 0) {
                        result.put("flag", true);
                        result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.commit();
                    }
                    this.createPPGFile(info, this.selectBuilderInfo(info));
                }
                if (resultCnt < 1) {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\ufffd\ufffd\u5fe1 \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]insertPPG", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public String createPPGCode(UFORequest info) throws UFOException {
        String ppgCd = "";
        String langCd = info.getString("langCd");
        String brandLineCd = info.getString("brandLineCd");
        langCd = langCd.equals("ko") ? "1" : (langCd.equals("en") ? "2" : (langCd.equals("ja") ? "3" : (langCd.equals("zh") ? "4" : "5")));
        brandLineCd = brandLineCd.substring(1, 2);
        ppgCd = String.valueOf(ppgCd) + info.getString("siteCd");
        ppgCd = String.valueOf(ppgCd) + info.getString("ppgTpCd");
        ppgCd = String.valueOf(ppgCd) + info.getString("ppgClCd");
        ppgCd = String.valueOf(ppgCd) + langCd;
        ppgCd = String.valueOf(ppgCd) + brandLineCd;
        ppgCd = String.valueOf(ppgCd) + info.getString("brandLevel");
        return ppgCd;
    }

    public UFOResult updateBuilderExpore(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resultCnt = 0;
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                this.startTransaction();
                String ppgCd = info.getString("ppgCd");
                info.put("ppgCd", "");
                info.put("exporeFl", "N");
                dao.updateBuilderExpore(info);
                info.put("ppgCd", ppgCd);
                info.put("exporeFl", "Y");
                resultCnt = dao.updateBuilderExpore(info);
                if (resultCnt > 0) {
                    result.put("flag", true);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.commit();
                } else {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\ufffd\ubfe1 \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]updateBuilderExpore", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public void createPPGFile(UFORequest info, UFOResult result) throws UFOException {
        try {
            PPGBuilderEntity entity = (PPGBuilderEntity)result.get("VIEW");
            Vector tabList = (Vector)result.get("TABLIST");
            String ppgCd = entity.ppgCd;
            String content = entity.ppgCnt;
            String path = entity.fileCreatePath;
            StringBuffer ppgContent = new StringBuffer();
            ppgContent.append("<%@ page contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\" %>\n");
            ppgContent.append("<%@ taglib prefix=\"c\" uri=\"http://java.sun.com/jstl/core\" %>\n");
            ppgContent.append("<%@ taglib prefix=\"cc\" uri=\"http://java.sun.com/jsp/jstl/core\" %>\n\n");
            ppgContent.append(content);
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            File file = new File(String.valueOf(path) + ppgCd + "_temp.jsp");
            BufferedWriter buffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            buffWriter.write(ppgContent.toString().trim());
            buffWriter.close();
            File f = new File(String.valueOf(path) + ppgCd + ".jsp");
            if (f.exists()) {
                f.delete();
            }
            file.renameTo(f);
            File dirTemp = new File(String.valueOf(path) + "ppg_sender/");
            if (dirTemp.exists()) {
                File file2 = new File(String.valueOf(path) + "ppg_sender/" + ppgCd + ".jsp");
                BufferedWriter buffWriter2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                buffWriter2.write(ppgContent.toString().trim());
                buffWriter2.close();
            }
            if (tabList != null && tabList.size() > 0) {
                int i = 0;
                while (i < tabList.size()) {
                    TabBuilderEntity tabEntity = (TabBuilderEntity)tabList.get(i);
                    content = tabEntity.tabCnt;
                    String tabCd = tabEntity.tabPpgCd;
                    StringBuffer tabContent = new StringBuffer();
                    tabContent.append("<%@ page contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\" %>\n");
                    tabContent.append("<%@ taglib prefix=\"c\" uri=\"http://java.sun.com/jstl/core\" %>\n");
                    tabContent.append("<%@ taglib prefix=\"cc\" uri=\"http://java.sun.com/jsp/jstl/core\" %>\n\n");
                    tabContent.append(content);
                    file = new File(String.valueOf(path) + tabCd + "_temp.jsp");
                    buffWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    buffWriter.write(tabContent.toString().trim());
                    buffWriter.close();
                    f = new File(String.valueOf(path) + tabCd + ".jsp");
                    if (f.exists()) {
                        f.delete();
                    }
                    file.renameTo(f);
                    if (dirTemp.exists()) {
                        File file2 = new File(String.valueOf(path) + "ppg_sender/" + tabCd + ".jsp");
                        BufferedWriter buffWriter2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                        buffWriter2.write(tabContent.toString().trim());
                        buffWriter2.close();
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]createPPGFile", ex);
        }
    }

    public UFOResult searchLineTabInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                result.put("LIST", dao.searchLineTabInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchLineTabInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBuilderCopy(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                PPGBuilderEntity entity = dao.searchBuilderInfo(info);
                Vector tabList = dao.searchBuilderTabList(info);
                info.put("langCd", entity.langCd);
                info.put("ppgTempSeq", entity.ppgTempSeq);
                info.put("ppgDesc", entity.ppgDesc);
                info.put("ppgCnt", entity.ppgCnt);
                info.put("ppgTpCd", entity.ppgTpCd);
                info.put("ppgClCd", entity.ppgClCd);
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                SiteInfoEntity siteEntity = siteDao.selectSite(info);
                info.put("fileCreatePath", String.valueOf(siteEntity.warRootPath) + "ppg_template/");
                info.put("exporeFl", entity.exporeFl);
                if (tabList != null && tabList.size() > 0) {
                    int i = 0;
                    while (i < tabList.size()) {
                        TabBuilderEntity tabEntity = (TabBuilderEntity)tabList.get(i);
                        info.put("TAB_" + i, tabEntity.tabCnt);
                        info.put("TAB_TEMP_SEQ_" + i, tabEntity.tabTempSeq);
                        ++i;
                    }
                }
                result = this.insertPPG(info);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectBuilderCopy", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public String searchSiteUrl(UFORequest info) throws UFOException {
        String siteUrl = "";
        try {
            try {
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                SiteInfoEntity siteEntity = siteDao.selectSite(info);
                if ("D".equals(info.getString("ppgTpCd"))) {
                    siteUrl = String.valueOf(siteEntity.siteUrl) + "/product/template/detail_preview.jsp";
                } else if ("T".equals(info.getString("ppgTpCd"))) {
                    siteUrl = String.valueOf(siteEntity.siteUrl) + "/product/template/type_preview.jsp";
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchSiteUrl", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return siteUrl;
    }

    public UFOResult deletePPG(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resultCnt = 0;
        try {
            try {
                UFOPPGBuilderMngDAO dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                this.startTransaction();
                result = this.selectBuilderInfo(info);
                Vector tabList = (Vector)result.get("TABLIST");
                dao = new UFOPPGBuilderMngDAO(this.getConnection(this));
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>" + info);
                resultCnt = dao.deletePPG(info);
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>" + tabList);
                String ppgCd = info.getString("ppgCd");
                StringBuffer path = new StringBuffer();
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                SiteInfoEntity siteEntity = siteDao.selectSite(info);
                path.append(siteEntity.warRootPath).append("ppg_template/").append(ppgCd).append(".jsp");
                File file = new File(path.toString());
                if (file.exists()) {
                    file.delete();
                }
                if (tabList != null) {
                    int i = 0;
                    while (i < tabList.size()) {
                        TabBuilderEntity tabEntity = (TabBuilderEntity)tabList.get(i);
                        path.setLength(0);
                        path.append(siteEntity.warRootPath).append("ppg_template/").append(tabEntity.tabPpgCd).append(".jsp");
                        file = new File(path.toString());
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                }
                if (resultCnt > 0) {
                    result.put("flag", true);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.commit();
                } else {
                    result.put("flag", false);
                    result.put("mesg", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[WB]deletePPG", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

