/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.paperweight;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.paperweight.entity.ItemEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOItemMgmtDAO
extends UFOBaseDAO {
    public UFOItemMgmtDAO(Connection con) {
        super(con);
    }

    public Vector searchItemList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         SELECT /* PAPER_ITEM_SEARCH */                         ");
        strSql.append("\n").append("                ItemCd                                      ");
        strSql.append("\n").append("                , SiteCd                                        ");
        strSql.append("\n").append("                , Contents                                      ");
        strSql.append("\n").append("                , useFl                                     ");
        strSql.append("\n").append("                , Notes1, Notes2                                ");
        strSql.append("\n").append("                , TO_CHAR(FstRegDate,'YYYY/MM/DD') AS FstRegDate    ");
        strSql.append("\n").append("                , RegId                                         ");
        strSql.append("\n").append("                , TO_CHAR(FnlModDate,'YYYY/MM/DD') AS FnlModDate    ");
        strSql.append("\n").append("                , ModId                                         ");
        strSql.append("\n").append("           FROM KCNT02MT                                        ");
        strSql.append("\n").append("          WHERE 1 = 1                                            ");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("            AND SiteCd = ?                                ");
        }
        if (!info.isSpace("contents")) {
            strSql.append("\n").append("            AND Contents = ?                                ");
        }
        if (!info.isSpace("notes1")) {
            strSql.append("\n").append("            AND Notes1 LIKE '%' || ? || '%'                 ");
        }
        if (!info.isSpace("notes2")) {
            strSql.append("\n").append("            AND Notes2 LIKE '%' || ? || '%'                 ");
        }
        if (!info.isSpace("useFl")) {
            strSql.append("\n").append("            AND useFl = ?                 ");
        }
        if (!info.isSpace("searchValue")) {
            strSql.append("\n").append("            AND CONTENTS LIKE '%' || ? || '%'                 ");
        }
        strSql.append("\n").append("          ORDER BY itemCd DESC, FstRegDate DESC                      ");
        try {
            try {
                int pageSize = 20;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                int pageNo = 1;
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = info.isSpace("noPage") ? this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007) : this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (info.isSpace("noPage")) {
                    pstmt.setInt(index++, pageSize);
                }
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("contents")) {
                    pstmt.setString(index++, info.getString("contents"));
                }
                if (!info.isSpace("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (!info.isSpace("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (!info.isSpace("searchValue")) {
                    pstmt.setString(index++, info.getString("searchValue"));
                }
                if (info.isSpace("noPage")) {
                    pstmt.setInt(index++, pageSize * pageNo);
                    pstmt.setInt(index++, pageNo);
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.ItemEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchItemList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchItemCount(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         SELECT /* PAPER_ITEM_SEARCH */                         ");
        strSql.append("\n").append("                COUNT(1)                                         ");
        strSql.append("\n").append("           FROM KCNT02MT                                        ");
        strSql.append("\n").append("          WHERE 1 = 1                                            ");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("            AND SiteCd = ?                                ");
        }
        if (!info.isSpace("contents")) {
            strSql.append("\n").append("            AND Contents = ?                                ");
        }
        if (!info.isSpace("notes1")) {
            strSql.append("\n").append("            AND Notes1 LIKE '%' || ? || '%'                 ");
        }
        if (!info.isSpace("notes2")) {
            strSql.append("\n").append("            AND Notes2 LIKE '%' || ? || '%'                 ");
        }
        if (!info.isSpace("useFl")) {
            strSql.append("\n").append("            AND useFl = ?                 ");
        }
        if (!info.isSpace("searchValue")) {
            strSql.append("\n").append("            AND CONTENTS LIKE '%' || ? || '%'                 ");
        }
        strSql.append("\n").append("          ORDER BY FstRegDate DESC                     ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("contents")) {
                    pstmt.setString(index++, info.getString("contents"));
                }
                if (!info.isSpace("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (!info.isSpace("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (!info.isSpace("searchValue")) {
                    pstmt.setString(index++, info.getString("searchValue"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchItemCount", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public ItemEntity selectItemInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ItemEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT /* PAPER_ITEM_SEARCH */ ");
        strSql.append("\n").append("      ItemCd                ");
        strSql.append("\n").append("      , SiteCd              ");
        strSql.append("\n").append("      , Contents            ");
        strSql.append("\n").append("      , useFl               ");
        strSql.append("\n").append("      , Notes1, Notes2      ");
        strSql.append("\n").append("      , TO_CHAR(FstRegDate,'YYYY/MM/DD') AS FstRegDate              ");
        strSql.append("\n").append("      , RegId               ");
        strSql.append("\n").append("      , TO_CHAR(FnlModDate,'YYYY/MM/DD') AS FnlModDate              ");
        strSql.append("\n").append("      , ModId               ");
        strSql.append("\n").append(" FROM KCNT02MT              ");
        strSql.append("\n").append("WHERE 1 = 1                 ");
        strSql.append("\n").append("      AND itemCd = ?        ");
        strSql.append("\n").append("      AND SiteCd = ?        ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = (ItemEntity)DAOHelper.makeEntity(rs, "com.ufo.paperweight.entity.ItemEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectItemInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewItemCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                String siteCd = info.getString("siteCd");
                int emptyCol = 9 - siteCd.length();
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT ? || LPAD(NVL(MAX(SUBSTR(ITEMCD, -" + emptyCol + ")), 0) + 1, " + emptyCol + ", '0')    ");
                strSql.append("\n").append("FROM KCNT02MT                                                    ");
                strSql.append("\n").append("WHERE SITECD = ? AND ITEMCD LIKE ? || '%'                                       ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, siteCd);
                pstmt.setString(index++, siteCd);
                pstmt.setString(index++, siteCd);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewItemCd", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchItemCompare(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT COUNT(1)                     ");
                strSql.append("\n").append("    FROM KCNT02MT                   ");
                strSql.append("\n").append("WHERE 1 = 1                         ");
                strSql.append("\n").append("    AND SITECD = ?                  ");
                strSql.append("\n").append("    AND CONTENTS = ?                ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("contents"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchItemCompare", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertItemInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         INSERT /* PAPER_ITEM_INSERT */ INTO KCNT02MT ( ");
        strSql.append("\n").append("                    ItemCd                          ");
        strSql.append("\n").append("                    , SiteCd                            ");
        strSql.append("\n").append("                    , Contents                          ");
        strSql.append("\n").append("                    , UseFl                            ");
        strSql.append("\n").append("                    , Notes1                            ");
        strSql.append("\n").append("                    , Notes2                            ");
        strSql.append("\n").append("                    , FstRegDate, RegId                 ");
        strSql.append("\n").append("                    , FnlModDate, ModId                 ");
        strSql.append("\n").append("        ) VALUES (                                      ");
        strSql.append("\n").append("            ?, ?, ?, ?, ?, ?                            ");
        strSql.append("\n").append("            , SYSDATE, ?, SYSDATE, ?                    ");
        strSql.append("\n").append("        )                                               ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertItemInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateItemInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("        UPDATE /* PAPER_ITEM_UPDATE */ KCNT02MT SET     ");
        strSql.append("\n").append("                ItemCd      = ItemCd                ");
        if (info.isExist("siteCd")) {
            strSql.append("\n").append("                , SiteCd        = ?                     ");
        }
        if (info.isExist("contents")) {
            strSql.append("\n").append("                , Contents      = ?                     ");
        }
        if (info.isExist("notes1")) {
            strSql.append("\n").append("                , Notes1        = ?                     ");
        }
        if (info.isExist("notes2")) {
            strSql.append("\n").append("                , Notes2        = ?                     ");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append("                , UseFl         = ?                     ");
        }
        strSql.append("\n").append("                , FnlModDate    = SYSDATE               ");
        strSql.append("\n").append("                , ModId         = ?                     ");
        strSql.append("\n").append("        WHERE ItemCd = ?                                ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (info.isExist("contents")) {
                    pstmt.setString(index++, info.getString("contents"));
                }
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (info.isExist("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("itemCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateItemInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteItemInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        StringBuffer strSql2 = new StringBuffer();
        strSql.append("\n").append("        DELETE /* PAPER_ITEM_DELETE */ FROM KCNT02MT    ");
        strSql.append("\n").append("        WHERE ItemCd = ? AND SiteCd = ?                 ");
        strSql2.append("\n").append("DELETE                              ");
        strSql2.append("\n").append("        FROM KCNT03MT               ");
        strSql2.append("\n").append("    WHERE 1 = 1                     ");
        strSql2.append("\n").append("        AND ITEMCD = ?              ");
        strSql2.append("\n").append("        AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(strSql2.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("itemCd"));
                pstmt2.setString(index++, info.getString("siteCd"));
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deleteItemInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        return result += pstmt2.executeUpdate();
    }

    public Vector searchConnectPrdtExist(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT PRDTNM, PRDTCD           ");
        strSql.append("\n").append("    FROM KCNT04DT               ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND ITEMCD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.ProductEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchConnectPrdtExist", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchPaperExist(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT PAPERCD                  ");
        strSql.append("\n").append("FROM KCNT03DT                   ");
        strSql.append("\n").append("WHERE ITEMCD = ?                ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.PaperEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchPaperExist", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

