/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.paperweight;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.paperweight.entity.ItemEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOItemGroupMgmtDAO
extends UFOBaseDAO {
    public UFOItemGroupMgmtDAO(Connection con) {
        super(con);
    }

    public Vector searchGroupList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT * /* PAPER_RELATION_SEARCH */          ");
        strSql.append("\n").append("    FROM KCNT03MT                             ");
        strSql.append("\n").append("WHERE SITECD = ?                               ");
        if (!info.isSpace("level")) {
            strSql.append("\n").append("AND LEVEL = ?                               ");
        }
        strSql.append("\n").append("START WITH UPPITEMCD = ?                      ");
        strSql.append("\n").append("CONNECT BY PRIOR ITEMCD = UPPITEMCD           ");
        strSql.append("\n").append("ORDER BY SEQ DESC                               ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("level")) {
                    pstmt.setString(index++, info.getString("level"));
                }
                pstmt.setString(index++, info.getString("uppItemCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.ItemEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchGroupList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewGroupSeq(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        int interval = 1;
        if (info.isExist("__interval_")) {
            interval = info.getInt("__interval_");
        }
        try {
            try {
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("    SELECT /* NEW_PAPER_RELATION_SEQ */             ");
                strSql.append("\n").append("        NVL(MAX(Seq), 0)+" + interval + " AS Seq        ");
                strSql.append("\n").append("    FROM KCNT03MT                                   ");
                strSql.append("\n").append("    WHERE 1 = 1                             ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                boolean index = true;
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewGroupSeq", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewGroupCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                String type = info.getString("type");
                int emptyCol = 9 - type.length();
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT ? || LPAD(NVL(MAX(SUBSTR(ITEMCD, -" + emptyCol + ")), 0) + 1, " + emptyCol + ", '0')    ");
                strSql.append("\n").append("FROM KCNT03MT                                                    ");
                strSql.append("\n").append("WHERE SITECD = ? AND ITEMCD LIKE ? || '%'                                       ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, type);
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, type);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewGroupCd", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchItemGroupCompare(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT COUNT(1) CNT                 ");
                strSql.append("\n").append("    FROM KCNT03MT                   ");
                strSql.append("\n").append("WHERE 1 = 1                         ");
                strSql.append("\n").append("    AND SITECD =  ?                 ");
                strSql.append("\n").append("    AND CONTENTS = ?                ");
                strSql.append("\n").append("START WITH UPPITEMCD =  ?           ");
                strSql.append("\n").append("CONNECT BY PRIOR ITEMCD = UPPITEMCD ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("uppItemCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchItemGroupCompare", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertGroupInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         INSERT /* PAPER_RELATION_INSERT */ INTO KCNT03MT ( ");
        strSql.append("\n").append("                    Seq                                     ");
        strSql.append("\n").append("                    , SiteCd                                ");
        strSql.append("\n").append("                    , ItemCd                                ");
        strSql.append("\n").append("                    , UppItemCd                             ");
        strSql.append("\n").append("                    , contents                              ");
        strSql.append("\n").append("                    , Notes1                                ");
        strSql.append("\n").append("                    , Notes2                                ");
        strSql.append("\n").append("                    , FstRegDate, RegId                     ");
        strSql.append("\n").append("                    , FnlModDate, ModId                     ");
        strSql.append("\n").append("        ) VALUES (                                          ");
        strSql.append("\n").append("            ?, ?, ?, ?, ?, ?, ?                                ");
        strSql.append("\n").append("            , SYSDATE, ?, SYSDATE, ?                        ");
        strSql.append("\n").append("        )                                                   ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("seq"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("uppItemCd"));
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertGroupInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchLowerItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT COUNT(1) CNT             ");
        strSql.append("\n").append("    FROM KCNT03MT               ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND SITECD = ?              ");
        strSql.append("\n").append("    AND UPPITEMCD = ?           ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchLowerItem", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteGroupInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE                      ");
        strSql.append("\n").append("    FROM KCNT03MT           ");
        strSql.append("\n").append("WHERE 1 = 1                 ");
        strSql.append("\n").append("    AND SITECD = ?          ");
        strSql.append("\n").append("    AND ITEMCD = ?          ");
        strSql.append("\n").append("    AND UPPITEMCD = ?       ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("uppItemCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deleteGroupInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public ItemEntity selectGroupItemInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ItemEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                ");
        strSql.append("\n").append("    FROM KCNT03MT       ");
        strSql.append("\n").append("WHERE 1 = 1             ");
        strSql.append("\n").append("    AND SITECD = ?      ");
        strSql.append("\n").append("    AND ITEMCD = ?      ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                rs = pstmt.executeQuery();
                result = (ItemEntity)DAOHelper.makeEntity(rs, "com.ufo.paperweight.entity.ItemEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectGroupItemInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateGroupInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE                      ");
        strSql.append("\n").append("    KCNT03MT                ");
        strSql.append("\n").append("SET CONTENTS = ?            ");
        strSql.append("\n").append("WHERE 1 = 1                 ");
        strSql.append("\n").append("    AND SITECD = ?          ");
        strSql.append("\n").append("    AND ITEMCD = ?          ");
        strSql.append("\n").append("    AND UPPITEMCD = ?       ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("uppItemCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateGroupInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }
}

