/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.news_event;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.member.UFOMemberMgmtDAO;
import com.ufo.member.entity.MemberMgmtEntity;
import com.ufo.news_event.UFOEventMgmtDAO;
import com.ufo.news_event.entity.EventEntryEntity;
import com.ufo.news_event.entity.NewsEventEntity;
import java.util.Vector;

public class UFOEventMgmtWB
extends UFOBaseWB {
    public UFOEventMgmtWB() {
    }

    public UFOEventMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchEventList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector evtList = null;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    evtList = dao.searchEventListPaging(info);
                    result.put("LIST", evtList);
                    result.put("TOTCNT", dao.getEventListCnt(info));
                } else {
                    evtList = dao.searchEventList(info);
                    result.put("LIST", evtList);
                }
                if (evtList != null) {
                    int i = 0;
                    while (i < evtList.size()) {
                        NewsEventEntity entity = (NewsEventEntity)evtList.get(i);
                        UFORequest cReq = entity.toRequest();
                        entity.comtVt = dao.searchEventComtList(cReq);
                        entity.comtCnt = dao.searchEventComtCnt(cReq);
                        ++i;
                    }
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectEventInfoBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                NewsEventEntity entity = dao.selectEventInfo(info);
                Vector prdlist = null;
                if (entity != null) {
                    entity.comtVt = dao.searchEventComtList(info);
                    entity.comtCnt = dao.searchEventComtCnt(info);
                    if ("PRD".equals(info.getString("cd"))) {
                        prdlist = dao.searchProductPrdtInfoList(info);
                        result.put("PRDLIST", prdlist);
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_SELECT_BASIC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectEventInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                NewsEventEntity entity = dao.selectEventInfo(info);
                NewsEventEntity entity1 = dao.selectEventInfo(info, "P");
                NewsEventEntity entity2 = dao.selectEventInfo(info, "N");
                if (entity != null) {
                    entity.comtVt = dao.searchEventComtList(info);
                    entity.comtCnt = dao.searchEventComtCnt(info);
                }
                result.put("VIEW", entity);
                result.put("PREV", entity1);
                result.put("NEXT", entity2);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertEventInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("seq", dao.getMaxSeq(info));
                resCnt = dao.insertEventInfo(info);
                if (info.get("prdtList") != null) {
                    info.put("cd", "PRD");
                    dao.deletePrdtEventPrdtInfo(info);
                    Vector prdtList = null;
                    prdtList = (Vector)info.get("prdtList");
                    int i = 0;
                    while (i < prdtList.size()) {
                        info.put("prdtCd", (String)prdtList.get(i));
                        resCnt1 += dao.insertProductPrdtInfo(info);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateEventInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateEventInfo(info);
                if (info.get("prdtList") != null) {
                    info.put("cd", "PRD");
                    dao.deletePrdtEventPrdtInfo(info);
                    Vector prdtList = null;
                    prdtList = (Vector)info.get("prdtList");
                    int i = 0;
                    while (i < prdtList.size()) {
                        info.put("prdtCd", (String)prdtList.get(i));
                        resCnt1 += dao.insertProductPrdtInfo(info);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteEventInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        boolean resCnt1 = false;
        boolean resCnt2 = false;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteEventInfo(info);
                if ("PRD".equals(info.getString("cd"))) {
                    dao.deletePrdtEventPrdtInfo(info);
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertEventComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertEventComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_COMMENT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteEventComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteEventComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_COMMENT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchEvtApplyList(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        Vector evtAppList = null;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                evtAppList = dao.searchEventApplyList(info);
                result.put("LIST", evtAppList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_APPLY_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateEvtApplicantPrizeExel(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateEvtApplicantPrize(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    result.put("COUNT", resCnt);
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    result.put("COUNT", 0);
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_APPLY_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchEventEntryList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector evtList = null;
        try {
            try {
                UFOMemberMgmtDAO memberDao = new UFOMemberMgmtDAO(this.getConnection(this));
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                MemberMgmtEntity tableInfo = memberDao.selectMemMgmtInfo(info);
                if (info.isPage()) {
                    evtList = dao.searchEventEntryListPaging(info, tableInfo.tableNm1);
                    result.put("LIST", evtList);
                    result.put("TOTCNT", dao.getEventEntryListCnt(info));
                } else {
                    evtList = dao.searchEventEntryList(info, tableInfo.tableNm1);
                    result.put("LIST", evtList);
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_ENTRY_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectEventEntryInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberMgmtDAO memberDao = new UFOMemberMgmtDAO(this.getConnection(this));
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                MemberMgmtEntity tableInfo = memberDao.selectMemMgmtInfo(info);
                EventEntryEntity entity = dao.selectEventEntryInfo(info, tableInfo.tableNm1);
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_ENTRY_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertEventEntryInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        Boolean chkRes = null;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                chkRes = new Boolean(dao.checkEntryYn(info));
                if (chkRes.booleanValue()) {
                    result.put("FLAG", "false");
                    result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\u03fc\u033d\ufffd\ufffd\u03f4\ufffd.");
                } else {
                    this.startTransaction();
                    resCnt = dao.insertEventEntryInfo(info);
                    if (resCnt > 0) {
                        result.put("FLAG", "true");
                        result.put("MESG", "\ufffd\ufffd\ufffd\ufffd \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.commit();
                    } else {
                        result.put("FLAG", "false");
                        result.put("MESG", "\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.rollback();
                    }
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_ENTRY_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateEventEntryInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateEventEntryInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_ENTRY_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteEventEntryInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteEventEntryInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_ENTRY_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateWinnerChoice(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEventMgmtDAO dao = new UFOEventMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateWinnerChoice(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EVENT_WINNER_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

