/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.message;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.message.UFOSmsMgmtDAO;
import com.ufo.message.entity.SMSTemplateEntity;

public class UFOSmsMgmtWB
extends UFOBaseWB {
    public UFOSmsMgmtWB() {
    }

    public UFOSmsMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchSmsTempList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchSmsTemp(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TEMPLATE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSmsTempInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                SMSTemplateEntity entity = dao.selectSmsTemp(info);
                if (entity != null) {
                    entity.markList = dao.searchSmsTempInfo(entity.toRequest());
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TEMPLATE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertSmsTempInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                info.put("smsCd", dao.getNewCd());
                this.startTransaction();
                resCnt = dao.insertSmsTemp(info);
                String[] splitAttr = new String[]{"seq", "replaceKey", "replaceMark"};
                String[] keepAttr = new String[]{"smsCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        resCnt1 += dao.insertSmsTempInfo(arrInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TEMPLATE_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateSmsTempInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateSmsTemp(info);
                String[] splitAttr = new String[]{"seq", "replaceKey", "replaceMark", "status"};
                String[] keepAttr = new String[]{"smsCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (arrInfo[i].getString("status").equals("I")) {
                            resCnt1 += dao.insertSmsTempInfo(arrInfo[i]);
                        } else if (arrInfo[i].getString("status").equals("D")) {
                            resCnt1 += dao.deleteSmsTempInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TEMPLATE_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteSmsTempInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("smsCd", info.getString("smsCd"));
                resCnt1 = dao.deleteSmsTempInfo(temp);
                resCnt = dao.deleteSmsTemp(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TEMPLATE_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSmsMsgList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                if (!info.isSpace("cstmId")) {
                    info.put("cstmNo", info.getString("cstmId"));
                }
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchSmsMsgListPaging(info));
                    result.put("TOTCNT", dao.getSmsMsgListCnt(info));
                } else {
                    result.put("LIST", dao.searchSmsMsgList(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_MESSAGE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSmsMsgInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                if (!info.isSpace("cstmId")) {
                    info.put("cstmNo", info.getString("cstmId"));
                }
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectSmsMsgInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_MESSAGE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult transportSMS(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOSmsMgmtDAO dao = new UFOSmsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("seq", dao.getNewSeq(info));
                resCnt1 = dao.insertSmsEaiInfo(info);
                if (!info.isSpace("cstmId")) {
                    info.put("cstmNo", info.get("cstmId"));
                }
                if (info.isArray("cstmNo")) {
                    String[] splitAttr = new String[]{"cstmNo", "cstmNm", "trPhone"};
                    String[] keepAttr = new String[]{"siteCd", "userId", "seq", "trCallBack", "trMsg", "sndFl", "agncId", "agncNm", "eventCd", "deptCd"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            resCnt2 += dao.insertSmsMsgInfo(arrInfo[i]);
                            ++i;
                        }
                    }
                } else {
                    resCnt2 = dao.insertSmsMsgInfo(info);
                }
                if (resCnt1 > 0 && resCnt2 > 0) {
                    result.put("FLAG", "true");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SMS_TRANSPORT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

