/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.message;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.message.UFOMessageMgmtDAO;
import com.ufo.message.entity.SendMsgInfoEntity;
import java.util.Vector;

public class UFOMessageMgmtWB
extends UFOBaseWB {
    public UFOMessageMgmtWB() {
    }

    public UFOMessageMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchSendMsgList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    Vector list = dao.searchSendMsgListPaging(info);
                    String[] arrAttr = new String[]{"siteCd", "msgCd"};
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            SendMsgInfoEntity entity = (SendMsgInfoEntity)list.get(i);
                            UFORequest temp = entity.toRequest(arrAttr);
                            temp.put("groupCd", info.getString("groupCd"));
                            temp.put("saveFl", "");
                            temp.put("delFl", "");
                            temp.put("viewFl", "");
                            if (!entity.allNoticeFl.equals("Y")) {
                                entity.recvList = dao.searchRecvMsgList(temp);
                            }
                            entity.recvCnt = dao.getRecvMsgListCnt(temp);
                            temp.put("viewFl", "Y");
                            entity.viewCnt = dao.getRecvMsgListCnt(temp);
                            ++i;
                        }
                    }
                    result.put("LIST", list);
                    result.put("TOTCNT", dao.getSendMsgListCnt(info));
                } else {
                    Vector list = dao.searchSendMsgList(info);
                    result.put("LIST", list);
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SEND_MESSAGE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSendMsgInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                SendMsgInfoEntity entity = dao.selectSendMsgInfo(info);
                if (entity != null) {
                    String[] arrAttr = new String[]{"siteCd", "msgCd"};
                    UFORequest temp = entity.toRequest(arrAttr);
                    temp.put("groupCd", info.getString("groupCd"));
                    temp.put("saveFl", "");
                    temp.put("delFl", "");
                    temp.put("viewFl", "");
                    if (!entity.allNoticeFl.equals("Y")) {
                        entity.recvList = dao.searchRecvMsgList(temp);
                    }
                    entity.recvCnt = dao.getRecvMsgListCnt(temp);
                    temp.put("viewFl", "Y");
                    entity.viewCnt = dao.getRecvMsgListCnt(temp);
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SEND_MESSAGE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteSendMsg(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"msgCd", "status"};
                String[] keepAttr = new String[]{"siteCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (arrInfo[i].getBoolean("status")) {
                            arrInfo[i].put("delFl", "Y");
                            resCnt += dao.updateSendMsgInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]DELETE_SEND_MESSAGE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchRecvMsgList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchRecvMsgListPaging(info));
                    result.put("TOTCNT", dao.getRecvMsgListCnt(info));
                } else {
                    result.put("LIST", dao.searchRecvMsgList(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]RECV_MESSAGE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectRecvMsgInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("siteCd", info.getString("siteCd"));
                temp.put("msgCd", info.getString("msgCd"));
                temp.put("recvCd", info.getString("recvCd"));
                temp.put("recvId", info.getString("recvId"));
                temp.put("viewFl", "Y");
                resCnt = dao.updateRecvMsgInfo(temp);
                result.put("VIEW", dao.selectRecvMsgInfo(info));
                this.commit();
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]RECV_MESSAGE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteRecvMsg(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"msgCd", "recvCd", "recvId", "status"};
                String[] keepAttr = new String[]{"siteCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (arrInfo[i].getBoolean("status")) {
                            arrInfo[i].put("delFl", "Y");
                            resCnt += dao.updateRecvMsgInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]DELETE_RECV_MESSAGE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult saveRecvMsg(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"msgCd", "recvCd", "recvId", "status"};
                String[] keepAttr = new String[]{"siteCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (arrInfo[i].getBoolean("status")) {
                            arrInfo[i].put("saveFl", "Y");
                            resCnt += dao.updateRecvMsgInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]DELETE_RECV_MESSAGE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult sendMessage(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOMessageMgmtDAO dao = new UFOMessageMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("msgCd", dao.getNewCd(info));
                resCnt1 = dao.insertSendMsgInfo(info);
                if (CmUtil.nullTrim(info.getString("allNoticeFl")).equals("Y")) {
                    if (info.isSpace("recvCd")) {
                        info.put("recvCd", "02");
                    }
                    resCnt2 = dao.insertRecvMsgInfoForSite(info);
                } else if (info.isArray("recvId")) {
                    String[] splitAttr = new String[]{"recvCd", "recvId", "recvNm"};
                    String[] keepAttr = new String[]{"siteCd", "msgCd"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            if (info.isExist("recvSystem")) {
                                arrInfo[i].put("recvSystem", info.getString("recvSystem"));
                            }
                            if (info.isExist("recvDept")) {
                                arrInfo[i].put("recvDept", info.getString("recvDept"));
                            }
                            resCnt2 += dao.insertRecvMsgInfo(arrInfo[i]);
                            ++i;
                        }
                    }
                } else {
                    resCnt2 = dao.insertRecvMsgInfo(info);
                }
                if (resCnt1 > 0 && resCnt2 > 0) {
                    result.put("FLAG", "true");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MESSAGE_SEND", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

