/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.member;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.member.entity.MemberInterestEntity;
import com.ufo.member.entity.MemberMgmtEntity;
import com.ufo.member.entity.MemberPointEntity;
import com.ufo.member.entity.PointInfoEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class UFOMemberServiceDAO
extends UFOBaseDAO {
    private boolean inInfo = false;
    private MemberMgmtEntity memInfo = null;

    public boolean isInfo() {
        return this.inInfo;
    }

    public UFOMemberServiceDAO(Connection con) {
        super(con);
    }

    public UFOMemberServiceDAO(Connection con, MemberMgmtEntity memInfo) {
        super(con);
        this.memInfo = memInfo;
        this.inInfo = true;
    }

    public Vector searchSitePointList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_POINT_CATEGORY_SEARCH */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SubCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Count\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm7 + "\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("retnFl")) {
            strSql.append("\n").append("\t\t\t   AND RetnFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("useFl")) {
            strSql.append("\n").append("\t\t\t   AND UseFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("useFl")) {
            strSql.append("\n").append("\t\t\t   AND UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.PointInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_CATEGORY_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public PointInfoEntity selectSitePointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PointInfoEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_POINT_CATEGORY_SELECT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SubCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Count\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm7 + "\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("pointCd"));
                rs = pstmt.executeQuery();
                result = (PointInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.PointInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_CATEGORY_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT /* NEW_CD */ ? || 'P' || LPAD(NVL(MAX(SUBSTR(PointCd,5)),0)+1,4,'0') AS PointCd \t");
        strSql.append("\n").append("\t\tFROM " + this.memInfo.tableNm7 + " WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_CD", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertSitePointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\t\t\tINSERT /* SITE_POINT_CATEGORY_INSERT */ INTO " + this.memInfo.tableNm7 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SubCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Count\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("pointCd"));
                pstmt.setString(index++, info.getString("catCd"));
                pstmt.setString(index++, info.getString("subCd"));
                pstmt.setInt(index++, info.getInt("count"));
                pstmt.setString(index++, info.getString("pointNm"));
                pstmt.setInt(index++, info.getInt("point"));
                pstmt.setString(index++, info.getString("pointDesc"));
                pstmt.setString(index++, info.getString("retnFl"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_CATEGORY_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateSitePointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* SITE_POINT_CATEGORY_UPDATE */ " + this.memInfo.tableNm7 + " SET\t\t");
        strSql.append("\n").append(" \t\t\t\t\tPointCd\t\t\t= PointCd\t\t\t\t\t\t\t\t\t");
        if (info.isExist("catCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("subCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, SubCd\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("count")) {
            strSql.append("\n").append(" \t\t\t\t\t, Count\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("pointNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, PointNm\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("point")) {
            strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("pointDesc")) {
            strSql.append("\n").append(" \t\t\t\t\t, PointDesc\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("retnFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("catCd")) {
                    pstmt.setString(index++, info.getString("catCd"));
                }
                if (info.isExist("subCd")) {
                    pstmt.setString(index++, info.getString("subCd"));
                }
                if (info.isExist("count")) {
                    pstmt.setInt(index++, info.getInt("count"));
                }
                if (info.isExist("pointNm")) {
                    pstmt.setString(index++, info.getString("pointNm"));
                }
                if (info.isExist("point")) {
                    pstmt.setInt(index++, info.getInt("point"));
                }
                if (info.isExist("pointDesc")) {
                    pstmt.setString(index++, info.getString("pointDesc"));
                }
                if (info.isExist("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("pointCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_CATEGORY_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteSitePointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* SITE_POINT_CATEGORY_DELETE */ FROM  " + this.memInfo.tableNm7);
        strSql.append("\n").append("\t\t\t WHERE SiteCd  =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("pointCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_CATEGORY_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchMemPointList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_INFO_SEARCH */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.PointNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DECODE(A.CnclFl, 'Y', 0, DECODE(A.RetnFl, 'Y', -A.Point, A.Point * DECODE(B.CatCd, 'TRM', LEAST(A.AddCnt, B.Count), 1))) AS Point\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.PointDate,'YYYYMMDDHH24MISS') PointDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RetnDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CnclFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.CnclDate,'YYYYMMDDHH24MISS') CnclDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.AddCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + " A, " + this.memInfo.tableNm7 + " B\t");
        strSql.append("\n").append("\t\t\t WHERE A.SiteCd =  B.SiteCd(+)\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tAND A.PointCd = B.PointCd(+)\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND A.SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND A.CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("retnFl")) {
            strSql.append("\n").append("\t\t\t   AND A.RetnFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cnclFl")) {
            strSql.append("\n").append("\t\t\t   AND A.CnclFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
            strSql.append("\n").append("\t\t\t   AND A.PointDate BETWEEN TO_DATE( ? ||'000000', 'YYYYMMDDHH24MISS') AND TO_DATE( ? ||'235959', 'YYYYMMDDHH24MISS') ");
        }
        strSql.append("\n").append("\t\t\tORDER BY A.Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (!info.isSpace("cnclFl")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                }
                if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
                    pstmt.setString(index++, info.getString("pointStDate"));
                    pstmt.setString(index++, info.getString("pointEndDate"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberPointEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchMemPointListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_INFO_SEARCH_PAGE */\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.PointNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DECODE(A.CnclFl, 'Y', 0, DECODE(A.RetnFl, 'Y', -A.Point, A.Point * DECODE(B.CatCd, 'TRM', LEAST(A.AddCnt, B.Count), 1))) AS Point\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.PointDate,'YYYYMMDDHH24MISS') PointDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RetnDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CnclFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.CnclDate,'YYYYMMDDHH24MISS') CnclDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.AddCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + " A, " + this.memInfo.tableNm7 + " B\t");
        strSql.append("\n").append("\t\t\t WHERE A.SiteCd =  B.SiteCd(+)\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tAND A.PointCd = B.PointCd(+)\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND A.SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND A.CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("retnFl")) {
            strSql.append("\n").append("\t\t\t   AND A.RetnFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cnclFl")) {
            strSql.append("\n").append("\t\t\t   AND A.CnclFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
            strSql.append("\n").append("\t\t\t   AND A.PointDate BETWEEN TO_DATE( ? ||'000000', 'YYYYMMDDHH24MISS') AND TO_DATE( ? ||'235959', 'YYYYMMDDHH24MISS') ");
        }
        strSql.append("\n").append("\t\t\tORDER BY A.Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (!info.isSpace("cnclFl")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                }
                if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
                    pstmt.setString(index++, info.getString("pointStDate"));
                    pstmt.setString(index++, info.getString("pointEndDate"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberPointEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getMemPointListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_INFO_SEARCH_COUNT */\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + "\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("retnFl")) {
            strSql.append("\n").append("\t\t\t   AND RetnFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cnclFl")) {
            strSql.append("\n").append("\t\t\t   AND CnclFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
            strSql.append("\n").append("\t\t\t   AND PointDate BETWEEN TO_DATE( ? ||'000000', 'YYYYMMDDHH24MISS') AND TO_DATE( ? ||'235959', 'YYYYMMDDHH24MISS') ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (!info.isSpace("cnclFl")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                }
                if (!info.isSpace("pointStDate") && !info.isSpace("pointEndDate")) {
                    pstmt.setString(index++, info.getString("pointStDate"));
                    pstmt.setString(index++, info.getString("pointEndDate"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getMemPointCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_COUNT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + "\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointCd")) {
            strSql.append("\n").append("\t\t\t   AND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("retnFl")) {
            strSql.append("\n").append("\t\t\t   AND RetnFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cnclFl")) {
            strSql.append("\n").append("\t\t\t   AND CnclFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("pointCd")) {
                    pstmt.setString(index++, info.getString("pointCd"));
                }
                if (!info.isSpace("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (!info.isSpace("cnclFl")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getMemTotalPoint(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "0";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_TOTAL_POINT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSUM( DECODE(A.CnclFl, 'Y', 0, DECODE(A.RetnFl, 'Y', -A.Point, A.Point * DECODE(B.CatCd, 'TRM', LEAST(A.AddCnt, B.Count), 1)))) AS TotalPoint ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + " A, " + this.memInfo.tableNm7 + " B \t");
        strSql.append("\n").append("\t\t\t WHERE A.SiteCd = B.SiteCd \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND A.PointCd = B.PointCd \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (info.isEquals("_today", "Y")) {
            strSql.append("\n").append("\t\t\t\tAND TO_CHAR(A.PointDate,'YYYYMMDD') = TO_CHAR(SYSDATE,'YYYYMMDD')\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_TOTAL_POINT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberPointEntity selectMemPointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberPointEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_INFO_SELECT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, (SELECT PointNm FROM " + this.memInfo.tableNm7 + " WHERE SiteCd = T.SiteCd AND PointCd = T.PointCd ) As PointNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(PointDate,'YYYYMMDDHH24MISS') PointDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CnclFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(CnclDate,'YYYYMMDDHH24MISS') CnclDate\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + " T\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointCd")) {
            strSql.append("\n").append("\t\t\t \tAND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("__termCd")) {
            if (!info.isSpace("__pointDate")) {
                if (CmUtil.nullTrim(info.getString("__termCd")).equals("D")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMMDD') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYYMMDD')\t");
                } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("M")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMM') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYYMM')\t\t\t");
                } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("Y")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYY') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYY')\t\t\t\t\t");
                }
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("D")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMMDD') = TO_CHAR(SYSDATE,'YYYYMMDD')\t");
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("M")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMM') = TO_CHAR(SYSDATE,'YYYYMM')\t\t\t");
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("Y")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYY') = TO_CHAR(SYSDATE,'YYYY')\t\t\t\t");
            }
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                if (!info.isSpace("pointCd")) {
                    pstmt.setString(index++, info.getString("pointCd"));
                }
                rs = pstmt.executeQuery();
                result = (MemberPointEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberPointEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Hashtable searchSitePointStat(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Hashtable result = null;
        int i = 0;
        long mark = info.getLong("startPnt");
        long interval = info.getLong("interval");
        int itemCnt = info.getInt("itemCnt");
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_POINT_STATISTICS */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t'' AS Blank\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        i = 0;
        while (i < itemCnt) {
            strSql.append("\n").append(" \t\t\t\t, NVL(SUM( CASE" + (i + 1) + " ),0) AS Case" + (i + 1) + "\t\t\t");
            ++i;
        }
        strSql.append("\n").append(" \t\t\t\t\t, COUNT(*)  AS TOTAL\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tFROM ( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSELECT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\t'' As Blank\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        i = 0;
        while (i < itemCnt) {
            if (i + 1 == itemCnt) {
                strSql.append("\n").append(" \t\t\t\t\t\t, CASE WHEN " + (mark + 1L) + " < S.TotalPoint THEN 1 ELSE 0 END AS CASE" + (i + 1));
            } else {
                strSql.append("\n").append(" \t\t\t\t\t\t, CASE WHEN " + (mark + 1L) + " < S.TotalPoint AND S.TotalPoint <= " + (mark + interval) + " THEN 1 ELSE 0 END AS CASE" + (i + 1));
            }
            mark += interval;
            ++i;
        }
        strSql.append("\n").append(" \t\t\t\t\tFROM (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tSELECT \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\t\tA.CstmId, SUM( DECODE(A.CnclFl, 'Y', 0, DECODE(A.RetnFl, 'Y', -A.Point, A.Point * DECODE(B.CatCd, 'TRM', LEAST(A.AddCnt, B.Count), 1)))) AS TotalPoint\t");
        strSql.append("\n").append(" \t\t\t\t\t\tFROM " + this.memInfo.tableNm6 + " A, " + this.memInfo.tableNm7 + " B, " + this.memInfo.tableNm1 + " C\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tWHERE A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tAND A.PointCd = B.PointCd \t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tAND A.CstmId = C.CstmId\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tAND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("sex")) {
            strSql.append("\n").append(" \t\t\t\t\t\tAND C.Sex = ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append(" \t\t\t  \t\t\tGROUP BY A.CstmId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \t\t\t) S\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t) T\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeEntity(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_POINT_STATISTICS", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getNewSeq(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT /* NEW_SEQ */ NVL(MAX(Seq),0)+1 AS Seq FROM " + this.memInfo.tableNm6 + " WHERE SiteCd = ? AND CstmId = ? \t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_SEQ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMemPointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\t\t\tINSERT /* MEMBER_POINT_INFO_INSERT */ INTO " + this.memInfo.tableNm6 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Point\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RetnDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CnclFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CnclDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, SYSDATE, ?, ?, ?, NULL, ?\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setLong(index++, info.getLong("seq"));
                pstmt.setString(index++, info.getString("pointCd"));
                pstmt.setInt(index++, info.getInt("point"));
                pstmt.setString(index++, info.getString("retnFl"));
                pstmt.setString(index++, info.getString("retnDesc"));
                pstmt.setString(index++, "N");
                pstmt.setInt(index++, 1);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateMemPointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_POINT_INFO_UPDATE */ " + this.memInfo.tableNm6 + " SET\t\t");
        strSql.append("\n").append(" \t\t\t\t\tPointCd\t\t\t= PointCd\t\t\t\t\t\t\t\t\t");
        if (info.isExist("retnFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, RetnFl\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("retnDesc")) {
            strSql.append("\n").append(" \t\t\t\t\t, RetnDesc\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("cnclFl") && CmUtil.nullTrim(info.getString("cnclFl")).equals("Y")) {
            strSql.append("\n").append(" \t\t\t\t\t, CnclFl\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, CnclDate\t\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        } else if (info.isExist("cnclFl") && CmUtil.nullTrim(info.getString("cnclFl")).equals("N")) {
            strSql.append("\n").append(" \t\t\t\t\t, CnclFl\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, CnclDate\t\t= NULL\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("addCnt")) {
            if (info.getInt("addCnt") > 0) {
                strSql.append("\n").append(" \t\t\t\t\t, AddCnt\t\t\t= AddCnt + 1\t\t\t\t\t\t\t\t");
            } else if (info.getInt("addCnt") < 0) {
                strSql.append("\n").append(" \t\t\t\t\t, AddCnt\t\t\t= AddCnt - 1\t\t\t\t\t\t\t\t");
            }
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("retnFl")) {
                    pstmt.setString(index++, info.getString("retnFl"));
                }
                if (info.isExist("retnDesc")) {
                    pstmt.setString(index++, info.getString("retnDesc"));
                }
                if (info.isExist("cnclFl") && CmUtil.nullTrim(info.getString("cnclFl")).equals("Y")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                } else if (info.isExist("cnclFl") && CmUtil.nullTrim(info.getString("cnclFl")).equals("N")) {
                    pstmt.setString(index++, info.getString("cnclFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setLong(index++, info.getLong("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteMemPointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_POINT_INFO_DELETE */ FROM  " + this.memInfo.tableNm6);
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchMemInterestList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_INTEREST_INFO_SEARCH */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('" + info.getString("groupCd") + "', BaseCd ) As BaseNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes4\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm4 + " \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("baseCd")) {
            strSql.append("\n").append("\t\t\t   AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes1")) {
            strSql.append("\n").append("\t\t\t   AND Notes1 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes2")) {
            strSql.append("\n").append("\t\t\t   AND Notes2 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes3")) {
            strSql.append("\n").append("\t\t\t   AND Notes3 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes4")) {
            strSql.append("\n").append("\t\t\t   AND Notes4 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointFl")) {
            strSql.append("\n").append("\t\t\t   AND PointFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("baseCd")) {
                    pstmt.setString(index++, info.getString("baseCd"));
                }
                if (!info.isSpace("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (!info.isSpace("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (!info.isSpace("notes3")) {
                    pstmt.setString(index++, info.getString("notes3"));
                }
                if (!info.isSpace("notes4")) {
                    pstmt.setString(index++, info.getString("notes4"));
                }
                if (!info.isSpace("pointFl")) {
                    pstmt.setString(index++, info.getString("pointFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberInterestEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchMemInterestListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_INTEREST_INFO_SEARCH_PAGE */\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('" + info.getString("groupCd") + "', BaseCd ) As BaseNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes4\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm4 + " \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("baseCd")) {
            strSql.append("\n").append("\t\t\t   AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes1")) {
            strSql.append("\n").append("\t\t\t   AND Notes1 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes2")) {
            strSql.append("\n").append("\t\t\t   AND Notes2 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes3")) {
            strSql.append("\n").append("\t\t\t   AND Notes3 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes4")) {
            strSql.append("\n").append("\t\t\t   AND Notes4 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointFl")) {
            strSql.append("\n").append("\t\t\t   AND PointFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("baseCd")) {
                    pstmt.setString(index++, info.getString("baseCd"));
                }
                if (!info.isSpace("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (!info.isSpace("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (!info.isSpace("notes3")) {
                    pstmt.setString(index++, info.getString("notes3"));
                }
                if (!info.isSpace("notes4")) {
                    pstmt.setString(index++, info.getString("notes4"));
                }
                if (!info.isSpace("pointFl")) {
                    pstmt.setString(index++, info.getString("pointFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberInterestEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getMemInterestListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_INTEREST_INFO_SEARCH_COUNT */\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm4 + " \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("baseCd")) {
            strSql.append("\n").append("\t\t\t   AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes1")) {
            strSql.append("\n").append("\t\t\t   AND Notes1 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes2")) {
            strSql.append("\n").append("\t\t\t   AND Notes2 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes3")) {
            strSql.append("\n").append("\t\t\t   AND Notes3 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("notes4")) {
            strSql.append("\n").append("\t\t\t   AND Notes4 LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointFl")) {
            strSql.append("\n").append("\t\t\t   AND PointFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("baseCd")) {
                    pstmt.setString(index++, info.getString("baseCd"));
                }
                if (!info.isSpace("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (!info.isSpace("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (!info.isSpace("notes3")) {
                    pstmt.setString(index++, info.getString("notes3"));
                }
                if (!info.isSpace("notes4")) {
                    pstmt.setString(index++, info.getString("notes4"));
                }
                if (!info.isSpace("pointFl")) {
                    pstmt.setString(index++, info.getString("pointFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberInterestEntity selectMemInterestInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberInterestEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_INTEREST_INFO_SELECT */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('" + info.getString("groupCd") + "', BaseCd ) As BaseNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes4\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm4 + " T\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("baseCd"));
                pstmt.setLong(index++, info.getLong("seq"));
                rs = pstmt.executeQuery();
                result = (MemberInterestEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberInterestEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMemInterestInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\t\t\tINSERT /* MEMBER_INTEREST_INFO_INSERT */ INTO " + this.memInfo.tableNm4 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes4\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PointSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, (SELECT /* NEW_SEQ */ NVL(MAX(Seq),0)+1 AS Seq FROM " + this.memInfo.tableNm4 + " WHERE SiteCd = ? AND CstmId = ? AND BaseCd = ?)\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("baseCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("baseCd"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, info.getString("notes3"));
                pstmt.setString(index++, info.getString("notes4"));
                pstmt.setString(index++, info.getString("pointFl"));
                pstmt.setString(index++, info.getString("pointSeq"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateMemInterestInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_INTEREST_INFO_UPDATE */ " + this.memInfo.tableNm4 + " SET\t\t");
        strSql.append("\n").append(" \t\t\t\t\tBaseCd\t\t\t= BaseCd\t\t\t\t\t\t\t\t\t");
        if (info.isExist("notes1")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes2")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes3")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes3\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes4")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes4\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("pointFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, PointFl\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("pointSeq")) {
            strSql.append("\n").append(" \t\t\t\t\t, PointSeq\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (info.isExist("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (info.isExist("notes3")) {
                    pstmt.setString(index++, info.getString("notes3"));
                }
                if (info.isExist("notes4")) {
                    pstmt.setString(index++, info.getString("notes4"));
                }
                if (info.isExist("pointFl")) {
                    pstmt.setString(index++, info.getString("pointFl"));
                }
                if (info.isExist("pointSeq")) {
                    pstmt.setString(index++, info.getString("pointSeq"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("baseCd"));
                pstmt.setLong(index++, info.getLong("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteMemInterestInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_INTEREST_INFO_DELETE */ FROM  " + this.memInfo.tableNm4);
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("baseCd")) {
            strSql.append("\n").append("\t\t\t    AND BaseCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("baseCd")) {
                    pstmt.setString(index++, info.getString("baseCd"));
                }
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteSiteMemInterestInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_INTEREST_INFO_DELETE */ FROM  " + this.memInfo.tableNm4);
        strSql.append("\n").append("\t\t\t WHERE CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd in ( \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   \t\tSELECT SiteCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \tWHERE FamilyFl = 'Y' \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND UseFl = 'Y' \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND (SiteTp = 'BRD' OR SiteCd = 'AAK') \t");
        strSql.append("\n").append("\t\t\t    \t  AND SiteCd NOT IN (\t\t \t\t\t\t\t\t\t");
        int i = 0;
        while (i < info.getArray("siteCd").length) {
            if (i == 0) {
                strSql.append("\n").append("\t\t\t    \t  ?\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t    \t  , ? \t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            }
            ++i;
        }
        strSql.append("\n").append("\t\t\t    \t  )\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  \t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                int i2 = 0;
                while (i2 < info.getArray("siteCd").length) {
                    pstmt.setString(index++, info.getArray("siteCd")[i2]);
                    ++i2;
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INTEREST_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteSiteMemPointInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_POINT_INFO_DELETE */ FROM  " + this.memInfo.tableNm6);
        strSql.append("\n").append("\t\t\t WHERE CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd in ( \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   \t\tSELECT SiteCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \tWHERE FamilyFl = 'Y' \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND UseFl = 'Y' \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND (SiteTp = 'BRD' OR SiteCd = 'AAK') \t");
        strSql.append("\n").append("\t\t\t    \t  AND SiteCd NOT IN (\t\t \t\t\t\t\t\t\t");
        int i = 0;
        while (i < info.getArray("siteCd").length) {
            if (i == 0) {
                strSql.append("\n").append("\t\t\t    \t  ?\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t    \t  , ? \t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            }
            ++i;
        }
        strSql.append("\n").append("\t\t\t    \t  )\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  \t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                int i2 = 0;
                while (i2 < info.getArray("siteCd").length) {
                    pstmt.setString(index++, info.getArray("siteCd")[i2]);
                    ++i2;
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int getMemPointSaveCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_POINT_SAVE_COUNT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm6 + " T\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd =  ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tAND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t \tAND Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("pointCd")) {
            strSql.append("\n").append("\t\t\t \tAND PointCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("__termCd")) {
            if (!info.isSpace("__pointDate")) {
                if (CmUtil.nullTrim(info.getString("__termCd")).equals("D")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMMDD') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYYMMDD')\t");
                } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("M")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMM') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYYMM')\t\t\t");
                } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("Y")) {
                    strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYY') = TO_CHAR(TO_DATE('" + info.getString("__pointDate") + "','YYYYMMDD'),'YYYY')\t\t\t\t\t");
                }
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("D")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMMDD') = TO_CHAR(SYSDATE,'YYYYMMDD')\t");
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("M")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYYMM') = TO_CHAR(SYSDATE,'YYYYMM')\t\t\t");
            } else if (CmUtil.nullTrim(info.getString("__termCd")).equals("Y")) {
                strSql.append("\n").append("\t\t\t   AND TO_CHAR(PointDate,'YYYY') = TO_CHAR(SYSDATE,'YYYY')\t\t\t\t");
            }
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                if (!info.isSpace("pointCd")) {
                    pstmt.setString(index++, info.getString("pointCd"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_POINT_SAVE_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

