/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.member;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.member.entity.BadMemberEntity;
import com.ufo.member.entity.MemberHistoryEntity;
import com.ufo.member.entity.MemberMgmtEntity;
import com.ufo.member.entity.MemberMstEntity;
import com.ufo.member.entity.MemberPwdEntity;
import com.ufo.member.entity.MemberSubEntity;
import com.ufo.member.entity.SiteMemberEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOMemberMgmtDAO
extends UFOBaseDAO {
    private boolean inInfo = false;
    private MemberMgmtEntity memInfo = null;
    private String tableOwner = "WEBDBA";

    public UFOMemberMgmtDAO(Connection con) {
        super(con);
    }

    public UFOMemberMgmtDAO(Connection con, MemberMgmtEntity memInfo) {
        super(con);
        this.memInfo = memInfo;
        this.inInfo = true;
        if (memInfo != null && "ICTR01MT".equals(memInfo.tableNm1)) {
            this.tableOwner = "INNIDBA";
        }
    }

    public boolean isInfo() {
        return this.inInfo;
    }

    public void setMemInfo(UFORequest info) throws UFOException {
        MemberMgmtEntity memInfo = this.selectMemMgmtInfo(info);
        if (memInfo != null) {
            this.memInfo = memInfo;
            this.inInfo = true;
        }
    }

    public String getCurrentSiteCd() throws UFOException {
        return this.memInfo.siteCd;
    }

    public String getCurrentSiteNm() throws UFOException {
        return this.memInfo.siteNm;
    }

    public Vector searchMemMgmtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_MGMT_INFO_SEARCH */\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\tA.SiteCd        \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, B.SiteNm        \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm1     \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm2\t    \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm3        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm4         \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm5        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm6        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm7        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm8\t       \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm9\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm10     \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.EtcDesc\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.Notes\t\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.SyncFl\t\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, DECODE( A.SiteCd, NULL, 'I', 'U' ) Status\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM KCTR01CT\tA, UCOM01MT B\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tWHERE A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append(" \t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append(" \t\t\tORDER BY B.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberMgmtEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_MGMT_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberMgmtEntity selectMemMgmtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMgmtEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_MGMT_INFO_SELECT */\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\tA.SiteCd        \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, B.SiteNm        \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm1     \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm2\t    \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm3        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm4         \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm5        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm6        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm7        \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm8\t       \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm9\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.TableNm10     \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.EtcDesc\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.Notes\t\t      \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, A.SyncFl\t\t\t      \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM KCTR01CT A, UCOM01MT B\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tWHERE A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tAND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = (MemberMgmtEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMgmtEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_MGMT_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMemMgmtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_MGMT_INFO_INSERT */ INTO KCTR01CT\t (\t");
        strSql.append("\n").append("\t\t\t\t\tSiteCd        \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm1     \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm2\t    \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm3        \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm4         \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm5        \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm6        \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm7        \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm8\t       \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm9\t      \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, TableNm10     \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, EtcDesc\t      \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, Notes\t\t      \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, SyncFl\t\t  \t\t    \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("tableNm1"));
                pstmt.setString(index++, info.getString("tableNm2"));
                pstmt.setString(index++, info.getString("tableNm3"));
                pstmt.setString(index++, info.getString("tableNm4"));
                pstmt.setString(index++, info.getString("tableNm5"));
                pstmt.setString(index++, info.getString("tableNm6"));
                pstmt.setString(index++, info.getString("tableNm7"));
                pstmt.setString(index++, info.getString("tableNm8"));
                pstmt.setString(index++, info.getString("tableNm9"));
                pstmt.setString(index++, info.getString("tableNm10"));
                pstmt.setString(index++, info.getString("etcDesc"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, info.getString("syncFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_MGMT_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateMemMgmtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_MGMT_INFO_UPDATE */ KCTR01CT SET\t\t");
        strSql.append("\n").append("\t\t\t\t\tSiteCd\t\t= SiteCd\t\t\t\t\t\t\t\t\t\t\t\t");
        if (info.isExist("tableNm1")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm1\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm2")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm2\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm3")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm3\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm4")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm4\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm5")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm5\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm6")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm6\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm7")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm7\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm8")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm8\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm9")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm9\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("tableNm10")) {
            strSql.append("\n").append("\t\t\t\t\t, TableNm10\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("etcDesc")) {
            strSql.append("\n").append("\t\t\t\t\t, EtcDesc\t\t= ? \t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append("\t\t\t\t\t, Notes\t\t     = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("syncFl")) {
            strSql.append("\n").append("\t\t\t\t\t, SyncFl\t\t     = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tWHERE SiteCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("tableNm1")) {
                    pstmt.setString(index++, info.getString("tableNm1"));
                }
                if (info.isExist("tableNm2")) {
                    pstmt.setString(index++, info.getString("tableNm2"));
                }
                if (info.isExist("tableNm3")) {
                    pstmt.setString(index++, info.getString("tableNm3"));
                }
                if (info.isExist("tableNm4")) {
                    pstmt.setString(index++, info.getString("tableNm4"));
                }
                if (info.isExist("tableNm5")) {
                    pstmt.setString(index++, info.getString("tableNm5"));
                }
                if (info.isExist("tableNm6")) {
                    pstmt.setString(index++, info.getString("tableNm6"));
                }
                if (info.isExist("tableNm7")) {
                    pstmt.setString(index++, info.getString("tableNm7"));
                }
                if (info.isExist("tableNm8")) {
                    pstmt.setString(index++, info.getString("tableNm8"));
                }
                if (info.isExist("tableNm9")) {
                    pstmt.setString(index++, info.getString("tableNm9"));
                }
                if (info.isExist("tableNm10")) {
                    pstmt.setString(index++, info.getString("tableNm10"));
                }
                if (info.isExist("etcDesc")) {
                    pstmt.setString(index++, info.getString("etcDesc"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                if (info.isExist("syncFl")) {
                    pstmt.setString(index++, info.getString("syncFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_MGMT_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteMemMgmtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t   DELETE /* MEMBER_MGMT_INFO_DELETE */ FROM KCTR01CT\t");
        strSql.append("\n").append(" \t\tWHERE SiteCd\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_MGMT_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchMemList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SEARCH */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append("                    , SecPswd2 ");
        strSql.append("\n").append("                    , SecPswdFlag ");
        strSql.append("\n").append("                    , SecPswd1 ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t     AND CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t     AND Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t     AND Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t     AND Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t     AND BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(GradeCd,NULL,'GNR',GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t     AND BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchMemListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SEARCH_PAGE */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append("                    , SecPswd2 ");
        strSql.append("\n").append("                    , SecPswdFlag ");
        strSql.append("\n").append("                    , SecPswd1 ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t     AND CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t     AND Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t     AND Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t     AND Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t     AND BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(GradeCd,NULL,'GNR',GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t     AND BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getMemListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SEARCH_COUNT */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t     AND CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t     AND Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t     AND Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t     AND Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t     AND BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(GradeCd,NULL,'GNR',GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t     AND BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberMstEntity selectMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) ReslNo2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append(" \t\t\t\t   , TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append("                    , secPswd2 ");
        strSql.append("\n").append("                    , secPswdFlag ");
        strSql.append("\n").append("                    , secPswd1 ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberMstEntity selectMember2(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) ReslNo2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append("                    , SecPswd2 ");
        strSql.append("\n").append("                    , SecPswdFlag ");
        strSql.append("\n").append("                    , SecPswd1 ");
        strSql.append("\n").append(" \t\t\t\t   , TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
            strSql.append("\n").append("\t\t\t    AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("                AND \"SEC_RESLNO2\" = \"DAMO\".\"ENC_VARCHAR_PE\"( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2',  ?)   ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberMstEntity selectMemberSimple(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT_SIMPLE */\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) RESLNO2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswdFlag\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , BadFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT_SIMPLE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_INSERT */ INTO " + this.memInfo.tableNm1 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("othBrandCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("                    , USkinTp                                                           ");
        strSql.append("\n").append("                    , USkinTrb                                                      \t");
        strSql.append("\n").append("                    , UCstmId                                                           ");
        strSql.append("\n").append("                    , CstmCardNo                                                    ");
        strSql.append("\n").append("                    , EAIFl                                                             \t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, secPswd2, secPswdFlag\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("othBrandCd")) {
            strSql.append("\n").append(" \t\t, TO_CHAR(SYSDATE, 'YYYYMMDD')\t\t\t\t\t\t");
        }
        strSql.append("\n").append("             , ?, ?, ?, ?, ?                                                           \t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?, ?, ?\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("cstmNm"));
                pstmt.setString(index++, info.getString("reslNo1"));
                pstmt.setString(index++, info.getString("reslNo2"));
                pstmt.setString(index++, info.getString("sex"));
                pstmt.setString(index++, info.getString("brthDate"));
                pstmt.setString(index++, info.getString("brthDateTp"));
                pstmt.setString(index++, info.getString("gnrt"));
                pstmt.setString(index++, info.getString("homeZip1"));
                pstmt.setString(index++, info.getString("homeZip2"));
                pstmt.setString(index++, info.getString("homeAddr1"));
                pstmt.setString(index++, info.getString("homeAddr2"));
                pstmt.setString(index++, info.getString("cmpyZip1"));
                pstmt.setString(index++, info.getString("cmpyZip2"));
                pstmt.setString(index++, info.getString("cmpyAddr1"));
                pstmt.setString(index++, info.getString("cmpyAddr2"));
                pstmt.setString(index++, info.getString("homePhoneNo1"));
                pstmt.setString(index++, info.getString("homePhoneNo2"));
                pstmt.setString(index++, info.getString("homePhoneNo3"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo1"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo2"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo3"));
                pstmt.setString(index++, info.getString("mobileNo1"));
                pstmt.setString(index++, info.getString("mobileNo2"));
                pstmt.setString(index++, info.getString("mobileNo3"));
                pstmt.setString(index++, info.getString("email1"));
                pstmt.setString(index++, info.getString("email2"));
                pstmt.setString(index++, info.getString("mainContpt"));
                pstmt.setString(index++, info.getString("dmRcvFl"));
                pstmt.setString(index++, info.getString("wedFl"));
                pstmt.setString(index++, info.getString("wedDate"));
                pstmt.setString(index++, info.getString("realNameFl"));
                pstmt.setString(index++, info.getString("pswd"));
                pstmt.setString(index++, info.getString("secPswd"));
                pstmt.setString(index++, info.getString("skinTp"));
                pstmt.setString(index++, info.getString("skinTrb"));
                pstmt.setString(index++, info.getString("jobCd"));
                pstmt.setString(index++, info.getString("othBrandCd"));
                pstmt.setString(index++, info.getString("uSkinTp"));
                pstmt.setString(index++, info.getString("uSkinTrb"));
                pstmt.setString(index++, info.getString("uCstmId"));
                pstmt.setString(index++, info.getString("cstmCardNo"));
                pstmt.setString(index++, info.getString("eaiFl"));
                pstmt.setString(index++, info.getString("secPswd2"));
                pstmt.setString(index++, info.getString("secPswdFlag"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                this.updateMemberInfoAddr(info);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_UPDATE */ " + this.memInfo.tableNm1 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t= CstmId\t\t\t\t\t\t");
        if (info.isExist("cstmNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("reslNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("reslNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("sex")) {
            strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("brthDate")) {
            strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("brthDateTp")) {
            strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("gnrt")) {
            strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeZip1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeZip2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeAddr1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeAddr2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyZip1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyZip2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyAddr1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyAddr2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homePhoneNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t= ?\t\t\t");
        }
        if (info.isExist("homePhoneNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t= ?\t\t\t");
        }
        if (info.isExist("homePhoneNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t= ?\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t= ?\t\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t= ?\t\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t= ?\t\t\t\t");
        }
        if (info.isExist("mobileNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("mobileNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("mobileNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("email1")) {
            strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("email2")) {
            strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("mainContpt")) {
            strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("dmRcvFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("wedFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("wedDate")) {
            strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("realNameFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("pswd")) {
            strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("secPswd")) {
            strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t= ''\t\t\t\t\t\t");
        }
        if (info.isExist("skinTp")) {
            strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("skinTrb")) {
            strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("jobCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("othBrandCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t= ?\t\t\t\t\t");
        }
        if (info.isEquals("othBrandChgFl", "Y")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt = TO_CHAR(SYSDATE, 'YYYYMMDD') ");
        }
        if (info.isExist("uSkinTp")) {
            strSql.append("\n").append("                    , USkinTp           = ?                     ");
        }
        if (info.isExist("uSkinTrb")) {
            strSql.append("\n").append("                    , USkinTrb      = ?                     ");
        }
        if (info.isExist("uCstmId")) {
            strSql.append("\n").append("                    , UCstmId           = ?                     ");
        }
        if (info.isExist("cstmCardNo")) {
            strSql.append("\n").append("                    , CstmCardNo    = ?                     ");
        }
        if (info.isExist("eaiFl")) {
            strSql.append("\n").append("                    , EAIFl             = ?                     ");
        }
        if (info.isExist("badFl")) {
            strSql.append("\n").append("                    , BadFl \t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("secPswd2")) {
            strSql.append("\n").append("                    , secPswd2 \t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("secPswdFlag")) {
            strSql.append("\n").append("                    , secPswdFlag \t\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("                    \t, secPswd1 \t\t\t= ''\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE CstmId\t= ?\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (info.isExist("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (info.isExist("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (info.isExist("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (info.isExist("brthDate")) {
                    pstmt.setString(index++, info.getString("brthDate"));
                }
                if (info.isExist("brthDateTp")) {
                    pstmt.setString(index++, info.getString("brthDateTp"));
                }
                if (info.isExist("gnrt")) {
                    pstmt.setString(index++, info.getString("gnrt"));
                }
                if (info.isExist("homeZip1")) {
                    pstmt.setString(index++, info.getString("homeZip1"));
                }
                if (info.isExist("homeZip2")) {
                    pstmt.setString(index++, info.getString("homeZip2"));
                }
                if (info.isExist("homeAddr1")) {
                    pstmt.setString(index++, info.getString("homeAddr1"));
                }
                if (info.isExist("homeAddr2")) {
                    pstmt.setString(index++, info.getString("homeAddr2"));
                }
                if (info.isExist("cmpyZip1")) {
                    pstmt.setString(index++, info.getString("cmpyZip1"));
                }
                if (info.isExist("cmpyZip2")) {
                    pstmt.setString(index++, info.getString("cmpyZip2"));
                }
                if (info.isExist("cmpyAddr1")) {
                    pstmt.setString(index++, info.getString("cmpyAddr1"));
                }
                if (info.isExist("cmpyAddr2")) {
                    pstmt.setString(index++, info.getString("cmpyAddr2"));
                }
                if (info.isExist("homePhoneNo1")) {
                    pstmt.setString(index++, info.getString("homePhoneNo1"));
                }
                if (info.isExist("homePhoneNo2")) {
                    pstmt.setString(index++, info.getString("homePhoneNo2"));
                }
                if (info.isExist("homePhoneNo3")) {
                    pstmt.setString(index++, info.getString("homePhoneNo3"));
                }
                if (info.isExist("cmpyPhoneNo1")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo1"));
                }
                if (info.isExist("cmpyPhoneNo2")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo2"));
                }
                if (info.isExist("cmpyPhoneNo3")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo3"));
                }
                if (info.isExist("mobileNo1")) {
                    pstmt.setString(index++, info.getString("mobileNo1"));
                }
                if (info.isExist("mobileNo2")) {
                    pstmt.setString(index++, info.getString("mobileNo2"));
                }
                if (info.isExist("mobileNo3")) {
                    pstmt.setString(index++, info.getString("mobileNo3"));
                }
                if (info.isExist("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (info.isExist("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (info.isExist("mainContpt")) {
                    pstmt.setString(index++, info.getString("mainContpt"));
                }
                if (info.isExist("dmRcvFl")) {
                    pstmt.setString(index++, info.getString("dmRcvFl"));
                }
                if (info.isExist("wedFl")) {
                    pstmt.setString(index++, info.getString("wedFl"));
                }
                if (info.isExist("wedDate")) {
                    pstmt.setString(index++, info.getString("wedDate"));
                }
                if (info.isExist("realNameFl")) {
                    pstmt.setString(index++, info.getString("realNameFl"));
                }
                if (info.isExist("pswd")) {
                    pstmt.setString(index++, info.getString("pswd"));
                }
                if (info.isExist("secPswd")) {
                    pstmt.setString(index++, info.getString("secPswd"));
                }
                if (info.isExist("skinTp")) {
                    pstmt.setString(index++, info.getString("skinTp"));
                }
                if (info.isExist("skinTrb")) {
                    pstmt.setString(index++, info.getString("skinTrb"));
                }
                if (info.isExist("jobCd")) {
                    pstmt.setString(index++, info.getString("jobCd"));
                }
                if (info.isExist("othBrandCd")) {
                    pstmt.setString(index++, info.getString("othBrandCd"));
                }
                if (info.isExist("uSkinTp")) {
                    pstmt.setString(index++, info.getString("uSkinTp"));
                }
                if (info.isExist("uSkinTrb")) {
                    pstmt.setString(index++, info.getString("uSkinTrb"));
                }
                if (info.isExist("uCstmId")) {
                    pstmt.setString(index++, info.getString("uCstmId"));
                }
                if (info.isExist("cstmCardNo")) {
                    pstmt.setString(index++, info.getString("cstmCardNo"));
                }
                if (info.isExist("eaiFl")) {
                    pstmt.setString(index++, info.getString("eaiFl"));
                }
                if (info.isExist("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                if (info.isExist("secPswd2")) {
                    pstmt.setString(index++, info.getString("secPswd2"));
                }
                if (info.isExist("secPswdFlag")) {
                    pstmt.setString(index++, info.getString("secPswdFlag"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
                this.updateMemberInfoAddr(info);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        finally {
            System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u01ae \ufffd\ufffd ::::::::::::::::::::::::::::::::::::::");
            this.closePreparedStatement(pstmt);
        }
        return result;
    }

    public int deleteMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_DELETE */ FROM  " + this.memInfo.tableNm1);
        strSql.append("\n").append(" \t\tWHERE CstmId\t= ?\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchSiteMemList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, C.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ip\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A \t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND B.ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("GradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchSiteMemList2(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, C.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ip\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A \t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo2")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo2 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("GradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchSiteMemListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH_PAGE */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, C.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ip\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A ");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND B.ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchSiteMemListPaging2(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH_PAGE */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, C.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ip\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A ");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo2")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo2 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getSiteMemListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH_COUNT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A \t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND B.ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getSiteMemListCnt2(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SEARCH_COUNT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t/*+ORDERED USE_NL(A C)*/\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + " B, UCOM01MT C, " + this.memInfo.tableNm2 + " A \t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = C.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo2")) {
            strSql.append("\n").append(" \t\t\t AND B.ReslNo2 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND B.CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t\t     AND B.Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t\t     AND B.Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t\t     AND B.Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t\t     AND B.BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND B.UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t\t     AND B.BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public SiteMemberEntity selectSiteMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SiteMemberEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SELECT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.IP\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append("                    , B.secPswd2 ");
        strSql.append("\n").append("                    , B.secPswdFlag ");
        strSql.append("\n").append("                    , B.secPswd1 ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm2 + " A, " + this.memInfo.tableNm1 + " B\t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = (SiteMemberEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertSiteMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* SITE_MEMBER_INSERT */ INTO " + this.memInfo.tableNm2 + "(");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, FnlLoginDate\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, IP\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, TO_CHAR(SYSDATE,'YYYYMMDD'), 0, NULL, ?\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getIPAddr());
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateSiteMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* SITE_MEMBER_UPDATE */ " + this.memInfo.tableNm2 + " SET\t");
        strSql.append("\n").append(" \t\t\t\tLoginCnt\t\t= LoginCnt + 1\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t, FnlLoginDate = SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t, ip\t\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getIPAddr());
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteSiteMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* SITE_MEMBER_UPDATE */ FROM  " + this.memInfo.tableNm2);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ? \t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchLeaveList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_LEAVE_HISTORY_SEARCH */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LeaveDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LeaveRsnCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LeaveRsn\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ExpelFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , nvl(B.GRADECD,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.UCSTMID ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm10 + " A, " + this.memInfo.tableNm1 + " B ");
        strSql.append("\n").append("             WHERE 1 = 1        ");
        strSql.append("\n").append("                 AND A.CSTMID = B.CSTMID ");
        if (info.isExist("siteCd") && !info.isSpace("siteCd")) {
            strSql.append("\n").append("                 AND A.SiteCd = ?                                                           ");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmNm = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
            strSql.append("\n").append("\t\t\t     AND A.ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t     AND A.ReslNo2 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("expelFl")) {
            strSql.append("\n").append("\t\t\t     AND A.ExpelFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("gradeCd") && !info.isSpace("gradeCd")) {
            strSql.append("\n").append("                 AND decode(B.GradeCd,NULL,'GNR',B.GradeCd) = ? ");
        }
        if (info.isExist("ucstmId") && !info.isSpace("ucstmId")) {
            strSql.append("\n").append("                 AND B.UcstmId =? ");
        }
        strSql.append("\n").append("\t\t\t     ORDER BY Seq\tDesc\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("expelFl")) {
                    pstmt.setString(index++, info.getString("expelFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchLeaveListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_LEAVE_HISTORY_SEARCH_PAGE */\t\t\t        ");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveDate\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsnCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsn\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ExpelFl\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM ").append(this.memInfo.tableNm10);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t                                            ");
        if (info.isExist("siteCd") && !info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND SiteCd = ?\t\t\t\t\t\t\t\t\t\t    ");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND CstmId = ?\t\t\t\t\t\t\t\t\t\t    ");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND CstmNm =  ?\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
            strSql.append("\n").append("\t\t\t     AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t     AND ReslNo2 = ?\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("expelFl")) {
            strSql.append("\n").append("\t\t\t     AND ExpelFl = ?\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t     ORDER BY Seq\tDesc\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (info.isExist("siteCd") && !info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("expelFl")) {
                    pstmt.setString(index++, info.getString("expelFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getLeaveListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_LEAVE_HISTORY_COUNT */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM ").append(this.memInfo.tableNm10);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t");
        if (info.isExist("siteCd") && !info.isSpace("siteCd")) {
            strSql.append("\n").append("                 AND SiteCd = ?                                     ");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND CstmId = ?\t\t\t\t\t\t\t\t\t    ");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t\t     AND CstmNm =  ?\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
            strSql.append("\n").append("\t\t\t     AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t     AND ReslNo2 = ?\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("expelFl")) {
            strSql.append("\n").append("\t\t\t     AND ExpelFl = ?\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (info.isExist("siteCd") && !info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (!info.isSpace("expelFl")) {
                    pstmt.setString(index++, info.getString("expelFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getLeaveCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_LEAVE_HISTORY_COUNT */\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm10 + "\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberHistoryEntity selectLeaveInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberHistoryEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_LEAVE_HISTORY_SELECT */\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveDate\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsnCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsn\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ExpelFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm10 + "\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setLong(index++, info.getLong("seq"));
                rs = pstmt.executeQuery();
                result = (MemberHistoryEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertLeaveInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_LEAVE_HISTORY_INSERT */ INTO " + this.memInfo.tableNm10 + "(");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveDate\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsnCd\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsn\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ExpelFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM " + this.memInfo.tableNm10 + " WHERE SiteCd = ? ), ?, ?, ?, ?\t");
        strSql.append("\n").append(" \t\t\t , TO_CHAR(SYSDATE,'YYYYMMDD'), ?, ?, ?\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, "");
                pstmt.setString(index++, "");
                pstmt.setString(index++, "");
                pstmt.setString(index++, info.getString("leaveRsnCd"));
                pstmt.setString(index++, info.getString("leaveRsn"));
                pstmt.setString(index++, info.getString("expelFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int insertLeaveInfoEDK(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_LEAVE_HISTORY_INSERT */ INTO ECTR03MT (");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveDate\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsnCd\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LeaveRsn\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM ECTR03MT WHERE SiteCd = ? ), ?\t");
        strSql.append("\n").append(" \t\t\t , TO_CHAR(SYSDATE,'YYYYMMDD'), ?, ?\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("leaveRsnCd"));
                pstmt.setString(index++, info.getString("leaveRsn"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_INSERT_DEK", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteRecvrMember(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_RECVR_DELETE */ FROM ETUDEUSER.WETH24DT ");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_RECVR_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateLeaveInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_LEAVE_HISTORY_UPDATE */ " + this.memInfo.tableNm10 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t= CstmId\t\t\t\t\t\t");
        if (info.isExist("leaveRsnCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, LeaveRsnCd\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("leaveRsn")) {
            strSql.append("\n").append(" \t\t\t\t\t, LeaveRsn\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("expelFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, ExpelFl\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE SiteCd\t= ?\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t   AND Seq\t= ?\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("leaveRsnCd")) {
                    pstmt.setString(index++, info.getString("leaveRsnCd"));
                }
                if (info.isExist("leaveRsn")) {
                    pstmt.setString(index++, info.getString("leaveRsn"));
                }
                if (info.isExist("expelFl")) {
                    pstmt.setString(index++, info.getString("expelFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setLong(index++, info.getLong("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteLeaveInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_LEAVE_HISTORY_DELETE */ FROM  " + this.memInfo.tableNm10);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ?\t\t\t\t\t\t\t");
        if (info.isExist("seq")) {
            strSql.append("\n").append("\t\t\t    AND Seq = ? \t\t\t\t\t\t\t\t");
        } else if (info.isExist("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (info.isExist("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                } else if (info.isExist("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_LEAVE_HISTORY_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchAddItemList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_ADD_INFO_SEARCH */\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddItem\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustCat\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustDesc\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm5 + "\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("useFl")) {
            strSql.append("\n").append("\t\t\t   AND UseFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("useFl")) {
            strSql.append("\n").append("\t\t\t   AND UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberSubEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_ADD_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberSubEntity selectAddItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberSubEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_ADD_INFO_SELECT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddItem\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustCat\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustDesc\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm5 + "\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND AddItem = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("addItem"));
                rs = pstmt.executeQuery();
                result = (MemberSubEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberSubEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_ADD_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertAddItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* SITE_ADD_INFO_INSERT */ INTO " + this.memInfo.tableNm5 + "(");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddItem\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustCat\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, QustDesc\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("addItem"));
                pstmt.setString(index++, info.getString("qustNm"));
                pstmt.setString(index++, info.getString("qustCat"));
                pstmt.setString(index++, info.getString("qustDesc"));
                pstmt.setString(index++, info.getString("baseCd"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_ADD_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateAddItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* SITE_ADD_INFO_UPDATE */ " + this.memInfo.tableNm5 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tAddItem\t\t\t= AddItem\t\t\t\t");
        if (info.isExist("qustNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, QustNm\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("qustCat")) {
            strSql.append("\n").append(" \t\t\t\t\t, QustCat\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("qustDesc")) {
            strSql.append("\n").append(" \t\t\t\t\t, QustDesc\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("baseCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, BaseCd\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE SiteCd\t= ?\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t   and AddItem\t= ?\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("qustNm")) {
                    pstmt.setString(index++, info.getString("qustNm"));
                }
                if (info.isExist("qustCat")) {
                    pstmt.setString(index++, info.getString("qustCat"));
                }
                if (info.isExist("qustDesc")) {
                    pstmt.setString(index++, info.getString("qustDesc"));
                }
                if (info.isExist("baseCd")) {
                    pstmt.setString(index++, info.getString("baseCd"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setInt(index++, info.getInt("orderBy"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("addItem"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_ADD_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteAddItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* SITE_ADD_INFO_DELETE */ FROM  " + this.memInfo.tableNm5);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ?\t\t\t\t\t\t\t");
        if (info.isExist("addItem")) {
            strSql.append("\n").append("\t\t\t    AND AddItem = ?\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (info.isExist("addItem")) {
                    pstmt.setString(index++, info.getString("addItem"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_ADD_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchAddInfoList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_ADD_INFO_SEARCH */\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.AddItem\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ReplyVal\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Notes1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Notes2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm3 + " A, " + this.memInfo.tableNm5 + " B\t");
        strSql.append("\n").append("\t\t\t WHERE A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.AddItem = B.AddItem\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("useFl")) {
            strSql.append("\n").append("\t\t\t   AND B.UseFl = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("useFl")) {
            strSql.append("\n").append("\t\t\t   AND B.UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberSubEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberSubEntity selectAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberSubEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_ADD_INFO_SELECT */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddItem\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplyVal\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm3 + "\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND AddItem = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("addItem"));
                rs = pstmt.executeQuery();
                result = (MemberSubEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberSubEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_ADD_INFO_INSERT */ INTO " + this.memInfo.tableNm3 + "(");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, AddItem\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplyVal\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("addItem"));
                pstmt.setString(index++, info.getString("replyVal"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_ADD_INFO_UPDATE */ " + this.memInfo.tableNm3 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tReplyVal\t\t= ?\t\t\t\t\t");
        if (info.isExist("notes1")) {
            strSql.append("\n").append(" \t\t\t\t, Notes1\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("notes2")) {
            strSql.append("\n").append(" \t\t\t\t, Notes2\t\t\t= ?\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE SiteCd\t= ?\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t   AND CstmId\t= ?\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t   and AddItem\t= ?\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("replyVal"));
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (info.isExist("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("addItem"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_ADD_INFO_DELETE */ FROM  " + this.memInfo.tableNm3);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd = ?\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t");
        if (info.isExist("addItem")) {
            strSql.append("\n").append("\t\t\t    AND AddItem = ?\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                if (info.isExist("addItem")) {
                    pstmt.setString(index++, info.getString("addItem"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchPwdList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_PWD_SEARCH_PAGE */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvMobile\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RegDate,'YYYYMMDD') AS RegDate\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RegDate,'HH24:MI') AS RegTime\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RecvDate,'YYYYMMDD') AS RecvDate\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RecvDate,'HH24:MI') AS RecvTime\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm9 + " A, UCOM01MT B\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \t\t AND A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t     ORDER BY A.regDate\tDesc\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberPwdEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchPwdListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_PWD_SEARCH_PAGE */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvMobile\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RegDate,'YYYYMMDD') AS RegDate\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RegDate,'HH24:MI') AS RegTime\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RecvDate,'YYYYMMDD') AS RecvDate\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RecvDate,'HH24:MI') AS RecvTime\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm9 + " A, UCOM01MT B\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \t\t AND A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t     ORDER BY A.regDate\tDesc\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberPwdEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getPwdListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_PWD_COUNT */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm9 + "\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberPwdEntity selectMemPwdInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberPwdEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_PWD_SELECT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvMobile\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RegDate,'YYYYMMDD') AS RegDate\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RegDate,'HH24:MI') AS RegTime\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RecvIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.RecvDate,'YYYYMMDD') AS RecvDate\t");
        strSql.append("\n").append("\t\t\t\t\t\t, TO_CHAR(A.RecvDate,'HH24:MI') AS RecvTime\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm9 + " A, UCOM01MT B\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \t\t AND A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND A.Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("seq"));
                rs = pstmt.executeQuery();
                result = (MemberPwdEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberPwdEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMemberPwd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_PWD_INSERT */ INTO " + this.memInfo.tableNm9 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvMobile\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, RegDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvIp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM " + this.memInfo.tableNm9 + " WHERE SiteCd = ? AND CstmId = ? )  ");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, SYSDATE, ?, ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("recvEmail"));
                pstmt.setString(index++, info.getString("recvMobile"));
                pstmt.setString(index++, info.getIPAddr());
                pstmt.setString(index++, info.getString("RecvIp"));
                pstmt.setString(index++, info.getString("RecvDate"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateMemberPwd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_PWD_UPDATE */ " + this.memInfo.tableNm9 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t= CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (info.isExist("recvEmail")) {
            strSql.append("\n").append(" \t\t\t\t\t, recvEmail\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("recvMobile")) {
            strSql.append("\n").append(" \t\t\t\t\t, recvMobile\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("recvIp")) {
            strSql.append("\n").append(" \t\t\t\t\t, recvIp\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append(" \t\t\t\t\t\t, recvDate\t\t= SYSDATE\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE CstmId\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tAND SiteCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tAND Seq\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("recvEmail")) {
                    pstmt.setString(index++, info.getString("recvEmail"));
                }
                if (info.isExist("recvMobile")) {
                    pstmt.setString(index++, info.getString("recvMobile"));
                }
                if (info.isExist("recvIp")) {
                    pstmt.setString(index++, info.getString("recvIp"));
                }
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_PWD_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public String getMaxPwdSeq(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\tSELECT /* MAX_SEQ */ MAX(Seq) AS Seq FROM " + this.memInfo.tableNm9 + " WHERE CstmId = ? AND SiteCd = ?\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MAX_SEQ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchMemSiteList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_JOIN_MEMLIST_SEARCH */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ip\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm2 + " A, UCOM01MT B\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1=1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = B.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND B.FAMILYFL='Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t     AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_JOIN_MEMLIST_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchSiteList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* BRAND_SITE_LIST_SEARCH */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSITECD\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SITENM\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1=1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND FAMILYFL = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND USEFL = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND (SITETP='BRD' OR SITECD='AAK')\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t ORDER BY ORDERBY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_SITE_LIST_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteSiteAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* MEMBER_ADD_INFO_DELETE */ FROM  " + this.memInfo.tableNm3);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd in ( \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   \t\tSELECT SiteCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \tWHERE FamilyFl = 'Y' \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND UseFl = 'Y' \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND (SiteTp = 'BRD' OR SiteCd = 'AAK') \t");
        strSql.append("\n").append("\t\t\t    \t  AND SiteCd NOT IN (\t\t \t\t\t\t\t\t\t");
        int i = 0;
        while (i < info.getArray("siteCd").length) {
            if (i == 0) {
                strSql.append("\n").append("\t\t\t    \t  ?\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t    \t  , ? \t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            }
            ++i;
        }
        strSql.append("\n").append("\t\t\t    \t  )\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  \t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                int i2 = 0;
                while (i2 < info.getArray("siteCd").length) {
                    pstmt.setString(index++, info.getArray("siteCd")[i2]);
                    ++i2;
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_ADD_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteSiteMemberInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* SITE_MEMBER_DELETE */ FROM  " + this.memInfo.tableNm2);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd in ( \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   \t\tSELECT SiteCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \tWHERE FamilyFl = 'Y' \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND UseFl = 'Y' \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND (SiteTp = 'BRD' OR SiteCd = 'AAK') \t");
        strSql.append("\n").append("\t\t\t    \t  AND SiteCd NOT IN (\t\t \t\t\t\t\t\t\t");
        int i = 0;
        while (i < info.getArray("siteCd").length) {
            if (i == 0) {
                strSql.append("\n").append("\t\t\t    \t  ?\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t    \t  , ? \t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            }
            ++i;
        }
        strSql.append("\n").append("\t\t\t    \t  )\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  \t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                int i2 = 0;
                while (i2 < info.getArray("siteCd").length) {
                    pstmt.setString(index++, info.getArray("siteCd")[i2]);
                    ++i2;
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchDelSiteList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t SELECT SiteCd /* SITE_DELETE_LIST */ FROM  " + this.memInfo.tableNm2);
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND SiteCd in ( \t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   \t\tSELECT SiteCd\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  FROM UCOM01MT\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \tWHERE FamilyFl = 'Y' \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND UseFl = 'Y' \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    \t  AND (SiteTp = 'BRD' OR SiteCd = 'AAK') \t");
        strSql.append("\n").append("\t\t\t    \t  AND SiteCd NOT IN (\t\t \t\t\t\t\t\t\t");
        int i = 0;
        while (i < info.getArray("siteCd").length) {
            if (i == 0) {
                strSql.append("\n").append("\t\t\t    \t  ?\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t    \t  , ? \t\t\t\t\t\t\t\t \t\t\t\t\t\t");
            }
            ++i;
        }
        strSql.append("\n").append("\t\t\t    \t  )\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  \t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                int i2 = 0;
                while (i2 < info.getArray("siteCd").length) {
                    pstmt.setString(index++, info.getArray("siteCd")[i2]);
                    ++i2;
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_DELETE_LIST", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateUCstmId(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         UPDATE /* UCSTMID_UPDATE */ " + this.memInfo.tableNm1 + " SET ");
        strSql.append("\n").append("                    UCstmId       = ?                            \t\t");
        if (!info.isSpace("intAprvFl")) {
            strSql.append("\n").append("        \t\t   , IntAprvFl    = ?                                  ");
        }
        strSql.append("\n").append("        WHERE CstmId    = ?                                     \t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("uCstmId"));
                if (!info.isSpace("intAprvFl")) {
                    pstmt.setString(index++, info.getString("intAprvFl"));
                }
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]UCSTMID_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchSiteRecieveList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT /* BRAND_SITE_YN_LIST_SEARCH */ ");
        strSql.append("\n").append("      A.SITECD ");
        strSql.append("\n").append("      , A.SITENM ");
        strSql.append("\n").append("      , NVL((SELECT NVL(ReplyVal,'N') FROM " + this.memInfo.tableNm3 + " WHERE ADDITEM = 'sms_yn' AND CSTMID=? AND SITECD = A.SITECD ),'N') as SMSYN ");
        strSql.append("\n").append("      , NVL((SELECT NVL(ReplyVal,'N') FROM " + this.memInfo.tableNm3 + " WHERE ADDITEM = 'letter_yn' AND CSTMID=? AND SITECD = A.SITECD ),'N') as LETTERYN ");
        strSql.append("\n").append("      , NVL((SELECT NVL(ReplyVal,'N') FROM " + this.memInfo.tableNm3 + " WHERE ADDITEM = 'mail_yn' AND CSTMID=? AND SITECD = A.SITECD ),'N') as MAILYN ");
        strSql.append("\n").append("   FROM UCOM01MT A ");
        strSql.append("\n").append("  WHERE 1=1 ");
        strSql.append("\n").append("     AND A.FAMILYFL = 'Y' ");
        strSql.append("\n").append("     AND A.USEFL = 'Y' ");
        strSql.append("\n").append("     AND (A.SITETP='BRD' OR A.SITECD='AAK') ");
        strSql.append("\n").append("  ORDER BY A.ORDERBY ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.SiteMemberRecieveYnEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_SITE_YN_LIST_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchBadMemberList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* BAD_MEMBER_HISTORY_PAGE */\t\t\t\t");
        strSql.append("\n").append(" \t                row_number() over ( order by A.FstRegDate Desc) AS ScreenNo                                         ");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.BadSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t    , A.BadTypeCd\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        strSql.append("\n").append(" \t\t\t\t    , ufo_getcdnm('G108',A.BadTypeCd) AS BadTypeNm  ");
        strSql.append("\n").append(" \t\t\t\t\t, A.BadStat\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getcdnm('G109',A.BadStat) AS BadStatNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ClsRsnCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getcdnm('G110',A.ClsRsnCd) AS ClsRsnNm\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYY.MM.DD HH24:MI:SS') AS FstRegDate\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM KCTR14DT A \t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  ORDER BY  A.FstRegDate Desc\t\t\t     \t\t\t            ");
        System.out.println("sql\u022e\ufffd\ufffd" + strSql);
        System.out.println("sql\ufffd\u0136\ufffd\ufffd\ufffd\ufffd \u022e\ufffd\ufffd " + info.getString("cstmId"));
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.BadMemberEntity");
                System.out.println("sql\ufffd\ufffd\ufffd\u022e\ufffd\ufffd" + result.size());
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BAD_MEMBER_HISTORY ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchBadMemberPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* BAD_MEMBER_HISTORY_PAGE */\t\t\t\t");
        strSql.append("\n").append(" \t                row_number() over ( order by A.FstRegDate Desc) AS ScreenNo                                         ");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.BadSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t    , A.BadTypeCd\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        strSql.append("\n").append(" \t\t\t\t    , ufo_getcdnm('G108',A.BadTypeCd) AS BadTypeNm  ");
        strSql.append("\n").append(" \t\t\t\t\t, A.BadStat\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getcdnm('G109',A.BadStat) AS BadStatNm\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.ClsRsnCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getcdnm('G110',A.ClsRsnCd) AS ClsRsnNm\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYY.MM.DD HH24:MI:SS') AS FstRegDate\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM KCTR14DT A \t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND A.CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t  ORDER BY  A.FstRegDate Desc\t\t\t     \t\t\t            ");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.BadMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BAD_MEMBER_HISTORY_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getBadMemberListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* BAD_MEMBER_HISTORY_COUNT */\t\t    ");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM KCTR14DT \t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t     AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BAD_MEMBER_HISTORY_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public BadMemberEntity selectBadMemberCd(String cstmId, String badTypeCd) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BadMemberEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t              SELECT /* BAD_MEMBER_CD_SELECT  */\t  ");
        strSql.append("\n").append(" \t                    BADSTAT,CLSRSNCD");
        strSql.append("\n").append(" \t\t             FROM                                          ");
        strSql.append("\n").append(" \t\t             ( ");
        strSql.append("\n").append(" \t\t             \tSELECT ROW_NUMBER() OVER (ORDER BY FSTREGDATE DESC) AS NO1 , BADSTAT ,CLSRSNCD ");
        strSql.append("\n").append(" \t\t            \t   FROM KCTR14DT                        ");
        strSql.append("\n").append(" \t\t                 WHERE 1 = 1                                 ");
        strSql.append("\n").append(" \t\t                      AND CSTMID = ?                      ");
        strSql.append("\n").append(" \t\t             \t\t  AND BADTYPECD =  ?              ");
        strSql.append("\n").append(" \t\t                 ORDER BY FSTREGDATE DESC    ");
        strSql.append("\n").append(" \t\t             ) WHERE NO1 =1");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, cstmId);
                pstmt.setString(index++, badTypeCd);
                rs = pstmt.executeQuery();
                result = (BadMemberEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.BadMemberEntity");
                if (result == null) {
                    result = new BadMemberEntity();
                }
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BAD_MEMBER_CD_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertBadMemberHistory(UFORequest info, String BadType) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         INSERT INTO /* BAD_MEMBER_HISTORY_INSERT */  KCTR14DT");
        strSql.append("\n").append("          (");
        strSql.append("\n").append("           CSTMID ");
        strSql.append("\n").append("           ,BADSEQ");
        strSql.append("\n").append("           ,BADTYPECD");
        strSql.append("\n").append("           ,BADSTAT");
        strSql.append("\n").append("           ,CLSRSNCD");
        strSql.append("\n").append("           ,FSTREGDATE ");
        strSql.append("\n").append("           ,REGID ");
        strSql.append("\n").append("          )");
        strSql.append("\n").append("          VALUES ");
        strSql.append("\n").append("          ( ?,  (SELECT NVL(MAX(BADSEQ),0)+1 FROM KCTR14DT WHERE CSTMID = ? )  , ?, ? , ?, SYSDATE, ? ) ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, BadType);
                if ("B1".equals(BadType)) {
                    pstmt.setString(index++, info.getString("badTypeClsCd"));
                    pstmt.setString(index++, CmUtil.nullTrim(info.getString("badClsRsnCd")));
                } else {
                    pstmt.setString(index++, info.getString("badTypeClnCd"));
                    pstmt.setString(index++, " ");
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BAD_MEMBER_HISTORY_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateMemberInfoAddr(UFORequest info) throws UFOException {
        String detailTableName;
        StringBuffer strSql;
        String strCstmid;
        PreparedStatement pstmt;
        int result;
        block10: {
            result = 0;
            pstmt = null;
            strCstmid = info.getString("cstmId");
            String zip1 = info.getString("infoAddrVo1_zip1");
            if (zip1 == null || zip1.length() <= 0) return result;
            String masterTableName = this.memInfo.tableNm1;
            strSql = new StringBuffer();
            strSql.append("\n").append("\tUPDATE " + masterTableName + " SET\t\t");
            strSql.append("\n").append("\t\t\t\t  ADDRTPCD = ?          ");
            strSql.append("\n").append("\t\t\t\t, ADDRGETCD = ?         ");
            strSql.append("\n").append("\t\t\t\t, UNQBLDMNO = ?         ");
            strSql.append("\n").append("\t\t\t\t, XCORDNAT = ?          ");
            strSql.append("\n").append("\t\t\t\t, YCORDNAT = ?          ");
            strSql.append("\n").append("\t\t\t\t, ADDRREFRST = ?        ");
            strSql.append("\n").append("\t\t\tWHERE\tCSTMID = ?\t\t\t");
            pstmt = this.con.prepareStatement(strSql.toString());
            detailTableName = "KCTR31DT";
            if (masterTableName != null && masterTableName.equals("YCTR01MT")) {
                detailTableName = "YCTR31DT";
                break block10;
            }
            if (masterTableName != null && masterTableName.equals("KCTR01MT")) break block10;
            this.closePreparedStatement(pstmt);
            return 0;
        }
        try {
            try {
                int index = 1;
                pstmt.setString(index++, info.getString("addrtpcd"));
                pstmt.setString(index++, info.getString("addrgetcd"));
                pstmt.setString(index++, info.getString("unqbldmno"));
                pstmt.setString(index++, info.getString("xcordnat"));
                pstmt.setString(index++, info.getString("ycordnat"));
                pstmt.setString(index++, info.getString("addrrefrst"));
                pstmt.setString(index++, strCstmid);
                result = pstmt.executeUpdate();
                StringBuffer strSqlDel = new StringBuffer();
                strSqlDel.append("\n").append("\tDELETE FROM " + detailTableName + "\t\t");
                strSqlDel.append("\n").append("\tWHERE  CSTMID = ?\t\t\t        ");
                pstmt = this.con.prepareStatement(strSqlDel.toString());
                index = 1;
                pstmt.setString(index++, strCstmid);
                result = pstmt.executeUpdate();
                strSql = new StringBuffer();
                strSql.append("\n").append(" INSERT INTO " + detailTableName + "                                 ");
                strSql.append("\n").append(" (                                                                 ");
                strSql.append("\n").append("     CSTMID    ,                                                   ");
                strSql.append("\n").append("     ADDRSEQ\t,                                                  ");
                strSql.append("\n").append("     ZIP1\t,                                                      ");
                strSql.append("\n").append("     ZIP2\t,                                                      ");
                strSql.append("\n").append("     ADDR1\t,                                                      ");
                strSql.append("\n").append("     ADDR2\t,                                                      ");
                strSql.append("\n").append("     ADDRCHOICFL,                                                  ");
                strSql.append("\n").append("     ADDRTPCD   ,                                                  ");
                strSql.append("\n").append("     ADDRGETCD  ,                                                  ");
                strSql.append("\n").append("     UNQBLDMNO  ,                                                  ");
                strSql.append("\n").append("     XCORDNAT   ,                                                  ");
                strSql.append("\n").append("     YCORDNAT   ,                                                  ");
                strSql.append("\n").append("     ADDRREFRST ,                                                  ");
                strSql.append("\n").append("     REGID\t,                                                      ");
                strSql.append("\n").append("     REGDATE                                                       ");
                strSql.append("\n").append(" ) VALUES (                                                        ");
                strSql.append("\n").append("     ?,                                                            ");
                strSql.append("\n").append("     (SELECT NVL(MAX(ADDRSEQ),0)+1 FROM " + detailTableName + " WHERE CSTMID = ?),");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     ? ,                                                           ");
                strSql.append("\n").append("     SYSDATE\t\t\t                                           ");
                strSql.append("\n").append(" )\t\t\t                                                       ");
                index = 1;
                pstmt = this.con.prepareStatement(strSql.toString());
                pstmt.setString(index++, strCstmid);
                pstmt.setString(index++, strCstmid);
                pstmt.setString(index++, info.getString("infoAddrVo1_zip1"));
                pstmt.setString(index++, info.getString("infoAddrVo1_zip2"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addr1"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addr2"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addrchoicfl"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addrtpcd"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addrgetcd"));
                pstmt.setString(index++, info.getString("infoAddrVo1_unqbldmno"));
                pstmt.setString(index++, info.getString("infoAddrVo1_xcordnat"));
                pstmt.setString(index++, info.getString("infoAddrVo1_ycordnat"));
                pstmt.setString(index++, info.getString("infoAddrVo1_addrrefrst"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                String chkZip = info.getString("infoAddrVo2_zip1");
                if (chkZip != null && chkZip.length() > 0) {
                    index = 1;
                    pstmt = this.con.prepareStatement(strSql.toString());
                    pstmt.setString(index++, strCstmid);
                    pstmt.setString(index++, strCstmid);
                    pstmt.setString(index++, info.getString("infoAddrVo2_zip1"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_zip2"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addr1"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addr2"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addrchoicfl"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addrtpcd"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addrgetcd"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_unqbldmno"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_xcordnat"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_ycordnat"));
                    pstmt.setString(index++, info.getString("infoAddrVo2_addrrefrst"));
                    pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                    result = pstmt.executeUpdate();
                }
                if ((chkZip = info.getString("infoAddrVo3_zip1")) == null || chkZip.length() <= 0) return result;
                index = 1;
                pstmt = this.con.prepareStatement(strSql.toString());
                pstmt.setString(index++, strCstmid);
                pstmt.setString(index++, strCstmid);
                pstmt.setString(index++, info.getString("infoAddrVo3_zip1"));
                pstmt.setString(index++, info.getString("infoAddrVo3_zip2"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addr1"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addr2"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addrchoicfl"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addrtpcd"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addrgetcd"));
                pstmt.setString(index++, info.getString("infoAddrVo3_unqbldmno"));
                pstmt.setString(index++, info.getString("infoAddrVo3_xcordnat"));
                pstmt.setString(index++, info.getString("infoAddrVo3_ycordnat"));
                pstmt.setString(index++, info.getString("infoAddrVo3_addrrefrst"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                return result;
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateMemberInfoAddr", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]updateMemberInfoAddr", etcEx);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.closePreparedStatement(pstmt);
        }
    }

    public MemberMstEntity selectMemberOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) ReslNo2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append(" \t\t\t\t   , TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public SiteMemberEntity selectSiteMemberOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SiteMemberEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* SITE_MEMBER_SELECT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.JoinDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.LoginCnt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FnlLoginDate, 'YYYYMMDD') AS FnlLoginDate\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.IP\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , B.USkinTp ");
        strSql.append("\n").append("                    , B.USkinTrb ");
        strSql.append("\n").append("                    , B.UcstmId ");
        strSql.append("\n").append("                    , B.CstmCardNo ");
        strSql.append("\n").append("                    , B.EaiFl ");
        strSql.append("\n").append("                    , B.CstmEngNm ");
        strSql.append("\n").append("                    , nvl(B.GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(B.GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , B.IntAprvFl ");
        strSql.append("\n").append("                    , B.RnmAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthFl ");
        strSql.append("\n").append("                    , B.IpinAuthDate ");
        strSql.append("\n").append("                    , B.IpinAuthDi ");
        strSql.append("\n").append("                    , B.IpinAuthCi ");
        strSql.append("\n").append("                    , B.badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm2 + " A, " + this.memInfo.tableNm1 + " B\t");
        strSql.append("\n").append("\t\t\t WHERE A.CstmId = B.CstmId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t    AND A.CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cstmId"));
                rs = pstmt.executeQuery();
                result = (SiteMemberEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.SiteMemberEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SITE_MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int pswdSha512Update(UFORequest info) throws UFOException {
        int result = 0;
        PreparedStatement pstmt = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  UPDATE \t" + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("   SET secPswd2 =?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  , secPswdFlag = 'Y' \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  , fnlModDate = SYSDATE\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  , secPswd1 = ''\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  , secPswd = ''\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  , modId =  ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("  WHERE CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int idx = 1;
                pstmt.setString(idx++, info.getString("secPswd2"));
                pstmt.setString(idx++, info.getString("cstmId"));
                pstmt.setString(idx++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateMemberInfoAddr", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]updateMemberInfoAddr", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updateMemberOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* MEMBER_UPDATE */ " + this.memInfo.tableNm1 + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t= CstmId\t\t\t\t\t\t");
        if (info.isExist("cstmNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("reslNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("reslNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("sex")) {
            strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("brthDate")) {
            strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("brthDateTp")) {
            strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("gnrt")) {
            strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeZip1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeZip2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeAddr1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homeAddr2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyZip1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyZip2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyAddr1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("cmpyAddr2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("homePhoneNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t= ?\t\t\t");
        }
        if (info.isExist("homePhoneNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t= ?\t\t\t");
        }
        if (info.isExist("homePhoneNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t= ?\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t= ?\t\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t= ?\t\t\t\t");
        }
        if (info.isExist("cmpyPhoneNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t= ?\t\t\t\t");
        }
        if (info.isExist("mobileNo1")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("mobileNo2")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("mobileNo3")) {
            strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("email1")) {
            strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("email2")) {
            strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("mainContpt")) {
            strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("dmRcvFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("wedFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("wedDate")) {
            strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("realNameFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("pswd")) {
            strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("secPswd")) {
            strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("skinTp")) {
            strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("skinTrb")) {
            strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("jobCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("othBrandCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t= ?\t\t\t\t\t");
        }
        if (info.isEquals("othBrandChgFl", "Y")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt = TO_CHAR(SYSDATE, 'YYYYMMDD') ");
        }
        if (info.isExist("uSkinTp")) {
            strSql.append("\n").append("                    , USkinTp           = ?                     ");
        }
        if (info.isExist("uSkinTrb")) {
            strSql.append("\n").append("                    , USkinTrb      = ?                     ");
        }
        if (info.isExist("uCstmId")) {
            strSql.append("\n").append("                    , UCstmId           = ?                     ");
        }
        if (info.isExist("cstmCardNo")) {
            strSql.append("\n").append("                    , CstmCardNo    = ?                     ");
        }
        if (info.isExist("eaiFl")) {
            strSql.append("\n").append("                    , EAIFl             = ?                     ");
        }
        if (info.isExist("badFl")) {
            strSql.append("\n").append("                    , BadFl \t\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE CstmId\t= ?\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (info.isExist("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (info.isExist("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                if (info.isExist("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (info.isExist("brthDate")) {
                    pstmt.setString(index++, info.getString("brthDate"));
                }
                if (info.isExist("brthDateTp")) {
                    pstmt.setString(index++, info.getString("brthDateTp"));
                }
                if (info.isExist("gnrt")) {
                    pstmt.setString(index++, info.getString("gnrt"));
                }
                if (info.isExist("homeZip1")) {
                    pstmt.setString(index++, info.getString("homeZip1"));
                }
                if (info.isExist("homeZip2")) {
                    pstmt.setString(index++, info.getString("homeZip2"));
                }
                if (info.isExist("homeAddr1")) {
                    pstmt.setString(index++, info.getString("homeAddr1"));
                }
                if (info.isExist("homeAddr2")) {
                    pstmt.setString(index++, info.getString("homeAddr2"));
                }
                if (info.isExist("cmpyZip1")) {
                    pstmt.setString(index++, info.getString("cmpyZip1"));
                }
                if (info.isExist("cmpyZip2")) {
                    pstmt.setString(index++, info.getString("cmpyZip2"));
                }
                if (info.isExist("cmpyAddr1")) {
                    pstmt.setString(index++, info.getString("cmpyAddr1"));
                }
                if (info.isExist("cmpyAddr2")) {
                    pstmt.setString(index++, info.getString("cmpyAddr2"));
                }
                if (info.isExist("homePhoneNo1")) {
                    pstmt.setString(index++, info.getString("homePhoneNo1"));
                }
                if (info.isExist("homePhoneNo2")) {
                    pstmt.setString(index++, info.getString("homePhoneNo2"));
                }
                if (info.isExist("homePhoneNo3")) {
                    pstmt.setString(index++, info.getString("homePhoneNo3"));
                }
                if (info.isExist("cmpyPhoneNo1")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo1"));
                }
                if (info.isExist("cmpyPhoneNo2")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo2"));
                }
                if (info.isExist("cmpyPhoneNo3")) {
                    pstmt.setString(index++, info.getString("cmpyPhoneNo3"));
                }
                if (info.isExist("mobileNo1")) {
                    pstmt.setString(index++, info.getString("mobileNo1"));
                }
                if (info.isExist("mobileNo2")) {
                    pstmt.setString(index++, info.getString("mobileNo2"));
                }
                if (info.isExist("mobileNo3")) {
                    pstmt.setString(index++, info.getString("mobileNo3"));
                }
                if (info.isExist("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (info.isExist("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (info.isExist("mainContpt")) {
                    pstmt.setString(index++, info.getString("mainContpt"));
                }
                if (info.isExist("dmRcvFl")) {
                    pstmt.setString(index++, info.getString("dmRcvFl"));
                }
                if (info.isExist("wedFl")) {
                    pstmt.setString(index++, info.getString("wedFl"));
                }
                if (info.isExist("wedDate")) {
                    pstmt.setString(index++, info.getString("wedDate"));
                }
                if (info.isExist("realNameFl")) {
                    pstmt.setString(index++, info.getString("realNameFl"));
                }
                if (info.isExist("pswd")) {
                    pstmt.setString(index++, info.getString("pswd"));
                }
                if (info.isExist("secPswd")) {
                    pstmt.setString(index++, info.getString("secPswd"));
                }
                if (info.isExist("skinTp")) {
                    pstmt.setString(index++, info.getString("skinTp"));
                }
                if (info.isExist("skinTrb")) {
                    pstmt.setString(index++, info.getString("skinTrb"));
                }
                if (info.isExist("jobCd")) {
                    pstmt.setString(index++, info.getString("jobCd"));
                }
                if (info.isExist("othBrandCd")) {
                    pstmt.setString(index++, info.getString("othBrandCd"));
                }
                if (info.isExist("uSkinTp")) {
                    pstmt.setString(index++, info.getString("uSkinTp"));
                }
                if (info.isExist("uSkinTrb")) {
                    pstmt.setString(index++, info.getString("uSkinTrb"));
                }
                if (info.isExist("uCstmId")) {
                    pstmt.setString(index++, info.getString("uCstmId"));
                }
                if (info.isExist("cstmCardNo")) {
                    pstmt.setString(index++, info.getString("cstmCardNo"));
                }
                if (info.isExist("eaiFl")) {
                    pstmt.setString(index++, info.getString("eaiFl"));
                }
                if (info.isExist("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("cstmId"));
                result = pstmt.executeUpdate();
                this.updateMemberInfoAddr(info);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        finally {
            System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u01ae \ufffd\ufffd ::::::::::::::::::::::::::::::::::::::");
            this.closePreparedStatement(pstmt);
        }
        return result;
    }

    public MemberMstEntity selectMember2Old(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT */\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) ReslNo2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append(" \t\t\t\t   , TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
            strSql.append("\n").append("\t\t\t    AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("                AND \"SEC_RESLNO2\" = \"DAMO\".\"ENC_VARCHAR_PE\"( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2',  ?)   ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("reslNo1") && !info.isSpace("reslNo2")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                    pstmt.setString(index++, info.getString("reslNo2"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MemberMstEntity selectMemberSimpleOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MemberMstEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SELECT_SIMPLE */\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , SUBSTRB( DAMO.DEC_VARCHAR_PE( '" + this.tableOwner + "', '" + this.memInfo.tableNm1 + "', 'RESLNO2', \"SEC_RESLNO2\" ), 1, 7 ) RESLNO2 ");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                     , BadFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t    AND CstmId = ? \t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                rs = pstmt.executeQuery();
                result = (MemberMstEntity)DAOHelper.makeEntity(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SELECT_SIMPLE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMemberOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* MEMBER_INSERT */ INTO " + this.memInfo.tableNm1 + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("othBrandCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("                    , USkinTp                                                           ");
        strSql.append("\n").append("                    , USkinTrb                                                      \t");
        strSql.append("\n").append("                    , UCstmId                                                           ");
        strSql.append("\n").append("                    , CstmCardNo                                                    ");
        strSql.append("\n").append("                    , EAIFl                                                             \t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("othBrandCd")) {
            strSql.append("\n").append(" \t\t, TO_CHAR(SYSDATE, 'YYYYMMDD')\t\t\t\t\t\t");
        }
        strSql.append("\n").append("             , ?, ?, ?, ?, ?                                                           \t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("cstmId"));
                pstmt.setString(index++, info.getString("cstmNm"));
                pstmt.setString(index++, info.getString("reslNo1"));
                pstmt.setString(index++, info.getString("reslNo2"));
                pstmt.setString(index++, info.getString("sex"));
                pstmt.setString(index++, info.getString("brthDate"));
                pstmt.setString(index++, info.getString("brthDateTp"));
                pstmt.setString(index++, info.getString("gnrt"));
                pstmt.setString(index++, info.getString("homeZip1"));
                pstmt.setString(index++, info.getString("homeZip2"));
                pstmt.setString(index++, info.getString("homeAddr1"));
                pstmt.setString(index++, info.getString("homeAddr2"));
                pstmt.setString(index++, info.getString("cmpyZip1"));
                pstmt.setString(index++, info.getString("cmpyZip2"));
                pstmt.setString(index++, info.getString("cmpyAddr1"));
                pstmt.setString(index++, info.getString("cmpyAddr2"));
                pstmt.setString(index++, info.getString("homePhoneNo1"));
                pstmt.setString(index++, info.getString("homePhoneNo2"));
                pstmt.setString(index++, info.getString("homePhoneNo3"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo1"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo2"));
                pstmt.setString(index++, info.getString("cmpyPhoneNo3"));
                pstmt.setString(index++, info.getString("mobileNo1"));
                pstmt.setString(index++, info.getString("mobileNo2"));
                pstmt.setString(index++, info.getString("mobileNo3"));
                pstmt.setString(index++, info.getString("email1"));
                pstmt.setString(index++, info.getString("email2"));
                pstmt.setString(index++, info.getString("mainContpt"));
                pstmt.setString(index++, info.getString("dmRcvFl"));
                pstmt.setString(index++, info.getString("wedFl"));
                pstmt.setString(index++, info.getString("wedDate"));
                pstmt.setString(index++, info.getString("realNameFl"));
                pstmt.setString(index++, info.getString("pswd"));
                pstmt.setString(index++, info.getString("secPswd"));
                pstmt.setString(index++, info.getString("skinTp"));
                pstmt.setString(index++, info.getString("skinTrb"));
                pstmt.setString(index++, info.getString("jobCd"));
                pstmt.setString(index++, info.getString("othBrandCd"));
                pstmt.setString(index++, info.getString("uSkinTp"));
                pstmt.setString(index++, info.getString("uSkinTrb"));
                pstmt.setString(index++, info.getString("uCstmId"));
                pstmt.setString(index++, info.getString("cstmCardNo"));
                pstmt.setString(index++, info.getString("eaiFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                this.updateMemberInfoAddr(info);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchMemListPagingOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SEARCH_PAGE */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t     AND CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t     AND Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t     AND Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t     AND Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t     AND BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(GradeCd,NULL,'GNR',GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t     AND BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchMemListOld(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* MEMBER_SEARCH */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCstmId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CstmNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReslNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Sex\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BrthDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t, BrthDateTp\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Gnrt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomeAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyZip2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyAddr2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo1\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo2\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, HomePhoneNo3\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo1\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo2\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CmpyPhoneNo3\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MobileNo3\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Email2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainContpt\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DmRcvFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WedDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RealNameFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Pswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SecPswd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTp\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SkinTrb\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, JobCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OthBrandUpdDt\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("                    , USkinTp ");
        strSql.append("\n").append("                    , USkinTrb ");
        strSql.append("\n").append("                    , UcstmId ");
        strSql.append("\n").append("                    , CstmCardNo ");
        strSql.append("\n").append("                    , EaiFl ");
        strSql.append("\n").append("                    , CstmEngNm ");
        strSql.append("\n").append("                    , nvl(GradeCd,'GNR') AS GradeCd ");
        strSql.append("\n").append("                    , ufo_getCdNm('G091',nvl(GradeCd,'GNR')) AS GradeNm ");
        strSql.append("\n").append("                    , IntAprvFl ");
        strSql.append("\n").append("                    , RnmAuthDate ");
        strSql.append("\n").append("                    , IpinAuthFl ");
        strSql.append("\n").append("                    , IpinAuthDate ");
        strSql.append("\n").append("                    , IpinAuthDi ");
        strSql.append("\n").append("                    , IpinAuthCi ");
        strSql.append("\n").append("                    , badFl ");
        strSql.append("\n").append(" \t\t\t  FROM " + this.memInfo.tableNm1 + "_DAMO\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("cstmId")) {
            strSql.append("\n").append("\t\t\t AND CstmId = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("ipinAuthCi")) {
            strSql.append("\n").append("\t\t\t     AND ipinAuthCi = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isSpace("reslNo1")) {
            strSql.append("\n").append(" \t\t\t AND ReslNo1 = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cstmNm")) {
            strSql.append("\n").append("\t\t     AND CstmNm LIKE ? || '%'\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email1")) {
            strSql.append("\n").append("\t\t     AND Email1  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("email2")) {
            strSql.append("\n").append("\t\t     AND Email2  = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sex")) {
            strSql.append("\n").append("\t\t     AND Sex = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("birthYear")) {
            strSql.append("\n").append("\t\t     AND BrthDate = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("gradeCd")) {
            strSql.append("\n").append("             AND decode(GradeCd,NULL,'GNR',GradeCd) = ?                                                   ");
        }
        if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
            strSql.append("\n").append("             AND UcstmId = ?                                                   ");
        }
        if (!info.isSpace("badFl")) {
            strSql.append("\n").append("\t\t     AND BadFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("cstmId")) {
                    pstmt.setString(index++, info.getString("cstmId"));
                }
                if (!info.isSpace("ipinAuthCi")) {
                    pstmt.setString(index++, info.getString("ipinAuthCi"));
                } else if (!info.isSpace("reslNo1")) {
                    pstmt.setString(index++, info.getString("reslNo1"));
                }
                if (!info.isSpace("cstmNm")) {
                    pstmt.setString(index++, info.getString("cstmNm"));
                }
                if (!info.isSpace("email1")) {
                    pstmt.setString(index++, info.getString("email1"));
                }
                if (!info.isSpace("email2")) {
                    pstmt.setString(index++, info.getString("email2"));
                }
                if (!info.isSpace("sex")) {
                    pstmt.setString(index++, info.getString("sex"));
                }
                if (!info.isSpace("birthYear")) {
                    pstmt.setString(index++, info.getString("birthYear"));
                }
                if (!info.isSpace("gradeCd")) {
                    pstmt.setString(index++, info.getString("gradeCd"));
                }
                if (!info.isSpace("uCstmId") && info.getLong("uCstmId") != 0L) {
                    pstmt.setLong(index++, info.getLong("uCstmId"));
                }
                if (!info.isSpace("badFl")) {
                    pstmt.setString(index++, info.getString("badFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.member.entity.MemberMstEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]MEMBER_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

