/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.email;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.email.entity.MailSendHistoryEntity;
import com.ufo.email.entity.MailTemplateEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOEmailMgmtDAO
extends UFOBaseDAO {
    public UFOEmailMgmtDAO(Connection con) {
        super(con);
    }

    public Vector searchEmailTemp(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_TEMPLATE_SEARCH */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tEmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01MT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t AND SiteCd IN ( 'ALL',  ? )\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\tORDER BY EmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.email.entity.MailTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MailTemplateEntity selectEmailTemp(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MailTemplateEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_TEMPLATE_SELECT */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tEmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01MT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE EmailCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("emailCd"));
                rs = pstmt.executeQuery();
                result = (MailTemplateEntity)DAOHelper.makeEntity(rs, "com.ufo.email.entity.MailTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewCd() throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT /* NEW_CD */ 'M' || LPAD(NVL(MAX(SUBSTR(EmailCd,2)),0)+1,5,'0') AS CD FROM UEML01MT");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                boolean index = true;
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_CD", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertEmailTemp(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* EMAIL_TEMPLATE_INSERT */ INTO UEML01MT (\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tEmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, EMPTY_CLOB(), ?, ?, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        StringBuffer strSql2 = new StringBuffer();
        strSql2.append("\n").append(" \t\t SELECT /* EMAIL_TEMPLATE_INSERT_CONTENTS */ \t\t\t\t\t");
        strSql2.append("\n").append("\t\t\t\tContents FROM UEML01MT\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append(" \t\t\tWHERE EmailCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append("\t\t   FOR UPDATE\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("emailCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("subject"));
                pstmt.setString(index++, info.getString("sendNm"));
                pstmt.setString(index++, info.getString("sendEmail"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(strSql2.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("emailCd"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("contents")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int updateEmailTemp(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* EMAIL_TEMPLATE_UPDATE */ UEML01MT SET\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t\tEmailCd\t\t\t= EmailCd\t\t\t\t\t\t\t\t\t");
        if (info.isExist("siteCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, SiteCd\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("subject")) {
            strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("contents")) {
            strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t= EMPTY_CLOB()\t\t\t\t\t\t\t");
        }
        if (info.isExist("sendNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("sendEmail")) {
            strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\tWHERE EmailCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        StringBuffer strSql2 = new StringBuffer();
        strSql2.append("\n").append(" \t\t SELECT /* EMAIL_TEMPLATE_UPDATE_CONTENTS */\t\t\t\t\t");
        strSql2.append("\n").append("\t\t\tContents FROM UEML01MT\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append(" \t\t\tWHERE EmailCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append("\t\t   FOR UPDATE\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (info.isExist("subject")) {
                    pstmt.setString(index++, info.getString("subject"));
                }
                if (info.isExist("sendNm")) {
                    pstmt.setString(index++, info.getString("sendNm"));
                }
                if (info.isExist("sendEmail")) {
                    pstmt.setString(index++, info.getString("sendEmail"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("emailCd"));
                result = pstmt.executeUpdate();
                if (result > 0 && info.isExist("contents")) {
                    pstmt2 = this.con.prepareStatement(strSql2.toString());
                    index = 1;
                    pstmt2.setString(index++, info.getString("emailCd"));
                    rs = pstmt2.executeQuery();
                    String[] arrVal = new String[]{info.getString("contents")};
                    DAOHelper.putClobData(rs, arrVal);
                }
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteEmailTemp(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* EMAIL_TEMPLATE_DELETE */ FROM  UEML01MT\t\t");
        strSql.append("\n").append(" \t\tWHERE EmailCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("emailCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchTempInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_TEMPLATE_INFO_SEARCH */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tEmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplaceKey\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplaceMark\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01DT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE EmailCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (info.isExist("emailCd")) {
                    System.out.println("\ufffd\ufffd\ufffd\u00f8\ufffd \u0121\u022f Dao searchTempInfo emailCd : " + info.getString("EmailCd"));
                }
                pstmt.setString(index++, info.getString("EmailCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.email.entity.MailTemplateInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_INFO_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertTempInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* EMAIL_TEMPLATE_INFO_INSERT */ INTO UEML01DT (\t");
        strSql.append("\n").append(" \t\t\t\t\tEmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplaceKey\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ReplaceMark\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM UEML01DT WHERE EmailCd = ? ), ?, ?, ? ");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("emailCd"));
                pstmt.setString(index++, info.getString("emailCd"));
                pstmt.setString(index++, info.getString("replaceKey"));
                pstmt.setString(index++, info.getString("replaceMark"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deleteTempInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* EMAIL_TEMPLATE_INFO_DELETE */ FROM  UEML01DT\t");
        strSql.append("\n").append(" \t\tWHERE EmailCd\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (info.isExist("seq")) {
            strSql.append("\n").append(" \t\tAND Seq\t= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("emailCd"));
                if (info.isExist("seq")) {
                    pstmt.setInt(index++, info.getInt("seq"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_TEMPLATE_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchEmailHistory(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_HISTORY_SEARCH */\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, EmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendTime\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'HH24MISS') RegTime\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01HT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
            strSql.append("\n").append("\t\t\t   AND SendDate BETWEEN ? AND ?\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
            strSql.append("\n").append("\t\t\t   AND TO_CHAR(FstRegDate,'YYYYMMDD') BETWEEN ? AND ?\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
                    pstmt.setString(index++, info.getString("sendStDate"));
                    pstmt.setString(index++, info.getString("sendEndDate"));
                }
                if (!info.isSpace("sendFl")) {
                    pstmt.setString(index++, info.getString("sendFl"));
                }
                if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
                    pstmt.setString(index++, info.getString("regStDate"));
                    pstmt.setString(index++, info.getString("regEndDate"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.email.entity.MailSendHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_SEARCH", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchEmailHistoryPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_HISTORY_SEARCH_PAGE */\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, EmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendTime\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'HH24MISS') RegTime\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01HT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
            strSql.append("\n").append("\t\t\t   AND SendDate BETWEEN ? AND ?\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
            strSql.append("\n").append("\t\t\t   AND TO_CHAR(FstRegDate,'YYYYMMDD') BETWEEN ? AND ?\t\t\t");
        }
        strSql.append("\n").append("\t\t\tORDER BY Seq Desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
                    pstmt.setString(index++, info.getString("sendStDate"));
                    pstmt.setString(index++, info.getString("sendEndDate"));
                }
                if (!info.isSpace("sendFl")) {
                    pstmt.setString(index++, info.getString("sendFl"));
                }
                if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
                    pstmt.setString(index++, info.getString("regStDate"));
                    pstmt.setString(index++, info.getString("regEndDate"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.email.entity.MailSendHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_SEARCH_PAGE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getEmailHistoryCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_HISTORY_SEARCH_COUNT */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01HT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t WHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
            strSql.append("\n").append("\t\t\t   AND SendDate BETWEEN ? AND ?\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        } else if (!info.isExist("sendFl")) {
            strSql.append("\n").append("\t\t\t   AND SendFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
            strSql.append("\n").append("\t\t\t   AND TO_CHAR(FstRegDate,'YYYYMMDD') BETWEEN ? AND ?\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("sendStDate") && !info.isSpace("sendEndDate")) {
                    pstmt.setString(index++, info.getString("sendStDate"));
                    pstmt.setString(index++, info.getString("sendEndDate"));
                }
                if (!info.isSpace("sendFl")) {
                    pstmt.setString(index++, info.getString("sendFl"));
                }
                if (!info.isSpace("regStDate") && !info.isSpace("regEndDate")) {
                    pstmt.setString(index++, info.getString("regStDate"));
                    pstmt.setString(index++, info.getString("regEndDate"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_SEARCH_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public MailSendHistoryEntity selectEmailHistory(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        MailSendHistoryEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* EMAIL_HISTORY_SELECT */\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, EmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendTime\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'HH24MISS') RegTime\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t  FROM UEML01HT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t \tWHERE Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("seq"));
                rs = pstmt.executeQuery();
                result = (MailSendHistoryEntity)DAOHelper.makeEntity(rs, "com.ufo.email.entity.MailSendHistoryEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getMaxSeq() throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\tSELECT /* NEW_MAX_SEQ */ NVL(MAX(Seq),0)+1 AS Seq FROM UEML01HT\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_MAX_SEQ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertEmailHistory(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* EMAIL_HISTORY_INSERT */ INTO UEML01HT (\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSeq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, EmailCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvNm\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RecvEmail\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Subject\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendDate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendTime\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SendFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ? , EMPTY_CLOB()\t\t\t\t\t\t\t\t\t\t");
        if (info.isExist("sendFl") && info.getString("sendFl").equals("Y")) {
            strSql.append("\n").append("\t\t\t , TO_CHAR(SYSDATE,'YYYYMMDD'), TO_CHAR(SYSDATE, 'HHMISS'), ?, ?\t");
        } else {
            strSql.append("\n").append("\t\t\t , '', '', ?, ?\t");
        }
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        StringBuffer strSql2 = new StringBuffer();
        strSql2.append("\n").append(" \t\t SELECT /* EMAIL_HISTORY_INSERT_CONTENTS */ \t\t\t\t\t\t");
        strSql2.append("\n").append("\t\t\t\tContents FROM UEML01HT\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append(" \t\t\tWHERE Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql2.append("\n").append("\t\t   FOR UPDATE\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setInt(index++, info.getInt("seq"));
                pstmt.setString(index++, info.getString("emailCd"));
                pstmt.setString(index++, info.getString("sendNm"));
                pstmt.setString(index++, info.getString("sendEmail"));
                pstmt.setString(index++, info.getString("recvNm"));
                pstmt.setString(index++, info.getString("recvEmail"));
                pstmt.setString(index++, info.getString("subject"));
                pstmt.setString(index++, info.getString("sendFl"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(strSql2.toString());
                index = 1;
                pstmt2.setInt(index++, info.getInt("seq"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("contents")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteEmailHistory(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* EMAIL_HISTORY_DELETE */ FROM  UEML01HT\t\t\t");
        strSql.append("\n").append(" \t\tWHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("emailCd")) {
            strSql.append("\n").append("\t\t\t   AND EmailCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (!info.isSpace("seq")) {
                    pstmt.setInt(index++, info.getInt("seq"));
                }
                if (!info.isSpace("emailCd")) {
                    pstmt.setString(index++, info.getString("emailCd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]EMAIL_HISTORY_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }
}

