/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.counsel;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.counsel.UFOInquireMgmtDAO;
import com.ufo.counsel.entity.InquireInfoEntity;
import com.ufo.email.UFOEmailMgmtWB;
import com.ufo.member.UFOMemberMgmtDAO;
import com.ufo.member.entity.MemberMstEntity;

public class UFOInquireMgmtWB
extends UFOBaseWB {
    public UFOInquireMgmtWB() {
    }

    public UFOInquireMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchSiteInq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchSiteInqList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_INQ_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchCstmInq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchCstmInqListPaging(info));
                    result.put("TOTCNT", dao.getCstmInqListCnt(info));
                } else {
                    result.put("LIST", dao.searchCstmInqList(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchCstmInqPaging(UFORequest info) throws UFOException {
        info.setPage(true);
        return this.searchCstmInq(info);
    }

    public UFOResult selectCstmInqInfo(UFORequest info) throws Exception {
        return this.selectCstmInqInfo(info, true);
    }

    public UFOResult selectCstmInqInfo(UFORequest info, boolean isView) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                UFOMemberMgmtDAO dao2 = new UFOMemberMgmtDAO(this.getConnection(this));
                if (isView) {
                    dao.hitReadCnt(info);
                }
                InquireInfoEntity entity = dao.selectCstmInqInfo(info);
                result.put("VIEW", entity);
                dao2.setMemInfo(dao2.selectMemMgmtInfo(info).toRequest());
                MemberMstEntity memInfo = dao2.selectMemberSimple(entity.toRequest());
                if (memInfo != null) {
                    result.put("MEMINFO", memInfo);
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectCstmInq(UFORequest info) throws Exception {
        return this.selectCstmInq(info, true);
    }

    public UFOResult selectCstmInq(UFORequest info, boolean isView) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                if (isView) {
                    dao.hitReadCnt(info);
                }
                InquireInfoEntity entity = dao.selectCstmInqInfoRow(info);
                result.put("VIEW", entity);
                result.put("PREV", dao.selectCstmInqInfoRow(info, "P"));
                result.put("NEXT", dao.selectCstmInqInfoRow(info, "N"));
                this.startTransaction();
                if (CmUtil.nullTrim(entity.ansFl).equals("Y")) {
                    UFORequest temp = new UFORequest(info.getRequest());
                    temp.put("siteCd", CmUtil.nullTrim(entity.siteCd));
                    temp.put("cd", CmUtil.nullTrim(entity.cd));
                    temp.put("seq", entity.seq);
                    temp.put("ansViewFl", "Y");
                    dao.updateCstmInqInfo(temp);
                }
                this.commit();
            }
            catch (Exception etcEx) {
                this.rollback();
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_SELECT_ROW", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertCstmInq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertCstmInqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateCstmInqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateCstmInqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult answerCstmInqInfo(UFORequest info) throws UFOException {
        int resCnt;
        UFOResult result;
        block16: {
            result = new UFOResult();
            resCnt = 0;
            try {
                try {
                    if (info.isEquals("emailFl", "Y")) {
                        UFORequest emailReq = info.cloneReq("EMAIL");
                        UFOResult emailRes = null;
                        UFOEmailMgmtWB emailWb = new UFOEmailMgmtWB();
                        emailRes = emailWb.sendEMail(emailReq);
                        boolean emailFlag = emailRes.getBoolean("FLAG");
                        if (emailFlag) {
                            result.put("MAILFLAG", "true");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                        } else {
                            result.put("MAILFLAG", "false");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                        }
                    } else {
                        result.put("MAILFLAG", "false");
                        result.put("MAILMESG", "Not Send.");
                    }
                }
                catch (Exception emailReq) {
                    this.closeConnection();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection();
                throw throwable;
            }
            this.closeConnection();
        }
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("siteCd", info.getString("siteCd"));
                temp.put("cd", info.getString("cd"));
                temp.put("seq", info.getInt("seq"));
                temp.put("ansId", info.getString("ansId"));
                temp.put("answer", info.getString("answer"));
                temp.put("ansFl", "Y");
                temp.put("ansViewFl", "N");
                this.startTransaction();
                resCnt = dao.updateCstmInqInfo(temp);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "Fail");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_ANSWER", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteCstmInq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("delFl", "Y");
                resCnt = dao.updateCstmInqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[CSTM_INQ_UPDATE]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteCstmInqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteCstmInqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CSTM_INQ_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSiteInqMng(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchSiteInqMng(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_INQ_MNG_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult modifySiteInqMng(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOInquireMgmtDAO dao = new UFOInquireMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"cd", "smsSendFl", "mailSendFl", "useFl", "status"};
                String[] keepAttr = new String[]{"siteCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            if (CmUtil.nullTrim(arrInfo[i].getString("useFl")).equals("Y")) {
                                resCnt += dao.insertSiteInqMng(arrInfo[i]);
                            }
                        } else if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            if (CmUtil.nullTrim(arrInfo[i].getString("useFl")).equals("Y")) {
                                resCnt += dao.updateSiteInqMng(arrInfo[i]);
                            } else if (CmUtil.nullTrim(arrInfo[i].getString("useFl")).equals("N")) {
                                resCnt += dao.deleteSiteInqMng(arrInfo[i]);
                            }
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_INQ_MNG_MODIFY", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

