/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.contents;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.contents.UFOAdMediaMgmtDAO;
import com.ufo.contents.entity.AdMediaMstEntity;
import java.util.Vector;

public class UFOAdMediaMgmtWB
extends UFOBaseWB {
    public UFOAdMediaMgmtWB() {
    }

    public UFOAdMediaMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchAdList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    Vector list = dao.searchAdListPaging(info);
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            AdMediaMstEntity entity = (AdMediaMstEntity)list.get(i);
                            entity.comtList = dao.searchAdComtList(entity.toRequest());
                            entity.prdtList = dao.searchAdPrdtList(entity.toRequest());
                            entity.fileList = dao.searchFTList(info);
                            ++i;
                        }
                    }
                    result.put("LIST", list);
                    result.put("TOTCNT", dao.getAdListCnt(info));
                } else {
                    Vector list = dao.searchAdList(info);
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            AdMediaMstEntity entity = (AdMediaMstEntity)list.get(i);
                            entity.comtList = dao.searchAdComtList(entity.toRequest());
                            entity.prdtList = dao.searchAdPrdtList(entity.toRequest());
                            entity.fileList = dao.searchFTList(info);
                            ++i;
                        }
                    }
                    result.put("LIST", list);
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchAdListPaging(UFORequest info) throws UFOException {
        info.setPage(true);
        return this.searchAdList(info);
    }

    public UFOResult searchAdListBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    Vector list = dao.searchAdListPaging(info);
                    result.put("LIST", list);
                    result.put("TOTCNT", dao.getAdListCnt(info));
                } else {
                    Vector list = dao.searchAdList(info);
                    result.put("LIST", list);
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_SEARCH_BASIC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectAdInfoBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                AdMediaMstEntity entity = dao.selectAdInfo(info);
                if (entity != null) {
                    entity.comtList = dao.searchAdComtList(info);
                    entity.prdtList = dao.searchAdPrdtList(info);
                    entity.fileList = dao.searchFTList(info);
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_SELECT_BASIC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectAdInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                AdMediaMstEntity entity = dao.selectAdInfo(info);
                if (entity != null) {
                    entity.comtList = dao.searchAdComtList(info);
                    entity.prdtList = dao.searchAdPrdtList(info);
                    entity.fileList = dao.searchFTList(info);
                }
                result.put("VIEW", entity);
                result.put("PREV", dao.selectAdInfo(info, "P"));
                result.put("NEXT", dao.selectAdInfo(info, "N"));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAdInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertAdInfo(info);
                if (info.isExist("prdtCd")) {
                    String[] splitAttr = new String[]{"prdtCd", "status"};
                    String[] keepAttr = new String[]{"siteCd", "cd", "seq"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                                resCnt1 += dao.insertAdPrdt(arrInfo[i]);
                            } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                                resCnt1 += dao.deleteAdPrdt(arrInfo[i]);
                            }
                            ++i;
                        }
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateAdInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateAdInfo(info);
                if (info.isExist("prdtCd")) {
                    String[] splitAttr = new String[]{"prdtCd", "status"};
                    String[] keepAttr = new String[]{"siteCd", "cd", "seq"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                                resCnt1 += dao.insertAdPrdt(arrInfo[i]);
                            } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                                resCnt1 += dao.deleteAdPrdt(arrInfo[i]);
                            }
                            ++i;
                        }
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAdInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        int resCnt3 = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                if (info.isExist("subSeq")) {
                    info.remove("subSeq");
                }
                UFORequest temp = new UFORequest();
                temp.put("siteCd", info.getString("siteCd"));
                temp.put("cd", info.getString("cd"));
                temp.put("seq", info.getInt("seq"));
                resCnt1 = dao.deleteAdComt(temp);
                resCnt2 = dao.deleteAdPrdt(temp);
                resCnt3 = dao.deleteAdFT(temp);
                resCnt = dao.deleteAdInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAdComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertAdComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_COMT_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAdComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteAdComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_COMT_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAdPrdt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertAdPrdt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_PRDT_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAdPrdt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteAdPrdt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_PRDT_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchAdYearList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchAdYearList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_YEST_LIST", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAdFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.remove("fileSeq");
                resCnt = dao.insertAdFT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_FILE_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAdFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt1 = dao.deleteFileFT(info);
                resCnt = dao.deleteAdFT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_FILE_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult popularityProductList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                Vector prdtList = dao.popularityProductList(info);
                result.put("prdtList", prdtList);
                result.put("prdtCnt", dao.popularityProductCnt(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]POPULARITYPRODUCTLIST", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchBrandList() throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchBrandList());
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BRAND_LV_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchCheckBrand(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                String aa = dao.searchCheckBrand(info);
                System.out.println("aa === " + aa);
                result.put("BRAND", aa);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchCheckBrand", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertWhatsHotInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int brandCnt = 0;
        int orderByCnt = 1;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                brandCnt = dao.searchBrandListCnt(info);
                System.out.println("brandCnt : " + brandCnt);
                if (brandCnt >= 1) {
                    result.put("FLAG", "false");
                    result.put("MESG", "Brand");
                } else {
                    this.startTransaction();
                    if (info.isExist("prdtCd")) {
                        String[] splitAttr = new String[]{"prdtCd", "status"};
                        UFORequest[] arrInfo = info.toArray(info, splitAttr);
                        System.out.println("************************ ************************" + arrInfo.length);
                        if (arrInfo != null) {
                            int i = 0;
                            while (i < arrInfo.length) {
                                if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                                    arrInfo[i].put("orderBy", orderByCnt);
                                    resCnt = dao.popularityProductI(arrInfo[i]);
                                    ++orderByCnt;
                                }
                                ++i;
                            }
                        }
                    }
                    if (resCnt > 0) {
                        result.put("FLAG", "true");
                        result.put("MESG", " ");
                        this.commit();
                    } else {
                        result.put("FLAG", "false");
                        result.put("MESG", "FAIL");
                        this.rollback();
                    }
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public boolean popularityProductDelete(UFORequest info) throws UFOException {
        boolean result = false;
        try {
            try {
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                result = dao.popularityProductDelete(info);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]POPULARITYPRODUCTDELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public boolean popularityProductModify(UFORequest info) throws UFOException {
        boolean result = false;
        int cnt = 0;
        int orderByCnt = 1;
        try {
            try {
                String[] splitAttr;
                UFORequest[] arrInfo;
                UFOAdMediaMgmtDAO dao = new UFOAdMediaMgmtDAO(this.getConnection(this));
                if (info.isExist("prdtCd") && (arrInfo = info.toArray(info, splitAttr = new String[]{"prdtCd", "status"})) != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            arrInfo[i].put("orderBy", orderByCnt);
                            cnt += dao.popularityProductI(arrInfo[i]);
                            ++orderByCnt;
                        } else if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            arrInfo[i].put("orderBy", orderByCnt);
                            cnt += dao.popularityProductU(arrInfo[i]);
                            ++orderByCnt;
                        } else {
                            cnt += dao.popularityProductD(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (cnt > 0) {
                    result = true;
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]popularityProductModify", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

