/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.utility;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImgHelper {
    private File imgFile = null;
    private OutputStream output = null;
    private int width = 0;
    private int height = 0;
    private int quality = 100;

    public ImgHelper() {
    }

    public ImgHelper(String imgPath, int width, int height) {
        this.imgFile = new File(imgPath);
        this.width = width;
        this.height = height;
    }

    public ImgHelper(File file, int width, int height) {
        this.imgFile = file;
        this.width = width;
        this.height = height;
    }

    public void save(File file) throws FileNotFoundException {
        this.output = new FileOutputStream(file);
        this.run();
    }

    public void save(String savePath) throws FileNotFoundException {
        this.output = new FileOutputStream(new File(savePath));
        this.run();
    }

    public void save(OutputStream outputStream) {
        this.output = outputStream;
        this.run();
    }

    private void run() {
        int thumbWidth = 0;
        int thumbHeight = 0;
        String realPath = "";
        try {
            if (this.imgFile.exists() && this.imgFile.isFile()) {
                realPath = this.imgFile.getAbsolutePath();
                Image image = Toolkit.getDefaultToolkit().getImage(realPath);
                MediaTracker mediaTracker = new MediaTracker(new Container());
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                if (this.width == 0 || this.height == 0) {
                    thumbWidth = image.getWidth(null);
                    thumbHeight = image.getHeight(null);
                } else {
                    int imageHeight;
                    thumbWidth = this.width;
                    thumbHeight = this.height;
                    int imageWidth = image.getWidth(null);
                    if (imageWidth * thumbHeight / (imageHeight = image.getHeight(null)) > thumbWidth) {
                        thumbWidth = imageWidth * thumbHeight / imageHeight;
                    } else {
                        thumbHeight = imageHeight * thumbWidth / imageWidth;
                    }
                }
                BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
                Graphics2D graphics2D = thumbImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(thumbImage);
                this.quality = Math.max(0, Math.min(this.quality, 100));
                param.setQuality((float)this.quality / 100.0f, false);
                encoder.setJPEGEncodeParam(param);
                encoder.encode(thumbImage);
                this.output.flush();
                this.output.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void thumbnail(String srcImgPath, String targetImgPath, int width, int height) {
        ImgHelper imgHelper = null;
        try {
            try {
                imgHelper = new ImgHelper(srcImgPath, width, height);
                imgHelper.save(targetImgPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                imgHelper = null;
            }
        }
        finally {
            imgHelper = null;
        }
    }

    public static void thumbnail(File srcFile, String targetImgPath, int width, int height) {
        ImgHelper imgHelper = null;
        try {
            try {
                imgHelper = new ImgHelper(srcFile, width, height);
                imgHelper.save(targetImgPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                imgHelper = null;
            }
        }
        finally {
            imgHelper = null;
        }
    }

    public static void thumbnail(String srcImgPath, OutputStream output, int width, int height) {
        ImgHelper imgHelper = null;
        try {
            try {
                imgHelper = new ImgHelper(srcImgPath, width, height);
                imgHelper.save(output);
            }
            catch (Exception e) {
                e.printStackTrace();
                imgHelper = null;
            }
        }
        finally {
            imgHelper = null;
        }
    }

    public static void thumbnail(File srcFile, OutputStream output, int width, int height) {
        ImgHelper imgHelper = null;
        try {
            try {
                imgHelper = new ImgHelper(srcFile, width, height);
                imgHelper.save(output);
            }
            catch (Exception e) {
                e.printStackTrace();
                imgHelper = null;
            }
        }
        finally {
            imgHelper = null;
        }
    }
}

