/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.utility;

import com.ufo.common.utility.CmUtil;
import java.io.CharArrayReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.CLOB;

public class DAOHelper {
    public static String createPageSQL(String sql, int pageno, int pagesize) {
        if (pageno < 1) {
            pageno = 1;
        }
        if (pagesize < 1) {
            pagesize = 50;
        }
        StringBuffer pagingSql = new StringBuffer();
        pagingSql.append("\n").append(" SELECT Table2.* FROM (");
        pagingSql.append("\n").append("\tSELECT CEIL(ROWNUM/" + pagesize + ") PAGE, Table1.* FROM (");
        pagingSql.append("\n").append(sql);
        pagingSql.append("\n").append("\t) Table1");
        pagingSql.append("\n").append("\tWHERE ROWNUM <= " + pagesize * pageno);
        pagingSql.append("\n").append(") Table2");
        pagingSql.append("\n").append("WHERE Table2.PAGE=" + pageno);
        return pagingSql.toString();
    }

    public static String createPageStatement(String sql) {
        StringBuffer pagingSql = new StringBuffer();
        pagingSql.append("\n").append(" SELECT Table2.* FROM (");
        pagingSql.append("\n").append("\tSELECT CEIL(ROWNUM/ ? ) PAGE, Table1.* FROM (");
        pagingSql.append("\n").append(sql);
        pagingSql.append("\n").append("\t) Table1");
        pagingSql.append("\n").append("\tWHERE ROWNUM <= ? ");
        pagingSql.append("\n").append(") Table2");
        pagingSql.append("\n").append("WHERE Table2.PAGE= ? ");
        return pagingSql.toString();
    }

    public static String createCountSQL(String sql, int maxcnt) {
        if (maxcnt < 1) {
            return sql;
        }
        return DAOHelper.createPageSQL(sql, 1, maxcnt);
    }

    public static String getScalarString(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = null;
        Object colname = null;
        String str = "";
        try {
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            if (colcnt > 1) {
                throw new Exception("[ERR] : ResultSet include more than Scalar Column Data. {" + colcnt + "}");
            }
            if (rs.next() && (str = CmUtil.nullTrim(rs.getString(colcnt))) == null) {
                str = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return str;
    }

    public static int getScalarInt(ResultSet rs) throws Exception {
        return Integer.parseInt(DAOHelper.getScalarString(rs));
    }

    public static Vector makeVector(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = null;
        String colname = null;
        Vector vt = null;
        try {
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            while (rs.next()) {
                if (vt == null) {
                    vt = new Vector();
                }
                Hashtable<String, String> ht = new Hashtable<String, String>();
                int i = 1;
                while (i < colcnt + 1) {
                    colname = rsmd.getColumnName(i);
                    int coltype = rsmd.getColumnType(i);
                    String colvalue = null;
                    switch (coltype) {
                        case 2005: {
                            CLOB clobData = (CLOB)rs.getClob(i);
                            if (clobData != null) {
                                StringBuffer output = new StringBuffer();
                                Reader input = clobData.getCharacterStream();
                                char[] buffer = new char[1024];
                                int byteRead = 0;
                                while ((byteRead = input.read(buffer)) != -1) {
                                    output.append(buffer, 0, byteRead);
                                }
                                colvalue = output.toString();
                                break;
                            }
                            colvalue = "";
                            break;
                        }
                        default: {
                            colvalue = CmUtil.nullTrim(rs.getString(i));
                        }
                    }
                    if (colvalue == null) {
                        colvalue = "";
                    }
                    ht.put(colname, colvalue);
                    ++i;
                }
                vt.add(ht);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return vt;
    }

    public static Vector makeVector(ResultSet rs, String strobj) throws Exception {
        Class<?> c = Class.forName(strobj);
        Object obj = c.newInstance();
        return DAOHelper.makeVector(rs, obj);
    }

    public static Vector makeVector(ResultSet rs, Object obj) throws Exception {
        Vector rsvt;
        Vector vt;
        Class<?> c;
        block30: {
            c = obj.getClass();
            String fullname = c.getName();
            vt = new Vector();
            rsvt = DAOHelper.makeVector(rs);
            if (rsvt != null) break block30;
            return null;
        }
        try {
            int i = 0;
            while (i < rsvt.size()) {
                Hashtable ht = (Hashtable)rsvt.get(i);
                Object entity = c.newInstance();
                Field[] field = entity.getClass().getDeclaredFields();
                int k = 0;
                while (k < field.length) {
                    String fieldtype = field[k].getType().getName();
                    String fieldname = field[k].getName().toUpperCase();
                    if (ht.containsKey(fieldname)) {
                        if (fieldtype.equals("java.lang.String")) {
                            field[k].set(entity, (String)ht.get(fieldname));
                        } else if (fieldtype.equals("int")) {
                            field[k].setInt(entity, Integer.parseInt(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("double")) {
                            field[k].setDouble(entity, Double.parseDouble(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("long")) {
                            field[k].setLong(entity, Long.parseLong(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("float")) {
                            field[k].setFloat(entity, Float.parseFloat(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("boolean")) {
                            field[k].setBoolean(entity, Boolean.getBoolean((String)ht.get(fieldname)));
                        }
                    } else if (ht.containsKey(fieldname.toLowerCase())) {
                        if (fieldtype.equals("java.lang.String")) {
                            field[k].set(entity, (String)ht.get(fieldname));
                        } else if (fieldtype.equals("int")) {
                            field[k].setInt(entity, Integer.parseInt(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("double")) {
                            field[k].setDouble(entity, Double.parseDouble(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("long")) {
                            field[k].setLong(entity, Long.parseLong(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("float")) {
                            field[k].setFloat(entity, Float.parseFloat(CmUtil.null2Zero((String)ht.get(fieldname))));
                        } else if (fieldtype.equals("boolean")) {
                            field[k].setBoolean(entity, Boolean.getBoolean((String)ht.get(fieldname)));
                        }
                    }
                    ++k;
                }
                vt.add(entity);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return vt;
    }

    public static Hashtable makeEntity(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = null;
        String colname = null;
        Hashtable<String, String> ht = null;
        try {
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            if (rs.next()) {
                if (ht == null) {
                    ht = new Hashtable<String, String>();
                }
                int i = 1;
                while (i < colcnt + 1) {
                    colname = rsmd.getColumnName(i);
                    int coltype = rsmd.getColumnType(i);
                    String colvalue = null;
                    switch (coltype) {
                        case 2005: {
                            CLOB clobData = (CLOB)rs.getClob(i);
                            if (clobData != null) {
                                StringBuffer output = new StringBuffer();
                                Reader input = clobData.getCharacterStream();
                                char[] buffer = new char[1024];
                                int byteRead = 0;
                                while ((byteRead = input.read(buffer, 0, 1024)) != -1) {
                                    output.append(buffer, 0, byteRead);
                                }
                                colvalue = output.toString();
                                break;
                            }
                            colvalue = "";
                            break;
                        }
                        default: {
                            colvalue = CmUtil.nullTrim(rs.getString(i));
                        }
                    }
                    if (colvalue == null) {
                        colvalue = "";
                    }
                    ht.put(colname, colvalue);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return ht;
    }

    public static Object makeEntity(ResultSet rs, String strobj) throws Exception {
        Class<?> c = Class.forName(strobj);
        Object obj = c.newInstance();
        return DAOHelper.makeEntity(rs, obj);
    }

    public static Object makeEntity(ResultSet rs, Object obj) throws Exception {
        Hashtable rsht;
        Object entity;
        block29: {
            Class<?> c = obj.getClass();
            String fullname = c.getName();
            entity = c.newInstance();
            rsht = DAOHelper.makeEntity(rs);
            if (rsht != null) break block29;
            return null;
        }
        try {
            Field[] field = entity.getClass().getDeclaredFields();
            int k = 0;
            while (k < field.length) {
                String fieldtype = field[k].getType().getName();
                String fieldname = field[k].getName().toUpperCase();
                if (rsht.containsKey(fieldname)) {
                    if (fieldtype.equals("java.lang.String")) {
                        field[k].set(entity, (String)rsht.get(fieldname));
                    } else if (fieldtype.equals("int")) {
                        field[k].setInt(entity, Integer.parseInt(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("double")) {
                        field[k].setDouble(entity, Double.parseDouble(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("long")) {
                        field[k].setLong(entity, Long.parseLong(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("float")) {
                        field[k].setFloat(entity, Float.parseFloat(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("boolean")) {
                        field[k].setBoolean(entity, Boolean.getBoolean((String)rsht.get(fieldname)));
                    }
                } else if (rsht.containsKey(fieldname.toLowerCase())) {
                    if (fieldtype.equals("java.lang.String")) {
                        field[k].set(entity, (String)rsht.get(fieldname));
                    } else if (fieldtype.equals("int")) {
                        field[k].setInt(entity, Integer.parseInt(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("double")) {
                        field[k].setDouble(entity, Double.parseDouble(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("long")) {
                        field[k].setLong(entity, Long.parseLong(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("float")) {
                        field[k].setFloat(entity, Float.parseFloat(CmUtil.null2Zero((String)rsht.get(fieldname))));
                    } else if (fieldtype.equals("boolean")) {
                        field[k].setBoolean(entity, Boolean.getBoolean((String)rsht.get(fieldname)));
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return entity;
    }

    public static void putClobData(ResultSet rs, String[] arrVal) throws Exception {
        Writer target = null;
        Reader source = null;
        try {
            try {
                if (rs.next()) {
                    int i = 0;
                    while (i < arrVal.length) {
                        System.out.println("Contents Length : " + arrVal[i].length());
                        CLOB clobData = (CLOB)rs.getClob(i + 1);
                        target = clobData.getCharacterOutputStream();
                        source = new CharArrayReader(arrVal[i].toCharArray());
                        char[] buf = new char[1024];
                        int read = 0;
                        while ((read = source.read(buf, 0, 1024)) != -1) {
                            target.write(buf, 0, read);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (target != null) {
                target.close();
            }
            if (source != null) {
                source.close();
            }
        }
    }
}

