/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.utility;

import com.ufo.base.UFOCategoryMgmtWB;
import com.ufo.base.UFOCodeMgmtWB;
import com.ufo.base.UFOSiteInfoWB;
import com.ufo.base.entity.BaseCodeEntity;
import com.ufo.base.entity.CategoryInfoEntity;
import com.ufo.base.entity.SiteInfoEntity;
import com.ufo.bbs.entity.BbsInfoEntity;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.utility.AuthHelper;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class CmHelper {
    public static SiteInfoEntity getSiteInfo(String siteCd) throws Exception {
        UFORequest temp = new UFORequest("SITE");
        UFOResult tempRes = null;
        temp.put("siteCd", siteCd);
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        tempRes = siteWb.selectSiteInfo(temp);
        return (SiteInfoEntity)tempRes.get("VIEW");
    }

    public static Vector getSiteList(String siteCd) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteList(siteCd, "");
    }

    public static Vector getSiteList(String siteCd, String familyFl) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteList(siteCd, familyFl);
    }

    public static Vector getSiteListAll(String siteCd) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteListAll(siteCd, "");
    }

    public static Vector getSiteListAll(String siteCd, String familyFl) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteListAll(siteCd, familyFl);
    }

    public static Vector getSiteList(UFORequest req) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        if (!req.isSpace("siteCd")) {
            if (!req.isSpace("familyFl")) {
                return siteWb.searchSiteList(req.getString("siteCd"), req.getString("familyFl"));
            }
            return siteWb.searchSiteList(req.getString("siteCd"), "");
        }
        if (!req.isSpace("familyFl")) {
            return siteWb.searchSiteList("", req.getString("familyFl"));
        }
        return siteWb.searchSiteList("", "");
    }

    public static Vector getSiteListAll(UFORequest req) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        if (!req.isSpace("siteCd")) {
            if (!req.isSpace("familyFl")) {
                return siteWb.searchSiteListAll(req.getString("siteCd"), req.getString("familyFl"));
            }
            return siteWb.searchSiteListAll(req.getString("siteCd"), "");
        }
        if (!req.isSpace("familyFl")) {
            return siteWb.searchSiteListAll("", req.getString("familyFl"));
        }
        return siteWb.searchSiteListAll("", "");
    }

    public static Vector getFamilySiteList(String siteCd) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteList(siteCd, "Y");
    }

    public static Vector getFamilySiteListAll(String siteCd) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteListAll(siteCd, "Y");
    }

    public static Vector getCategoryList() throws Exception {
        UFORequest req = new UFORequest();
        return CmHelper.getCategoryList(req);
    }

    public static Vector getCategoryList(UFORequest req) throws Exception {
        UFOCategoryMgmtWB catWb = new UFOCategoryMgmtWB();
        return catWb.searchCatListVt(req);
    }

    public static Vector getSiteCatList(String siteCd, String catCd) throws Exception {
        UFORequest req = new UFORequest();
        req.put("siteCd", siteCd);
        req.put("catCd", catCd);
        return CmHelper.getSiteCatList(req);
    }

    public static Vector getSiteCatList(UFORequest req) throws Exception {
        UFOCategoryMgmtWB catWb = new UFOCategoryMgmtWB();
        UFORequest temp = req.cloneReq("CAT");
        if (temp.isSpace("siteCd")) {
            temp.put("siteCd", AuthHelper.getDefault(temp, "siteCd"));
        }
        if (req.isSpace("catCd")) {
            temp.put("catCd", AuthHelper.getDefault(temp, "prgmCd"));
        }
        return catWb.searchSiteCatInfoVt(temp);
    }

    public static String getSiteCatURL(String siteCd, String catCd, String cd) throws Exception {
        UFORequest req = new UFORequest();
        req.put("siteCd", siteCd);
        req.put("catCd", catCd);
        req.put("cd", cd);
        return CmHelper.getSiteCatURL(req);
    }

    public static String getSiteCatURL(UFORequest req) throws Exception {
        CategoryInfoEntity entity;
        UFORequest temp = req.cloneReq("URL");
        UFOResult result = null;
        UFOCategoryMgmtWB catWb = new UFOCategoryMgmtWB();
        if (temp.isSpace("siteCd")) {
            temp.put("siteCd", AuthHelper.getDefault(temp, "siteCd"));
        }
        if (temp.isSpace("catCd")) {
            temp.put("catCd", AuthHelper.getDefault(temp, "prgmCd"));
        }
        if ((entity = (CategoryInfoEntity)(result = catWb.selectSiteCatInfo(temp)).get("VIEW")) != null) {
            return String.valueOf(UtilConst.UFO_WEB) + CmUtil.nullTrim(entity.attachPath);
        }
        return null;
    }

    public static String getSiteCatPath(String siteCd, String catCd, String cd) throws Exception {
        UFORequest req = new UFORequest();
        req.put("siteCd", siteCd);
        req.put("catCd", catCd);
        req.put("cd", cd);
        return CmHelper.getSiteCatPath(req);
    }

    public static String getSiteCatPath(UFORequest req) throws Exception {
        CategoryInfoEntity entity;
        UFORequest temp = req.cloneReq("URL");
        UFOResult result = null;
        UFOCategoryMgmtWB catWb = new UFOCategoryMgmtWB();
        if (temp.isSpace("siteCd")) {
            temp.put("siteCd", AuthHelper.getDefault(temp, "siteCd"));
        }
        if (temp.isSpace("catCd")) {
            temp.put("catCd", AuthHelper.getDefault(temp, "prgmCd"));
        }
        if ((entity = (CategoryInfoEntity)(result = catWb.selectSiteCatInfo(temp)).get("VIEW")) != null) {
            return String.valueOf(UtilConst.UFO_SYS) + CmUtil.nullTrim(entity.attachPath);
        }
        return null;
    }

    public static Vector getCodeList(String groupCd) throws Exception {
        UFOCodeMgmtWB cmWb = new UFOCodeMgmtWB();
        return cmWb.searchCdValList(groupCd);
    }

    public static Vector getCodeList(String groupCd, String uppCd) throws Exception {
        UFOCodeMgmtWB cmWb = new UFOCodeMgmtWB();
        return cmWb.searchCdValList(groupCd, uppCd);
    }

    public static BaseCodeEntity getCodeInfo(String groupCd, String cd) throws Exception {
        UFOCodeMgmtWB cmWb = new UFOCodeMgmtWB();
        return cmWb.selectBaseCd(groupCd, cd);
    }

    public static boolean isBbsFunc(UFORequest req, String type) throws Exception {
        boolean result = false;
        BbsInfoEntity bbsInfo = null;
        HttpSession session = req.getRequest().getSession();
        bbsInfo = (BbsInfoEntity)session.getAttribute("__ufo_bbs_info");
        if (type.equals("R") || type.equals("r")) {
            if (bbsInfo.replyFl.equals("Y")) {
                result = true;
            }
        } else if (type.equals("F") || type.equals("f")) {
            if (bbsInfo.attachFl.equals("Y")) {
                result = true;
            }
        } else if (type.equals("C") || type.equals("c")) {
            if (bbsInfo.comtFl.equals("Y")) {
                result = true;
            }
        } else if ((type.equals("P") || type.equals("p")) && bbsInfo.prdtFl.equals("Y")) {
            result = true;
        }
        return result;
    }

    public static Vector getSiteArrList(UFORequest req) throws Exception {
        UFOSiteInfoWB siteWb = new UFOSiteInfoWB();
        return siteWb.searchSiteArrList(req);
    }
}

