/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;

public class UFOResult
extends Hashtable {
    private String name = null;

    public UFOResult() {
        this.name = "unknown";
    }

    public UFOResult(String name) {
        this.name = name;
    }

    public Object clone() {
        UFOResult newRes = new UFOResult(this.name);
        UFOResult src = this;
        UFOResult target = newRes;
        Enumeration e = src.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = src.get((Object)key);
            target.put(key, value);
        }
        return newRes;
    }

    public Object get(String key) {
        return super.get(key.toUpperCase());
    }

    public void put(String key, Object obj) {
        if (obj != null) {
            super.put(key.toUpperCase(), obj);
        }
    }

    public void put(String key, boolean bool) {
        super.put(key.toUpperCase(), new Boolean(bool));
    }

    public void put(String key, int num) {
        super.put(key.toUpperCase(), new Integer(num));
    }

    public void put(String key, long num) {
        super.put(key.toUpperCase(), new Long(num));
    }

    public void put(String key, float num) {
        super.put(key.toUpperCase(), new Float(num));
    }

    public void put(String key, double num) {
        super.put(key.toUpperCase(), new Double(num));
    }

    public void remove(String key) {
        super.remove(key.toUpperCase());
    }

    public String getString(String key) {
        String value = "";
        try {
            Object o = super.get(key.toUpperCase());
            Class<?> c = o.getClass();
            value = o == null ? "" : o.toString();
        }
        catch (Exception e) {
            value = "";
        }
        return value;
    }

    public boolean getBoolean(String key) {
        boolean isTrue = false;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Boolean) {
                Boolean tmp = (Boolean)obj;
                isTrue = tmp;
            } else {
                String value = this.getString(key.toUpperCase());
                isTrue = new Boolean(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTrue;
    }

    public double getDouble(String key) {
        double num = 0.0;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Double) {
                Double tmp = (Double)obj;
                num = tmp;
            } else {
                String value = UFOResult.removeComma(this.getString(key.toUpperCase()));
                if (!value.equals("")) {
                    num = Double.valueOf(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public float getFloat(String key) {
        float num = 0.0f;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Float) {
                Float tmp = (Float)obj;
                num = tmp.floatValue();
            } else {
                num = (float)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public int getInt(String key) {
        int num = 0;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Integer) {
                Integer tmp = (Integer)obj;
                num = tmp;
            } else {
                num = (int)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public long getLong(String key) {
        long num = 0L;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Long) {
                Long tmp = (Long)obj;
                num = tmp;
            } else {
                num = (long)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    private static String removeComma(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(",") != -1) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c != ',') {
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
        return str;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration keys = this.keys();
        Enumeration objects = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String key = keys.nextElement().toString();
            String value = null;
            Object o = objects.nextElement();
            if (o == null) {
                value = "";
            } else {
                Class<?> c = o.getClass();
                if (c.isArray()) {
                    int length = Array.getLength(o);
                    if (length == 0) {
                        value = "";
                    } else if (length == 1) {
                        Object item = Array.get(o, 0);
                        value = item == null ? "" : item.toString();
                    } else {
                        StringBuffer valueBuf = new StringBuffer();
                        valueBuf.append("[");
                        int j = 0;
                        while (j < length) {
                            Object item = Array.get(o, j);
                            if (item != null) {
                                valueBuf.append(item.toString());
                            }
                            if (j < length - 1) {
                                valueBuf.append(",");
                            }
                            ++j;
                        }
                        valueBuf.append("]");
                        value = valueBuf.toString();
                    }
                } else {
                    value = o.toString();
                }
            }
            buf.append(String.valueOf(key) + "=" + value);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return "UFOResult [" + this.name + "]:" + buf.toString();
    }
}

