/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iptc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IptcAnpaParser
implements Parser {
    private static final long serialVersionUID = -6062820170212879115L;
    private static final MediaType TYPE = MediaType.text((String)"vnd.iptc.anpa");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(TYPE);
    private int FMT_ANPA_1312 = 0;
    private int FMT_ANPA_UPI = 1;
    private int FMT_ANPA_UPI_DL = 2;
    private int FMT_IPTC_7901 = 3;
    private int FMT_IPTC_PHOTO = 4;
    private int FMT_IPTC_CHAR = 5;
    private int FMT_NITF = 6;
    private int FMT_NITF_TT = 7;
    private int FMT_NITF_RB = 8;
    private int FMT_IPTC_AP = 9;
    private int FMT_IPTC_BLM = 10;
    private int FMT_IPTC_NYT = 11;
    private int FMT_IPTC_RTR = 12;
    private int FORMAT = this.FMT_ANPA_1312;
    private static final char SOH = '\u0001';
    private static final char STX = '\u0002';
    private static final char ETX = '\u0003';
    private static final char EOT = '\u0004';
    private static final char SYN = '\u0016';
    private static final char BS = '\b';
    private static final char TB = '\t';
    private static final char LF = '\n';
    private static final char FF = '\f';
    private static final char CR = '\r';
    private static final char XQ = '\u0011';
    private static final char XS = '\u0013';
    private static final char FS = '\u001f';
    private static final char HY = '-';
    private static final char SP = ' ';
    private static final char LT = '<';
    private static final char EQ = '=';
    private static final char CT = '^';
    private static final char SL = '\u0091';
    private static final char SR = '\u0092';
    private static final char DL = '\u0093';
    private static final char DR = '\u0094';

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        HashMap<String, String> properties = this.loadProperties(stream);
        this.setMetadata(metadata, properties);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        String body = this.clean(properties.get("body"));
        if (body != null) {
            xhtml.characters(body);
        }
        xhtml.endElement("p");
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private HashMap<String, String> loadProperties(InputStream is) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.FORMAT = this.scanFormat(is);
        byte[] residual = this.getSection(is, "residual");
        byte[] header = this.getSection(is, "header");
        this.parseHeader(header, properties);
        byte[] body = this.getSection(is, "body");
        this.parseBody(body, properties);
        byte[] footer = this.getSection(is, "footer");
        this.parseFooter(footer, properties);
        return properties;
    }

    private int scanFormat(InputStream is) {
        int format = this.FORMAT;
        int maxsize = 524288;
        byte[] buf = new byte[maxsize];
        try {
            if (is.markSupported()) {
                is.mark(maxsize);
            }
            int msgsize = is.read(buf);
            String message = new String(buf, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT);
            if (message.contains("ap-wf")) {
                format = this.FMT_IPTC_AP;
            }
            if (message.contains("reuters")) {
                format = this.FMT_IPTC_RTR;
            }
            if (message.contains("new york times")) {
                format = this.FMT_IPTC_NYT;
            }
            if (message.contains("bloomberg news")) {
                format = this.FMT_IPTC_BLM;
            }
        }
        catch (IOException eio) {
            // empty catch block
        }
        try {
            if (is.markSupported()) {
                is.reset();
            }
        }
        catch (IOException eio) {
            // empty catch block
        }
        return format;
    }

    private void setFormat(int format) {
        this.FORMAT = format;
    }

    private String getFormatName() {
        String name = "";
        if (this.FORMAT == this.FMT_IPTC_AP) {
            name = "Associated Press";
        } else if (this.FORMAT == this.FMT_IPTC_BLM) {
            name = "Bloomberg";
        } else if (this.FORMAT == this.FMT_IPTC_NYT) {
            name = "New York Times";
        } else if (this.FORMAT == this.FMT_IPTC_RTR) {
            name = "Reuters";
        }
        return name;
    }

    private byte[] getSection(InputStream is, String name) {
        byte[] value = new byte[]{};
        if (name.equals("residual")) {
            int maxsize = 8192;
            byte bstart = 22;
            byte bfinish = 1;
            value = this.getSection(is, maxsize, bstart, bfinish, true);
        } else if (name.equals("header")) {
            int maxsize = 8192;
            byte bstart = 1;
            byte bfinish = 2;
            value = this.getSection(is, maxsize, bstart, bfinish, true);
        } else if (name.equals("body")) {
            int maxsize = 524288;
            byte bstart = 2;
            byte bfinish = 3;
            value = this.getSection(is, maxsize, bstart, bfinish, true);
        } else if (name.equals("footer")) {
            int maxsize = 8192;
            byte bstart = 3;
            byte bfinish = 4;
            value = this.getSection(is, maxsize, bstart, bfinish, true);
        }
        return value;
    }

    private byte[] getSection(InputStream is, int maxsize, byte bstart, byte bfinish, boolean ifincomplete) {
        byte[] value = new byte[]{};
        try {
            boolean started = false;
            boolean finished = false;
            int read = 0;
            int start = 0;
            int streammax = is.available();
            maxsize = Math.min(maxsize, streammax);
            is.mark(maxsize);
            byte[] buf = new byte[maxsize];
            int totsize = 0;
            int remainder = maxsize - totsize;
            while (remainder > 0) {
                int msgsize = is.read(buf, maxsize - remainder, maxsize);
                if (msgsize == -1) {
                    msgsize = 0;
                    remainder = 0;
                }
                remainder -= msgsize;
                totsize += msgsize;
            }
            for (read = 0; read < totsize; ++read) {
                byte b = buf[read];
                if (!started) {
                    started = b == bstart;
                    start = read + 1;
                    continue;
                }
                finished = b == bfinish;
                if (finished) break;
            }
            is.reset();
            if (finished) {
                is.skip(read);
                value = new byte[read - start];
                System.arraycopy(buf, start, value, 0, read - start);
            } else if (ifincomplete && started) {
                value = new byte[read - start];
                System.arraycopy(buf, start, value, 0, read - start);
            }
        }
        catch (IOException eio) {
            // empty catch block
        }
        return value;
    }

    private boolean parseHeader(byte[] value, HashMap<String, String> properties) {
        boolean added = false;
        String env_serviceid = "";
        String env_category = "";
        String env_urgency = "";
        String hdr_edcode = "";
        String hdr_subject = "";
        String hdr_date = "";
        String hdr_time = "";
        int read = 0;
        if (read < value.length) {
            byte val_next;
            while (read < value.length && (val_next = value[read++]) != 31) {
                env_serviceid = env_serviceid + (char)(val_next & 0xFF);
            }
            while (read < value.length) {
                if ((val_next = value[read++]) != 19) {
                    env_category = env_category + (char)(val_next & 0xFF);
                    continue;
                }
                val_next = value[read];
                if (val_next != 17) break;
                ++read;
                break;
            }
            while (read < value.length) {
                boolean subject = true;
                byte val_next2 = value[read++];
                while (subject && val_next2 != 32 && val_next2 != 0) {
                    hdr_subject = hdr_subject + (char)(val_next2 & 0xFF);
                    byte by = val_next2 = read < value.length ? value[read++] : (byte)0;
                    while (val_next2 == 32) {
                        subject = false;
                        val_next2 = read < value.length ? value[read++] : (byte)0;
                        if (val_next2 == 32) continue;
                        --read;
                    }
                }
                if (subject) continue;
                break;
            }
            while (read < value.length) {
                val_next = value[read++];
                if (hdr_date.length() == 0) {
                    while (val_next >= 48 && val_next <= 57 || val_next == 45) {
                        hdr_date = hdr_date + (char)(val_next & 0xFF);
                        val_next = read < value.length ? value[read++] : (byte)0;
                    }
                    continue;
                }
                if (val_next == 32) {
                    while (val_next == 32) {
                        val_next = read < value.length ? value[read++] : (byte)0;
                    }
                    continue;
                }
                while (val_next >= 48 && val_next <= 57 || val_next == 45) {
                    hdr_time = hdr_time + (char)(val_next & 0xFF);
                    val_next = read < value.length ? value[read++] : (byte)0;
                }
            }
        }
        added = env_serviceid.length() + env_category.length() + hdr_subject.length() + hdr_date.length() + hdr_time.length() > 0;
        return added;
    }

    private boolean parseBody(byte[] value, HashMap<String, String> properties) {
        boolean added = false;
        String bdy_heading = "";
        String bdy_title = "";
        String bdy_source = "";
        String bdy_author = "";
        String bdy_body = "";
        int read = 0;
        boolean done = false;
        while (!done && read < value.length) {
            byte val_next;
            while (read < value.length) {
                if ((val_next = value[read++]) == 94) {
                    byte by = val_next = read < value.length ? value[read++] : (byte)0;
                    while (val_next != 60 && val_next != 13 && val_next != 10) {
                        bdy_heading = bdy_heading + (char)(val_next & 0xFF);
                        byte by2 = val_next = read < value.length ? value[read++] : (byte)0;
                        if (read <= value.length) continue;
                    }
                    if (val_next == 60) {
                        byte by3 = val_next = read < value.length ? value[read++] : (byte)0;
                    }
                    while (bdy_heading.length() > 0 && (val_next == 13 || val_next == 10)) {
                        val_next = read < value.length ? value[read++] : (byte)0;
                        if (val_next == 13 || val_next == 10) continue;
                        --read;
                    }
                    break;
                }
                if (this.FORMAT != this.FMT_IPTC_RTR || val_next == 94) break;
                if (val_next != 32 && val_next != 9 && val_next != 13 && val_next != 10 && read == 1) {
                    byte[] resize = new byte[value.length + 1];
                    System.arraycopy(value, 0, resize, 1, value.length);
                    value = resize;
                }
                value[--read] = 94;
            }
            while (read < value.length) {
                if ((val_next = value[read++]) == 94) {
                    byte by = val_next = read < value.length ? value[read++] : (byte)0;
                    while (val_next != 60 && val_next != 94 && val_next != 13 && val_next != 10) {
                        bdy_title = bdy_title + (char)(val_next & 0xFF);
                        byte by4 = val_next = read < value.length ? value[read++] : (byte)0;
                        if (read <= value.length) continue;
                    }
                    if (val_next == 94) {
                        --read;
                    }
                    if (val_next == 60) {
                        byte by5 = val_next = read < value.length ? value[read++] : (byte)0;
                    }
                    while (bdy_title.length() > 0 && (val_next == 13 || val_next == 10)) {
                        val_next = read < value.length ? value[read++] : (byte)0;
                        if (val_next == 13 || val_next == 10) continue;
                        --read;
                    }
                    break;
                }
                if (this.FORMAT == this.FMT_IPTC_BLM && val_next == 9) {
                    value[--read] = 94;
                    continue;
                }
                if (this.FORMAT != this.FMT_IPTC_RTR || val_next == 94) break;
                if (val_next != 32 && val_next != 9 && val_next != 13 && val_next != 10) {
                    --read;
                }
                value[--read] = 94;
            }
            boolean metastarted = false;
            String longline = "";
            String longkey = "";
            block7: while (read < value.length) {
                byte val_next2;
                if ((val_next2 = value[read++]) == 32 || val_next2 == 9 || val_next2 == 13 || val_next2 == 10) continue;
                if (val_next2 == 94) {
                    val_next2 = read < value.length ? value[read++] : (byte)0;
                    String tmp_line = "";
                    while (val_next2 != 60 && val_next2 != 94 && val_next2 != 13 && val_next2 != 10 && val_next2 != 0) {
                        tmp_line = tmp_line + (char)(val_next2 & 0xFF);
                        byte by = val_next2 = read < value.length ? value[read++] : (byte)0;
                        if (read <= value.length) continue;
                    }
                    if (val_next2 == 94) {
                        --read;
                    }
                    if (val_next2 == 60) {
                        byte by = val_next2 = read < value.length ? value[read++] : (byte)0;
                    }
                    while (val_next2 == 13 || val_next2 == 10) {
                        val_next2 = read < value.length ? value[read++] : (byte)0;
                        if (val_next2 == 13 || val_next2 == 10) continue;
                        --read;
                    }
                    if (tmp_line.toLowerCase(Locale.ROOT).startsWith("by") || longline.equals("bdy_author")) {
                        longkey = "bdy_author";
                        tmp_line = (longline.equals(longkey) ? " " : "") + tmp_line;
                        int term = tmp_line.length();
                        term = Math.min(term, tmp_line.contains("<") ? tmp_line.indexOf("<") : term);
                        term = Math.min(term, tmp_line.contains("=") ? tmp_line.indexOf("=") : term);
                        term = Math.min(term, tmp_line.contains("\n") ? tmp_line.indexOf("\n") : term);
                        term = term > 0 ? term : tmp_line.length();
                        bdy_author = bdy_author + tmp_line.substring(tmp_line.indexOf(" "), term);
                        metastarted = true;
                        longline = tmp_line.contains("=") && !longline.equals(longkey) ? longkey : "";
                        continue;
                    }
                    if (this.FORMAT == this.FMT_IPTC_BLM) {
                        String byline = "   by ";
                        if (tmp_line.toLowerCase(Locale.ROOT).contains(byline)) {
                            longkey = "bdy_author";
                            int term = tmp_line.length();
                            term = Math.min(term, tmp_line.contains("<") ? tmp_line.indexOf("<") : term);
                            term = Math.min(term, tmp_line.contains("=") ? tmp_line.indexOf("=") : term);
                            term = Math.min(term, tmp_line.contains("\n") ? tmp_line.indexOf("\n") : term);
                            term = term > 0 ? term : tmp_line.length();
                            bdy_author = bdy_author + tmp_line.substring(tmp_line.toLowerCase(Locale.ROOT).indexOf(byline) + byline.length(), term) + " ";
                            metastarted = true;
                            longline = tmp_line.contains("=") && !longline.equals(longkey) ? longkey : "";
                            continue;
                        }
                        if (tmp_line.toLowerCase(Locale.ROOT).startsWith("c.")) {
                            if (val_next2 != 9) continue;
                            value[--read] = 94;
                            continue;
                        }
                        if (!tmp_line.toLowerCase(Locale.ROOT).trim().startsWith("(") || !tmp_line.toLowerCase(Locale.ROOT).trim().endsWith(")") || val_next2 != 9) continue;
                        value[--read] = 94;
                        continue;
                    }
                    if (tmp_line.toLowerCase(Locale.ROOT).startsWith("eds") || longline.equals("bdy_source")) {
                        longkey = "bdy_source";
                        tmp_line = (longline.equals(longkey) ? " " : "") + tmp_line;
                        int term = tmp_line.length();
                        term = Math.min(term, tmp_line.contains("<") ? tmp_line.indexOf("<") : term);
                        term = Math.min(term, tmp_line.contains("=") ? tmp_line.indexOf("=") : term);
                        term = term > 0 ? term : tmp_line.length();
                        bdy_source = bdy_source + tmp_line.substring(tmp_line.indexOf(" ") + 1, term) + " ";
                        metastarted = true;
                        longline = !longline.equals(longkey) ? longkey : "";
                        continue;
                    }
                    if (!metastarted) {
                        bdy_title = bdy_title + " , " + tmp_line;
                        continue;
                    }
                    bdy_body = bdy_body + " " + tmp_line + " , ";
                    continue;
                }
                while (read < value.length && val_next2 != 0) {
                    bdy_body = bdy_body + (char)(val_next2 & 0xFF);
                    byte by = val_next2 = read < value.length ? value[read++] : (byte)0;
                    if (read <= value.length) continue;
                    continue block7;
                }
            }
            done = true;
        }
        properties.put("body", bdy_body);
        properties.put("title", bdy_title);
        properties.put("subject", bdy_heading);
        properties.put("author", bdy_author);
        properties.put("source", bdy_source);
        added = bdy_body.length() + bdy_title.length() + bdy_heading.length() + bdy_author.length() + bdy_source.length() > 0;
        return added;
    }

    private boolean parseFooter(byte[] value, HashMap<String, String> properties) {
        boolean added = false;
        String ftr_source = "";
        String ftr_datetime = "";
        int read = 0;
        boolean done = false;
        while (!done && read < value.length) {
            byte val_peek;
            byte val_next = value[read++];
            byte by = val_peek = read < value.length ? value[read + 1] : (byte)0;
            while ((val_next < 48 || val_next > 57) && val_next != 0) {
                ftr_source = ftr_source + (char)(val_next & 0xFF);
                byte by2 = val_next = read < value.length ? value[read] : (byte)0;
                if (++read <= value.length) continue;
            }
            while (val_next != 60 && val_next != 13 && val_next != 10 && val_next != 0) {
                ftr_datetime = ftr_datetime + (char)(val_next & 0xFF);
                byte by3 = val_next = read < value.length ? value[read++] : (byte)0;
                if (read <= value.length) continue;
            }
            if (val_next == 60) {
                byte by4 = val_next = read < value.length ? value[read++] : (byte)0;
            }
            if (ftr_datetime.length() > 0) {
                String format_out = "yyyy-MM-dd'T'HH:mm:ss'Z'";
                Date dateunix = new Date();
                try {
                    String format_in = "MM-dd-yy HHmmzzz";
                    if (this.FORMAT == this.FMT_IPTC_RTR) {
                        format_in = "HH:mm MM-dd-yy";
                    }
                    SimpleDateFormat dfi = new SimpleDateFormat(format_in, Locale.ROOT);
                    dfi.setTimeZone(TimeZone.getTimeZone("UTC"));
                    dateunix = dfi.parse(ftr_datetime);
                }
                catch (ParseException ep) {
                    // empty catch block
                }
                SimpleDateFormat dfo = new SimpleDateFormat(format_out, Locale.ROOT);
                dfo.setTimeZone(TimeZone.getTimeZone("UTC"));
                ftr_datetime = dfo.format(dateunix);
            }
            while (val_next == 13 || val_next == 10) {
                val_next = read < value.length ? value[read++] : (byte)0;
                if (val_next == 13 || val_next == 10) continue;
                --read;
            }
            done = true;
        }
        properties.put("publisher", ftr_source);
        properties.put("created", ftr_datetime);
        properties.put("modified", ftr_datetime);
        added = ftr_source.length() + ftr_datetime.length() > 0;
        return added;
    }

    private void setMetadata(Metadata metadata, HashMap<String, String> properties) {
        metadata.set("Content-Type", this.clean("text/anpa-1312"));
        metadata.set(TikaCoreProperties.TITLE, this.clean(properties.get("title")));
        metadata.set(TikaCoreProperties.KEYWORDS, this.clean(properties.get("subject")));
        metadata.set(TikaCoreProperties.CREATOR, this.clean(properties.get("author")));
        metadata.set(TikaCoreProperties.CREATED, this.clean(properties.get("created")));
        metadata.set(TikaCoreProperties.MODIFIED, this.clean(properties.get("modified")));
        metadata.set(TikaCoreProperties.SOURCE, this.clean(properties.get("source")));
        metadata.set(TikaCoreProperties.PUBLISHER, this.clean(this.getFormatName()));
    }

    private String clean(String value) {
        if (value == null) {
            value = "";
        }
        value = value.replaceAll("``", "`");
        value = value.replaceAll("''", "'");
        value = value.replaceAll(new String(new char[]{'\u0091'}), "'");
        value = value.replaceAll(new String(new char[]{'\u0092'}), "'");
        value = value.replaceAll(new String(new char[]{'\u0093'}), "\"");
        value = value.replaceAll(new String(new char[]{'\u0094'}), "\"");
        value = value.trim();
        return value;
    }
}

