/*
 * Decompiled with CFR 0.152.
 */
package com.solbitech.common.util;

import com.activeintra.manager.AIProperties;
import com.activeintra.manager.AIScriptManager;
import com.solbitech.common.sys.CommControl;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConn
extends CommControl {
    private static boolean databaseFlag = false;
    private Map<String, String> databaseMap;
    private String errorCode = "";
    private Logger logger;

    protected DatabaseConn() {
    }

    public void setDataBaseNm(String databaseKey) {
        if (this.databaseMap == null) {
            this.databaseMap = new HashMap<String, String>();
        }
        this.databaseMap.put("databaseKey", databaseKey);
    }

    protected Connection inintDataBaseService() {
        this.initLogger("DatabaseConn");
        this.logger = commLog;
        this.getAES256KeyLoad();
        Connection commConnection = null;
        if (this.dataBaseProperties()) {
            int dbLinkCount = Integer.parseInt(this.get0(this.databaseMap.get("dbLinkCount")));
            int n = dbLinkCount = dbLinkCount == 0 ? 1 : dbLinkCount;
            if (databaseFlag) {
                dbLinkCount = 1;
            }
            int cnt = 0;
            while (cnt < dbLinkCount) {
                commConnection = this.getBaseConnection();
                if (commConnection != null) {
                    databaseFlag = true;
                    break;
                }
                ++cnt;
            }
        }
        return commConnection;
    }

    protected String getErrorMessage() {
        return this.errorCode;
    }

    private boolean dataBaseProperties() {
        boolean proFlag = false;
        AIProperties aiproperties = null;
        try {
            try {
                if (this.databaseMap == null) {
                    this.databaseMap = new HashMap<String, String>();
                }
                if ((aiproperties = AIScriptManager.aiProps) != null) {
                    this.databaseMap.put("wasServerName", this.getB(aiproperties.getProperties("ServerWas")).trim());
                    this.databaseMap.put("dbManager", this.getB(aiproperties.getProperties("dbManager")).trim());
                    this.databaseMap.put("dbLinkCount", this.getB(aiproperties.getProperties("dbLinkCount")).trim());
                } else {
                    this.databaseMap.put("wasServerName", this.getB(commProperties.getProperty("ServerWas")).trim());
                    this.databaseMap.put("dbManager", this.getB(commProperties.getProperty("dbManager")).trim());
                    this.databaseMap.put("dbLinkCount", this.getB(commProperties.getProperty("dbLinkCount")).trim());
                }
                proFlag = true;
            }
            catch (NullPointerException e) {
                this.debugLog(this.logger, "#dataBaseProperties ===> " + e);
                if (aiproperties != null) {
                    aiproperties = null;
                }
            }
        }
        finally {
            if (aiproperties != null) {
                aiproperties = null;
            }
        }
        return proFlag;
    }

    private Connection getBaseConnection() {
        Connection connection;
        block33: {
            connection = null;
            Context initContext = null;
            Context context = null;
            DataSource dataSource = null;
            try {
                try {
                    Map<String, String> database = this.dataBaseManager();
                    String databaseType = this.getB(database.get("databaseType"));
                    StringBuffer databaseInfo = new StringBuffer(this.getB(database.get("databaseInfo")));
                    if (databaseType.equals("jndi")) {
                        String wasServerName = this.getB(this.databaseMap.get("wasServerName"));
                        if (wasServerName.equals("weblogic")) {
                            Driver myDriver = (Driver)Class.forName("weblogic.jdbc.pool.Driver").newInstance();
                            databaseInfo.insert(0, "jdbc:weblogic:pool:");
                            connection = myDriver.connect(databaseInfo.toString(), null);
                        } else {
                            context = new InitialContext();
                            initContext = wasServerName.equals("resin") || wasServerName.equals("jboss") ? (Context)context.lookup("java:comp/env") : new InitialContext();
                            if (wasServerName.equals("tomcat") || wasServerName.equals("jetty")) {
                                if (databaseInfo.indexOf("/") == -1) {
                                    databaseInfo.insert(0, "jdbc/");
                                }
                                databaseInfo.insert(0, "java:comp/env/");
                            }
                            dataSource = (DataSource)initContext.lookup(databaseInfo.toString());
                            connection = dataSource.getConnection();
                        }
                        this.debugLog(this.logger, "#Connection information >>>>> " + databaseInfo.toString() + " success");
                        break block33;
                    }
                    JSONObject jsondata = this.connectionInfo(databaseType);
                    if (jsondata != null) {
                        String connDbId = this.getB(database.get("databaseId"));
                        String connDbPw = this.convertCode.getDecoder(DatabaseConn.getCommRA(this.getB(database.get("databasePw")), "VPD-", ""));
                        connDbPw = DatabaseConn.getCommRA(connDbPw, "[#]", "#");
                        Class.forName(this.getB(jsondata.get((Object)"DRIVER")));
                        if (databaseType.indexOf("informix") != -1) {
                            databaseInfo.append("|").append(connDbId).append("|").append(connDbPw);
                            databaseInfo = new StringBuffer(DatabaseConn.getCommRA(this.getB(jsondata.get((Object)"JDBC")), "@JDBC_INFO|@USER_INFO|@PASS_INFO", databaseInfo.toString()));
                            connection = DriverManager.getConnection(databaseInfo.toString());
                        } else {
                            databaseInfo = new StringBuffer(DatabaseConn.getCommRA(this.getB(jsondata.get((Object)"JDBC")), "@JDBC_INFO", databaseInfo.toString()));
                            connection = DriverManager.getConnection(databaseInfo.toString(), connDbId, connDbPw);
                        }
                    }
                    this.debugLog(this.logger, "#Connection information >>>>> " + databaseInfo.toString() + " success");
                }
                catch (Exception e) {
                    this.debugLog(this.logger, "#dataBaseService ===> " + e);
                    this.errorCode = e.getMessage();
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (dataSource != null) {
                        dataSource = null;
                    }
                    if (initContext != null) {
                        try {
                            initContext.close();
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    if (context == null) break block33;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
            finally {
                if (dataSource != null) {
                    dataSource = null;
                }
                if (initContext != null) {
                    try {
                        initContext.close();
                    }
                    catch (NamingException namingException) {}
                }
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
        return connection;
    }

    private Map<String, String> dataBaseManager() throws UnsupportedEncodingException {
        Map<String, String> database = null;
        String dbManager = this.getB(this.databaseMap.get("dbManager"));
        if (!dbManager.equals("")) {
            String databaseKey;
            if (commDataBaseMap == null) {
                this.initDatabaseManager(dbManager);
            }
            if (!(databaseKey = this.getB(this.databaseMap.get("databaseKey"))).equals("")) {
                database = (Map)commDataBaseMap.get(databaseKey);
                if (database == null) {
                    database = new HashMap();
                    database.put("databaseType", "jndi");
                    database.put("databaseInfo", databaseKey);
                }
            } else {
                String dbMasterKey = "";
                if (commDataBaseMap.get("connDb") != null) {
                    dbMasterKey = this.getB(((Map)commDataBaseMap.get("connDb")).get("key"));
                }
                if (dbMasterKey.equals("")) {
                    dbMasterKey = this.getB(((Map)commDataBaseMap.get("connPool")).get("key"));
                }
                database = (Map)commDataBaseMap.get(dbMasterKey);
            }
        } else {
            database = new HashMap<String, String>();
            database.put("databaseType", "");
            database.put("databaseInfo", "");
            database.put("databaseId", "");
            database.put("databasePw", "");
        }
        return database;
    }
}

