/*
 * Decompiled with CFR 0.152.
 */
package com.solbitech.common.util;

import com.solbitech.common.sys.CommControl;
import com.solbitech.common.util.ConvertCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertServer
extends CommControl {
    private HttpServletResponse response;
    private String fileType = "";
    private String jspUrl = "";
    private String crtDirectory = "";
    private String crtFolderNm = "";
    private boolean exception = false;
    private Map<String, String> paramMap = null;
    private Map<String, String> convertConfigMap;
    private Map<String, String> convertParamMap;
    private List<String> convertFilePaths;
    private Object converObject;
    private Map<String, Object> objectMap;
    private List<String> fileList;
    private String methodType;
    private String retrunType;
    private Logger logger;
    private static final int COMPRESSION_LEVEL = 8;
    private static final int BUFFER_SIZE = 2048;

    protected ConvertServer() {
    }

    public ConvertServer(Object converObject) {
        this.converObject = converObject;
    }

    public ConvertServer(HttpServletRequest commHttpRequest, PageContext pageContext) {
        this.commHttpRequest = commHttpRequest;
        this.commPageContext = pageContext;
    }

    public void setConvert(String infos, String options) throws Exception {
        JSONObject jsonoption;
        JSONObject jsoninfo = this.jsonString(infos);
        if (this.setInfoData(jsoninfo, jsonoption = this.jsonString(options))) {
            this.commServcieConvert();
        }
    }

    private boolean setInfoData(JSONObject jsoninfo, JSONObject jsonoption) {
        this.convertConfigMap = new HashMap<String, String>();
        if (jsoninfo != null) {
            for (Object key : jsoninfo.keySet()) {
                this.convertConfigMap.put(String.valueOf(key), this.getB(jsoninfo.get(key)));
            }
        }
        if (jsonoption != null) {
            for (Object key : jsonoption.keySet()) {
                this.convertConfigMap.put(String.valueOf(key), this.getB(jsonoption.get(key)));
            }
        }
        return true;
    }

    private void commServcieConvert() throws Exception {
        this.convertFilePaths = new ArrayList<String>();
        if (this.convertConfigMap != null) {
            if (this.converObject != null) {
                List convertList = (List)this.converObject;
                for (Object convert : convertList) {
                    this.convertFilePaths.add(this.serverConnection((Map)convert));
                }
            } else {
                this.convertFilePaths.add("none");
            }
        }
    }

    private String serverConnection(Map<String, String> convertInfo) throws Exception {
        StringBuffer targetPath;
        block39: {
            targetPath = new StringBuffer();
            HttpURLConnection httpUrlConn = null;
            InputStreamReader inputReader = null;
            BufferedReader buffReader = null;
            try {
                try {
                    int resultCode;
                    String sessionStr;
                    Map<String, String> connInfo = this.convertConnInfo(convertInfo);
                    String protocol = this.getB(connInfo.get("protocol"));
                    if (!protocol.equals("")) {
                        this.getCommHTTPS(protocol);
                    }
                    httpUrlConn = (HttpURLConnection)new URL(this.getB(connInfo.get("url"))).openConnection();
                    httpUrlConn.setRequestMethod(this.getB(connInfo.get("method")));
                    httpUrlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    httpUrlConn.setUseCaches(false);
                    httpUrlConn.setDoOutput(true);
                    httpUrlConn.setDoInput(true);
                    if (this.commHttpRequest != null && !(sessionStr = this.getControlCookie(this.commHttpRequest)).trim().equals("")) {
                        httpUrlConn.setRequestProperty("Cookie", sessionStr);
                    }
                    if (this.getB(connInfo.get("method")).equals("POST")) {
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpUrlConn.getOutputStream()));
                        printWriter.write(this.getB(connInfo.get("parameter")));
                        printWriter.flush();
                    }
                    if ((resultCode = httpUrlConn.getResponseCode()) != 200) {
                        this.debugLog(this.logger, "Report Server responded with code[" + resultCode + "]");
                        throw new IOException("Report Server responded with code[" + resultCode + "]");
                    }
                    if (!this.getB(this.convertConfigMap.get("STG")).equals("N")) {
                        inputReader = new InputStreamReader(httpUrlConn.getInputStream(), "UTF-8");
                        buffReader = new BufferedReader(inputReader);
                        String httpStr = "";
                        while ((httpStr = buffReader.readLine()) != null) {
                            targetPath.append(httpStr);
                        }
                        JSONArray array = this.jsonArray(targetPath.toString());
                        JSONObject object = (JSONObject)array.get(0);
                        targetPath.setLength(0);
                        targetPath.append(object.get((Object)"targetURL"));
                    } else {
                        targetPath.setLength(0);
                        targetPath.append(this.getCommSave(this.getB(connInfo.get("savename")), httpUrlConn.getInputStream()));
                    }
                }
                catch (IOException e) {
                    this.debugLog(this.logger, "#serverConnection ===> " + e);
                    try {
                        if (buffReader != null) {
                            buffReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputReader != null) {
                            inputReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (httpUrlConn != null) {
                            httpUrlConn.disconnect();
                        }
                        break block39;
                    }
                    catch (Exception exception) {}
                    break block39;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (buffReader != null) {
                        buffReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (httpUrlConn != null) {
                        httpUrlConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (httpUrlConn != null) {
                    httpUrlConn.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return targetPath.toString();
    }

    private String convertHtmlTag() {
        StringBuffer bodytag;
        block48: {
            StringBuffer styletag = new StringBuffer();
            bodytag = new StringBuffer();
            HttpURLConnection httpUrlConn = null;
            InputStreamReader inputReader = null;
            BufferedReader buffReader = null;
            try {
                try {
                    int resultCode;
                    String sessionStr;
                    String commUrl = this.commHttpdefUrl();
                    StringBuffer commParam = new StringBuffer(this.commHttpParameter());
                    commParam.append("reportMode=HTML&reportParams=showMenuBar:false,simpleMode:true&");
                    this.debugLog(this.logger, "#commUrl ===> " + commUrl);
                    this.debugLog(this.logger, "#commParam ===> " + commParam);
                    if (this.convertConfigMap != null) {
                        this.debugLog(this.logger, "commServiceHttp ===> " + this.getB(this.convertConfigMap.get("M")) + "/" + this.getB(this.convertConfigMap.get("C")));
                    }
                    if (this.convertConfigMap != null && this.getB(this.convertConfigMap.get("M")).equals("GET") && commUrl.indexOf("?") == -1) {
                        commUrl = String.valueOf(commUrl) + "?" + commParam.toString();
                    }
                    httpUrlConn = (HttpURLConnection)new URL(commUrl).openConnection();
                    httpUrlConn.setRequestMethod(this.getB(this.convertConfigMap.get("M")));
                    httpUrlConn.setRequestProperty("Content-Type", "html/text; charset=" + this.getB(this.convertConfigMap.get("C")));
                    httpUrlConn.setUseCaches(false);
                    httpUrlConn.setDoOutput(true);
                    httpUrlConn.setDoInput(true);
                    if (this.commHttpRequest != null && !(sessionStr = this.getControlCookie(this.commHttpRequest)).trim().equals("")) {
                        httpUrlConn.setRequestProperty("Cookie", sessionStr);
                    }
                    if (this.convertConfigMap != null && this.getB(this.convertConfigMap.get("M")).equals("POST")) {
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpUrlConn.getOutputStream(), this.getB(this.convertConfigMap.get("C"))));
                        printWriter.write(commParam.toString());
                        printWriter.flush();
                    }
                    if ((resultCode = httpUrlConn.getResponseCode()) != 200) {
                        this.debugLog(this.logger, this.getControlResultCode(resultCode));
                        throw new IOException();
                    }
                    inputReader = new InputStreamReader(httpUrlConn.getInputStream(), this.getB(this.convertConfigMap.get("C")));
                    buffReader = new BufferedReader(inputReader);
                    HashMap<String, String> styleMap = new HashMap<String, String>();
                    String styleKey = "";
                    boolean body = false;
                    boolean style = false;
                    String strDmy = "";
                    while ((strDmy = buffReader.readLine()) != null) {
                        if (this.getHtmlDataFilter(strDmy.trim())) continue;
                        if (strDmy.trim().indexOf("<style type=\"text/css\"") != -1) {
                            style = true;
                            continue;
                        }
                        if (strDmy.trim().indexOf("</head>") != -1) {
                            style = false;
                            continue;
                        }
                        if (style) {
                            if (strDmy.trim().indexOf(".cell") != -1 || strDmy.trim().indexOf("#") != -1) {
                                if (styletag.length() > 3) {
                                    styleMap.put(styleKey, styletag.toString());
                                    styletag.setLength(0);
                                }
                                styleKey = ConvertServer.getCommRA(strDmy.trim(), "{", "");
                            } else {
                                styletag.append(strDmy.trim()).append(" ");
                            }
                        }
                        if (strDmy.trim().indexOf("<div id=\"report\" name=\"report\"") != -1) {
                            body = true;
                            bodytag.append("<html><body>\r\n");
                            bodytag.append(strDmy.trim()).append("\r\n");
                            continue;
                        }
                        if (strDmy.trim().indexOf("<div id=\"pdfdiv\"") != -1) {
                            bodytag.append("</body></html>").append("\r\n");
                            break;
                        }
                        if (!body) continue;
                        bodytag.append(strDmy.trim()).append("\r\n");
                    }
                    for (String key : styleMap.keySet()) {
                        String value = "";
                        if (key.indexOf(".") != -1) {
                            value = String.format("style='%s'", styleMap.get(key));
                            key = String.format("class=\"%s\"", ConvertServer.getCommRA(key, ".", ""));
                        }
                        bodytag = new StringBuffer(ConvertServer.getCommRA(bodytag.toString(), key, value));
                    }
                    bodytag = new StringBuffer(ConvertServer.getCommRA(bodytag.toString(), "id=\"report\"", String.format("style=\"%s\"", this.getB(styleMap.get("#report ")))));
                    bodytag = new StringBuffer(ConvertServer.getCommRA(bodytag.toString(), "id=\"subreport\"", String.format("style=\"%s\"", this.getB(styleMap.get("#subreport>div ")))));
                    bodytag = new StringBuffer(ConvertServer.getCommRA(bodytag.toString(), "<table style=\"", String.format("<table style=\"%s ", this.getB(styleMap.get("#report table ")))));
                }
                catch (Exception e) {
                    this.debugLog(this.logger, "#commServiceHttp ===> " + e);
                    e.printStackTrace();
                    try {
                        if (buffReader != null) {
                            buffReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (inputReader != null) {
                            inputReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (httpUrlConn != null) {
                            httpUrlConn.disconnect();
                        }
                        break block48;
                    }
                    catch (Exception exception) {}
                    break block48;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (buffReader != null) {
                        buffReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (httpUrlConn != null) {
                        httpUrlConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (httpUrlConn != null) {
                    httpUrlConn.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bodytag.toString();
    }

    private Map<String, String> convertConnInfo(Map<String, String> convertInfo) {
        HashMap<String, String> connInfo = new HashMap<String, String>();
        String type = this.getB(this.convertConfigMap.get("TP"));
        String method = this.getB(this.convertConfigMap.get("M"));
        String url = this.getB(convertInfo.get("url"));
        String params = this.getB(convertInfo.get("params"));
        String name = this.getB(convertInfo.get("name"));
        StringBuffer parameter = new StringBuffer();
        ArrayList<String> reportparams = new ArrayList<String>();
        if (this.getB(this.convertConfigMap.get("EDIT")).equals("Y")) {
            reportparams.add("pdfEditable:true");
        }
        reportparams.add(String.valueOf(type.toLowerCase()) + "serversave:true");
        if (!name.equals("")) {
            String filename;
            File file;
            File file2;
            reportparams.add("savename:" + ConvertServer.getCommRA(name, " |:", "_|!@"));
            connInfo.put("savename", String.valueOf(ConvertServer.getCommRA(name, " ", "_")) + "." + type.toLowerCase());
            if (this.getB(this.convertConfigMap.get("OVR")).equals("Y") && name.indexOf("/") != -1 && (file2 = new File(String.valueOf(name) + "." + type.toLowerCase())).isFile()) {
                file2.delete();
            }
            if (this.getB(this.convertConfigMap.get("FOLD")).equals("Y") && name.indexOf("/") != -1 && !(file = new File(name = ConvertServer.getCommRA(name, filename = new File(name).getName(), ""))).isDirectory()) {
                file.mkdirs();
            }
        } else if (name.equals("DATE")) {
            reportparams.add("savename:" + this.getCommDT("yyyyMMddHHmmss"));
            connInfo.put("savename", this.getCommDT("yyyyMMddHHmmss"));
        }
        connInfo.put("protocol", this.getB(this.convertConfigMap.get("P")));
        parameter.append(params);
        parameter.append("&reportMode=").append(type);
        parameter.append("&reportParams=").append(ConvertServer.getCommRA(((Object)reportparams).toString(), "[|]| ", "||"));
        connInfo.put("method", method);
        if (method.equals("POST")) {
            connInfo.put("url", url);
            connInfo.put("parameter", parameter.toString());
        } else {
            connInfo.put("url", String.valueOf(url) + "?" + parameter.toString());
        }
        return connInfo;
    }

    public ConvertServer(String jspUrl) {
        this.jspUrl = jspUrl;
    }

    public ConvertServer(HttpServletRequest request, PageContext pageContext, String fileType) {
        this.commHttpRequest = request;
        this.commPageContext = pageContext;
        this.fileType = fileType;
        this.initLogger("ConvertServer");
        this.logger = commLog;
    }

    public ConvertServer(HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String fileType) {
        this.commHttpRequest = request;
        this.response = response;
        this.commPageContext = pageContext;
        this.fileType = fileType;
        this.initLogger("ConvertServer");
        this.logger = commLog;
    }

    public void setConverter(Object converObject, String options) {
        JSONObject jsoninfo = this.jsonString(options);
        if (this.setInfoData(jsoninfo, null)) {
            this.converObject = converObject;
        }
    }

    public void setAiControl() {
        this.initService();
    }

    public void setConvert(String mapKey, Object mapvalue) {
        if (this.objectMap == null) {
            this.objectMap = new HashMap<String, Object>();
        }
        this.objectMap.put(mapKey, mapvalue);
    }

    public void setAiControl(String rptParam, String svType, String attriNm, Map<String, List<String>> fileNp, List<Object> dataSet, boolean delYn) {
        this.initService(rptParam, svType, attriNm, fileNp, dataSet, delYn);
    }

    private String getParameter(String paramNm) {
        if ((paramNm = this.getB(this.commHttpRequest.getParameter(paramNm))).equals("")) {
            paramNm = this.getB(this.commHttpRequest.getAttribute(paramNm));
        }
        return paramNm;
    }

    private void initService(String rptParam, String svType, String attriNm, Map<String, List<String>> fileNp, List<Object> dataSet, boolean delYn) {
        this.logger = commLog != null ? commLog : Logger.getLogger((String)"ConvertServer");
        HashMap<String, Object> xmlObjMap = null;
        List<String> fileNm = null;
        List<String> filePw = null;
        StringBuffer xmlSb = null;
        try {
            this.debugLog(this.logger, "#initService ===> Server Storage Start");
            String[] setNode = new String[]{"<@NODE>", "</@NODE>"};
            String xmlNode = "<@NODE><![CDATA[@DATA]]></@NODE>";
            if (fileNp != null) {
                fileNm = fileNp.get("fileNm");
                filePw = fileNp.get("filePw");
            }
            try {
                try {
                    xmlSb = new StringBuffer();
                    xmlObjMap = new HashMap<String, Object>();
                    int rpt = 0;
                    while (rpt < dataSet.size()) {
                        xmlObjMap.put("DATA", dataSet.get(rpt));
                        xmlSb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        xmlSb.append("<root>");
                        for (Map.Entry mpEntry : xmlObjMap.entrySet()) {
                            xmlSb.append(ConvertServer.getCommRA(setNode[0], "@NODE", attriNm));
                            for (Object dataList : (List)mpEntry.getValue()) {
                                xmlSb.append("<list>");
                                for (Map.Entry dataMapEntry : ((Map)dataList).entrySet()) {
                                    if (dataMapEntry.getValue() instanceof List) {
                                        xmlSb.append(ConvertServer.getCommRA(setNode[0], "@NODE", this.getB(dataMapEntry.getKey())));
                                        for (Object subDataList : (List)dataMapEntry.getValue()) {
                                            xmlSb.append("<subList>");
                                            for (Map.Entry subDataMapEntry : ((Map)subDataList).entrySet()) {
                                                String dataValue = ConvertServer.getCommRA(this.getB(subDataMapEntry.getValue()), "&", "%26");
                                                xmlSb.append(ConvertServer.getCommRA(xmlNode, "@NODE|@DATA", String.valueOf(this.getB(subDataMapEntry.getKey())) + "|" + dataValue));
                                            }
                                            xmlSb.append("</subList>");
                                        }
                                        xmlSb.append(ConvertServer.getCommRA(setNode[1], "@NODE", this.getB(dataMapEntry.getKey())));
                                        continue;
                                    }
                                    String dataValue = ConvertServer.getCommRA(this.getB(dataMapEntry.getValue()), "&", "%26");
                                    xmlSb.append(ConvertServer.getCommRA(xmlNode, "@NODE|@DATA", String.valueOf(this.getB(dataMapEntry.getKey())) + "|" + dataValue));
                                }
                                xmlSb.append("</list>");
                            }
                            xmlSb.append(ConvertServer.getCommRA(setNode[1], "@NODE", attriNm));
                        }
                        xmlSb.append("</root>");
                        String reportParams = "@NAME=@PARAM&reportMode=@TYPE&reportParams=@SAVEserversave:true";
                        reportParams = ConvertServer.getCommRA(reportParams, "@TYPE|@SAVE", String.valueOf(svType.toUpperCase()) + "|" + svType.toLowerCase());
                        reportParams = ConvertServer.getCommRA(reportParams, "@NAME|@PARAM", String.valueOf(attriNm) + "|" + xmlSb.toString());
                        if (!rptParam.equals("")) {
                            reportParams = String.valueOf(reportParams) + "," + rptParam;
                        }
                        if (fileNm != null) {
                            String savename = ",savename:@FILE";
                            String savepath = this.getB(fileNm.get(rpt));
                            ConvertServer.getCommDirCk(ConvertServer.getCommRA(savepath, "!@", ":"), "." + svType, true, delYn);
                            reportParams = String.valueOf(reportParams) + ConvertServer.getCommRA(savename, "@FILE", savepath);
                        }
                        if (filePw != null) {
                            String savepass = ",userPassword:@PASS";
                            if (!this.getB(filePw.get(rpt)).equals("")) {
                                reportParams = String.valueOf(reportParams) + ConvertServer.getCommRA(savepass, "@PASS", this.getB(filePw.get(rpt)));
                            }
                        }
                        this.serverConnection(this.jspUrl, reportParams, false);
                        xmlSb.setLength(0);
                        ++rpt;
                    }
                    this.debugLog(this.logger, "#initService ===> Server Storage Success");
                }
                catch (NullPointerException e) {
                    this.debugLog(this.logger, "#initService ===> Server Storage Failed");
                    this.debugLog(this.logger, "#initService ===> " + e);
                    try {
                        if (xmlObjMap != null) {
                            xmlObjMap.clear();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (xmlSb != null) {
                        xmlSb = null;
                    }
                }
            }
            finally {
                try {
                    if (xmlObjMap != null) {
                        xmlObjMap.clear();
                    }
                }
                catch (NullPointerException nullPointerException) {}
                if (xmlSb != null) {
                    xmlSb = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initService() {
        ArrayList<String> rptUrlList = null;
        String[] urlParam = null;
        StringBuffer createUrl = null;
        List<String> rptParam = null;
        String fileNm = "";
        try {
            this.debugLog(this.logger, "#initService ===> Server Storage Start");
            this.jspUrl = this.getB(this.getParameter("jspURL"));
            this.fileType = this.getB(this.getParameter("Type"));
            fileNm = this.getB(this.getParameter("files"));
            if (!this.jspUrl.equals("")) {
                urlParam = this.jspUrl.split("\\?");
                String[] fileNms = null;
                try {
                    if (!fileNm.equals("")) {
                        fileNms = fileNm.split(",");
                    }
                    int n = 0;
                    while (n < fileNms.length) {
                        ConvertServer.getCommDirCk(ConvertServer.getCommRA(fileNms[n], "!@", ":"), "." + this.fileType.toLowerCase(), true, false);
                        ++n;
                    }
                }
                catch (NullPointerException n) {
                    // empty catch block
                }
                if (urlParam.length > 1) {
                    createUrl = new StringBuffer();
                    rptUrlList = new ArrayList<String>();
                    rptParam = this.arryParams(urlParam[1]);
                    int i = 0;
                    while (i < rptParam.size()) {
                        createUrl.append(rptParam.get(i));
                        if (fileNms != null && i < fileNms.length) {
                            createUrl.append(ConvertServer.getCommRA(",savename:@FILE", "@FILE", fileNms[i]));
                        }
                        rptUrlList.add(String.valueOf(createUrl));
                        createUrl.setLength(0);
                        ++i;
                    }
                    if (rptUrlList != null) {
                        i = 0;
                        while (i < rptUrlList.size()) {
                            if (!this.serverConnection(urlParam[0], (String)rptUrlList.get(i), false)) break;
                            ++i;
                        }
                    }
                }
            }
            this.debugLog(this.logger, "#initService ===> Server Storage Success");
        }
        catch (NullPointerException e) {
            this.debugLog(this.logger, "#initService ===> Server Storage Failed");
            this.debugLog(this.logger, "#initService ===> " + e);
        }
    }

    private List<String> arryParams(String param) {
        ArrayList<String> listParam = null;
        String[] params = param.split("!@");
        int maxLoop = 0;
        int i = 0;
        while (i < params.length) {
            String[] paValue = params[i].split("=");
            int num = paValue[1].split(",").length;
            if (num > maxLoop) {
                maxLoop = num;
            }
            ++i;
        }
        StringBuffer value = new StringBuffer();
        int i2 = 0;
        while (i2 < maxLoop) {
            int j = 0;
            while (j < params.length) {
                String[] paValue = params[j].split("=");
                value.append(paValue[0]).append("=");
                String[] data = paValue[1].split(",");
                if (data.length == maxLoop) {
                    value.append(data[i2]);
                } else {
                    value.append(paValue[1]);
                }
                ++j;
            }
            value.append("&").append("|");
            ++i2;
        }
        if (value != null) {
            listParam = new ArrayList<String>();
            String[] valuePa = value.toString().split("\\|");
            int i3 = 0;
            while (i3 < valuePa.length) {
                String rptOption = "reportMode=@TYPE&reportParams=@SAVEserversave:true";
                rptOption = ConvertServer.getCommRA(rptOption, "@TYPE|@SAVE", String.valueOf(this.fileType.toUpperCase()) + "|" + this.fileType.toLowerCase());
                listParam.add(String.valueOf(valuePa[i3]) + rptOption);
                ++i3;
            }
        }
        return listParam;
    }

    private boolean serverConnection(String reportUrl, String reportParam, boolean dataSave) {
        boolean connCheck = false;
        HttpURLConnection httpUrlConn = null;
        InputStreamReader inputReader = null;
        BufferedReader buffReader = null;
        try {
            try {
                int resultCode;
                String string = this.methodType = this.methodType == null ? "GET" : this.methodType;
                if (this.methodType.equals("GET")) {
                    reportUrl = String.valueOf(reportUrl) + "?" + reportParam;
                }
                httpUrlConn = (HttpURLConnection)new URL(reportUrl).openConnection();
                httpUrlConn.setRequestMethod(this.methodType);
                httpUrlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                httpUrlConn.setUseCaches(false);
                httpUrlConn.setDoOutput(true);
                httpUrlConn.setDoInput(true);
                String sessionStr = this.getControlCookie(this.commHttpRequest);
                if (!sessionStr.trim().equals("")) {
                    httpUrlConn.setRequestProperty("Cookie", sessionStr);
                }
                if (this.methodType.equals("POST")) {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpUrlConn.getOutputStream()));
                    printWriter.write(reportParam);
                    printWriter.flush();
                }
                if ((resultCode = httpUrlConn.getResponseCode()) != 200) {
                    this.exception = true;
                    this.debugLog(this.logger, "Report Server responded with code[" + resultCode + "]");
                    throw new IOException("Report Server responded with code[" + resultCode + "]");
                }
                inputReader = new InputStreamReader(httpUrlConn.getInputStream(), "UTF-8");
                buffReader = new BufferedReader(inputReader);
                String httpStr = "";
                try {
                    boolean targetCk = false;
                    while ((httpStr = buffReader.readLine()) != null) {
                        if (httpStr.indexOf("targetURL") == -1) continue;
                        targetCk = true;
                        break;
                    }
                    if (dataSave && targetCk && !httpStr.trim().equals("")) {
                        this.setFilePathType(httpStr);
                    }
                    if (httpStr.indexOf("Exception") != -1) {
                        throw new IOException();
                    }
                    if (buffReader != null) {
                        buffReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                connCheck = true;
            }
            catch (IOException e) {
                this.debugLog(this.logger, "#serverConnection ===> " + e);
                try {
                    if (buffReader != null) {
                        buffReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (httpUrlConn != null) {
                        httpUrlConn.disconnect();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (httpUrlConn != null) {
                    httpUrlConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return connCheck;
    }

    private List<String> aiServerService() {
        String rptUrl = "";
        String[] rptPa = null;
        StringBuffer defUrl = null;
        try {
            this.paramMap = new HashMap<String, String>();
            Enumeration param = this.commHttpRequest.getParameterNames();
            ConvertCode code = new ConvertCode();
            while (param.hasMoreElements()) {
                String paramKey = (String)param.nextElement();
                String[] stringArray = this.commHttpRequest.getParameterValues(paramKey);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String paramValue = stringArray[n2];
                    if (paramKey.equals("rptNm")) {
                        paramValue = code.getUniEncode(paramValue, "z");
                    }
                    this.paramMap.put(paramKey, paramValue);
                    ++n2;
                }
            }
            if (this.paramMap != null) {
                rptUrl = this.getUrlRequest(this.getB(this.paramMap.get("rptUrl")));
                rptPa = this.getB(this.paramMap.get("rptPa")).split(",");
                String reportparam = "";
                int i = 0;
                while (i < rptPa.length) {
                    String[] pavalue = rptPa[i].split(":");
                    reportparam = String.valueOf(reportparam) + pavalue[0] + "=" + pavalue[1] + "&";
                    ++i;
                }
                defUrl = new StringBuffer();
                defUrl.append("reportMode=").append(this.fileType);
                defUrl.append("&").append(reportparam);
                defUrl.append("reportParams=").append(this.fileType.toLowerCase()).append("serversave:true");
                String rptdir = this.getB(this.paramMap.get("rptDir"));
                String rptnm = this.getB(this.paramMap.get("rptNm"));
                if (rptdir.equals("DATE")) {
                    rptdir = this.getCommDT("yyyyMMddHHmmss");
                }
                rptnm.equals("");
                defUrl.append("&fileNm=" + rptnm).append("&fileDir=" + this.getB(commProperties.getProperty("pdfPath")) + rptdir);
                this.debugLog(this.logger, "#Parameter : " + defUrl.toString());
                this.fileList = new ArrayList<String>();
                if (!this.serverConnection(rptUrl, defUrl.toString(), true)) {
                    throw new IOException("URLConnection Error");
                }
            }
        }
        catch (Exception e) {
            this.debugLog(this.logger, "#aiServerService() ===> " + e);
            e.printStackTrace();
        }
        return this.fileList;
    }

    private String getUrlRequest(String rptPath) {
        StringBuffer serverUrl = new StringBuffer();
        String protocol = this.commHttpRequest.getRequestURL().toString();
        serverUrl.append(protocol.indexOf("http://") != -1 ? "http://" : "https://");
        if (this.commHttpRequest.getServerName().indexOf("localhost") != -1) {
            serverUrl.append(this.commHttpRequest.getServerName()).append(":").append(this.commHttpRequest.getServerPort());
        } else {
            serverUrl.append(this.commHttpRequest.getLocalName()).append(":").append(this.commHttpRequest.getLocalPort());
        }
        serverUrl.append("/").append(rptPath);
        this.debugLog(this.logger, "#getUrlRequest : " + serverUrl.toString());
        return serverUrl.toString();
    }

    private boolean setFilePathType(String jsonData) {
        try {
            String returnType;
            String string = returnType = this.retrunType == null ? "STRING" : this.retrunType;
            if (returnType.equals("STRING")) {
                Object object = JSONValue.parse((String)jsonData);
                JSONArray jsonArray = (JSONArray)object;
                if (jsonArray.size() != 0) {
                    JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                    this.fileList.add(jsonObj.get((Object)"targetURL").toString());
                }
            } else if (returnType.equals("JSON")) {
                this.fileList.add(jsonData);
            }
        }
        catch (ClassCastException e) {
            this.debugLog(this.logger, "setFilePathType : No Json Type");
        }
        return true;
    }

    private boolean aiCompressionService() throws Exception {
        boolean runFlag = true;
        String crtDirectory = "";
        String zipFolderNm = "";
        if (this.aiServerService() != null && this.crtDirectory != null && this.crtFolderNm != null) {
            crtDirectory = this.crtDirectory;
            zipFolderNm = String.valueOf(this.crtFolderNm) + ".zip";
            if (this.crtFolderNm.equals("")) {
                throw new Exception("\uc555\ucd95 \ub300\uc0c1\uc758 \ub514\ub809\ud1a0\ub9ac \uc815\uc758\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.");
            }
            File zipDirectroy = new File(crtDirectory);
            if (!zipDirectroy.isFile() && !zipDirectroy.isDirectory()) {
                throw new Exception("\uc555\ucd95 \ub300\uc0c1\uc758 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            FileOutputStream fileOutStream = null;
            FilterOutputStream buffOutStream = null;
            ZipOutputStream zipOutStream = null;
            try {
                try {
                    fileOutStream = new FileOutputStream(String.valueOf(crtDirectory) + ".zip");
                    buffOutStream = new BufferedOutputStream(fileOutStream);
                    zipOutStream = new ZipOutputStream(buffOutStream);
                    zipOutStream.setLevel(8);
                    this.zipEntry(zipDirectroy, crtDirectory, zipOutStream);
                    zipOutStream.finish();
                    try {
                        File zipFile = new File(crtDirectory);
                        if (zipFile.exists()) {
                            File[] files;
                            File[] fileArray = files = zipFile.listFiles();
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                file.delete();
                                ++n2;
                            }
                            if (zipFile.delete()) {
                                this.debugLog(this.logger, "#aiCompressionService : directory delete success");
                            } else {
                                this.debugLog(this.logger, "#aiCompressionService : directory delete failure");
                            }
                        }
                    }
                    catch (Exception e) {
                        runFlag = false;
                        this.debugLog(this.logger, "#aiCompressionService : directory delete failure");
                    }
                }
                catch (Exception e) {
                    runFlag = false;
                    this.debugLog(this.logger, "#aiCompressionService ===> " + e);
                    try {
                        if (zipOutStream != null) {
                            zipOutStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (buffOutStream != null) {
                            buffOutStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (fileOutStream != null) {
                            fileOutStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.crtDirectory = String.valueOf(crtDirectory) + ".zip";
                    this.crtFolderNm = zipFolderNm;
                    if (this.response != null) {
                        this.setZipDownload(this.crtDirectory, this.crtFolderNm);
                    }
                }
            }
            finally {
                try {
                    if (zipOutStream != null) {
                        zipOutStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (buffOutStream != null) {
                        buffOutStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutStream != null) {
                        fileOutStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.crtDirectory = String.valueOf(crtDirectory) + ".zip";
                this.crtFolderNm = zipFolderNm;
                if (this.response != null) {
                    this.setZipDownload(this.crtDirectory, this.crtFolderNm);
                }
            }
        }
        return runFlag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipEntry(File sourceFile, String sourcePath, ZipOutputStream zipOutStream) throws Exception {
        if (sourceFile.isDirectory()) {
            if (sourceFile.getName().equalsIgnoreCase(".metadata")) {
                return;
            }
            File[] fileArray = sourceFile.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                this.zipEntry(fileArray[i], sourcePath, zipOutStream);
                ++i;
            }
            return;
        } else {
            BufferedInputStream buffInpStream = null;
            try {
                try {
                    String sFilePath = sourceFile.getPath();
                    String zipEntryName = sFilePath.substring(sourcePath.length() + 1, sFilePath.length());
                    buffInpStream = new BufferedInputStream(new FileInputStream(sourceFile));
                    ZipEntry zentry = new ZipEntry(zipEntryName);
                    zentry.setTime(sourceFile.lastModified());
                    zipOutStream.putNextEntry(zentry);
                    byte[] buffer = new byte[2048];
                    int cnt = 0;
                    while ((cnt = buffInpStream.read(buffer, 0, 2048)) != -1) {
                        zipOutStream.write(buffer, 0, cnt);
                    }
                    zipOutStream.closeEntry();
                    return;
                }
                catch (Exception e) {
                    this.debugLog(this.logger, "#zipEntry ===> " + e);
                    if (buffInpStream == null) return;
                    buffInpStream.close();
                }
                return;
            }
            finally {
                if (buffInpStream != null) {
                    buffInpStream.close();
                }
            }
        }
    }

    private void setZipDownload(String zipPath, String zipNm) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File zipFile = null;
        String client = "";
        try {
            try {
                zipFile = new File(zipPath);
                inputStream = new FileInputStream(zipFile);
                client = this.commHttpRequest.getHeader("User-Agent");
                this.response.reset();
                this.response.setContentType("application/octet-stream");
                this.response.setHeader("Content-Description", "JSP Generated Data");
                if (client.indexOf("MSIE") != -1) {
                    this.response.setHeader("Content-Disposition", "attachment; filename=" + new String(zipNm.getBytes("KSC5601"), "ISO8859_1"));
                } else {
                    zipNm = new String(zipNm.getBytes("utf-8"), "iso-8859-1");
                    this.response.setHeader("Content-Disposition", "attachment; filename=\"" + zipNm + "\"");
                    this.response.setHeader("Content-Type", "application/octet-stream; charset=utf-8");
                }
                this.response.setHeader("Content-Length", "" + zipFile.length());
                outputStream = this.response.getOutputStream();
                byte[] byteData = new byte[(int)zipFile.length()];
                int leng = 0;
                while ((leng = inputStream.read(byteData)) > 0) {
                    outputStream.write(byteData, 0, leng);
                }
            }
            catch (Exception e) {
                this.debugLog(this.logger, "#setZipDownload ===> " + e);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.getControlFileDel(this.logger, zipPath);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.getControlFileDel(this.logger, zipPath);
        }
    }

    public String getMessage(String success, String failure, boolean popYn) {
        StringBuffer tag = new StringBuffer();
        if (popYn) {
            tag.append("<script type=\"text/javascript\"> function cellBack() { ");
            tag.append("alert('");
            tag.append(this.exception ? failure : success);
            tag.append("');");
            tag.append(" } </script>\n");
            tag.append("<script type=\"text/javascript\"> $(document).ready(cellBack()); </script>\n");
        } else {
            tag.append("");
        }
        return tag.toString();
    }

    private void getHttpRequest() {
        String paramValue;
        String paramKey;
        if (this.commHttpRequest == null) {
            return;
        }
        if (this.convertParamMap == null) {
            this.convertParamMap = new HashMap<String, String>();
        }
        Enumeration param = this.commHttpRequest.getParameterNames();
        while (param.hasMoreElements()) {
            paramKey = (String)param.nextElement();
            paramValue = "";
            if (this.convertConfigMap != null) {
                paramValue = this.getB(this.convertConfigMap.get("E")).equals("UTF-8") ? this.getCommUTF(this.commHttpRequest.getParameter(paramKey)) : this.getCommEUC(this.commHttpRequest.getParameter(paramKey));
            }
            if (this.getParamFilter(paramKey)) {
                this.addParamData(paramKey, paramValue);
                continue;
            }
            if (!paramKey.equals("udsParams") && !paramKey.equals("tableInfo")) continue;
            this.convertConfigMap.put(paramKey, paramValue);
        }
        param = this.commHttpRequest.getAttributeNames();
        while (param.hasMoreElements()) {
            paramKey = (String)param.nextElement();
            paramValue = this.getB(this.commHttpRequest.getAttribute(paramKey));
            if (this.getAttributeFilter(paramKey)) {
                this.addParamData(paramKey, paramValue);
                continue;
            }
            if (!paramKey.equals("udsParams") && !paramKey.equals("tableInfo")) continue;
            this.convertConfigMap.put(paramKey, paramValue);
        }
    }

    private void addParamData(String key, String value) {
        if (this.convertParamMap.get(key = this.getParamDataFilter(key)) == null || this.convertParamMap.get(key).equals("")) {
            this.convertParamMap.put(key, value);
        }
    }

    private String getParamDataFilter(String key) {
        ArrayList<String> filterParam = new ArrayList<String>();
        filterParam.add("%5B");
        filterParam.add("%5D");
        filterParam.add("%3C");
        filterParam.add("%3E");
        filterParam.add("%28");
        filterParam.add("%29");
        for (String str : filterParam) {
            if (key.indexOf(str) == -1) continue;
            key = ConvertServer.getCommRA(key, str, "");
        }
        return key;
    }

    private boolean getHtmlDataFilter(String data) {
        if (data.indexOf("<script") != -1 && data.indexOf("js\"") != -1) {
            return true;
        }
        if (data.indexOf("<link") != -1 && data.indexOf("css\"") != -1) {
            return true;
        }
        if (data.indexOf("<!--") != -1 || data.indexOf("-->") != -1 || data.equals("{") || data.equals("}")) {
            return true;
        }
        return data.indexOf("@page") != -1 || data.indexOf("</style>") != -1;
    }

    private boolean getParamFilter(String key) {
        HashMap<String, String> filterParam = new HashMap<String, String>();
        filterParam.put("reportMode", "");
        filterParam.put("reportParams", "");
        filterParam.put("clientURIEncoding", "");
        filterParam.put("udsParams", "");
        filterParam.put("tableInfo", "");
        return filterParam.get(key) == null;
    }

    private boolean getAttributeFilter(String key) {
        HashMap<String, String> filterParam = new HashMap<String, String>();
        filterParam.put("javax.", "");
        filterParam.put("org.", "");
        filterParam.put("__spring", "");
        for (String filterDb : filterParam.keySet()) {
            if (key.indexOf(filterDb) == -1) continue;
            return false;
        }
        return true;
    }

    private String commHttpdefUrl() {
        String httpUrl = "";
        if (this.convertConfigMap != null) {
            httpUrl = this.getB(this.convertConfigMap.get("HP")).replaceAll("##", ":");
            if (this.convertConfigMap.get("M") == null || this.convertConfigMap.get("M").equals("")) {
                this.convertConfigMap.put("M", "GET");
            }
            if (this.convertConfigMap.get("C") == null || this.convertConfigMap.get("C").equals("")) {
                this.convertConfigMap.put("C", "UTF-8");
            }
        }
        if (httpUrl.indexOf("http://") != -1 || httpUrl.indexOf("https://") != -1 || this.commHttpRequest == null) {
            return httpUrl;
        }
        StringBuffer serverUrl = new StringBuffer();
        String protocol = this.commHttpRequest.getRequestURL().toString();
        if (commProperties != null && this.getB(commProperties.get("convertServer")).equals("true")) {
            if (!this.getB(commProperties.get("convertServerPt")).equals("")) {
                String convertLocalNm = this.commHttpRequest.getLocalName();
                String convertLocalAddr = this.commHttpRequest.getLocalAddr();
                String[] convertServerPt = this.getB(commProperties.get("convertServerPt")).split(",");
                String[] convertServerUrl = this.getB(commProperties.get("convertServerUrl")).split(",");
                serverUrl.append(protocol.indexOf("http://") != -1 ? "http://" : "https://");
                int i = 0;
                while (i < convertServerPt.length) {
                    if (convertLocalNm.indexOf(convertServerPt[i]) != -1) {
                        serverUrl.append(convertServerUrl[i]);
                        break;
                    }
                    if (convertLocalAddr.indexOf(convertServerPt[i]) != -1) {
                        serverUrl.append(convertServerUrl[i]);
                        break;
                    }
                    ++i;
                }
                if (serverUrl.length() < 9) {
                    serverUrl.append(this.commHttpRequest.getLocalName()).append(":").append(this.commHttpRequest.getLocalPort());
                }
            }
        } else if (commProperties != null && !this.getB(commProperties.get("convertServerUrl")).equals("")) {
            String convertServerUrl = this.getB(commProperties.get("convertServerUrl"));
            if (convertServerUrl.indexOf("http://") == -1 && convertServerUrl.indexOf("https://") == -1) {
                serverUrl.append(protocol.indexOf("http://") != -1 ? "http://" : "https://");
            }
            serverUrl.append(convertServerUrl);
        } else {
            serverUrl.append(protocol.indexOf("http://") != -1 ? "http://" : "https://");
            if (this.commHttpRequest.getServerName().indexOf("localhost") != -1) {
                serverUrl.append(this.commHttpRequest.getServerName()).append(":").append(this.commHttpRequest.getServerPort());
            } else {
                serverUrl.append(this.commHttpRequest.getLocalName()).append(":").append(this.commHttpRequest.getLocalPort());
            }
        }
        serverUrl.append(this.commHttpRequest.getContextPath());
        serverUrl.append(httpUrl);
        return serverUrl.toString();
    }

    private String commHttpParameter() {
        this.getHttpRequest();
        StringBuffer parameter = new StringBuffer("");
        String parametertree = "";
        if (this.convertParamMap != null) {
            if (this.convertConfigMap != null && this.getB(this.convertConfigMap.get("P")).equals("OBJ")) {
                parametertree = this.getB(this.convertConfigMap.get(this.getB(this.convertConfigMap.get("UP"))));
            } else {
                parametertree = "@DATA";
                String parameterfrom = "@KEY=@VALUE&";
                if (this.getB(this.convertConfigMap.get("P")).equals("M")) {
                    parametertree = "<map>@DATA</map>";
                    parameterfrom = "<@KEY>@VALUE</@KEY>";
                }
                Set<String> paramList = this.convertParamMap.keySet();
                for (String param : paramList) {
                    if (param.equals("XML") || param.equals("JSON") || param.equals("tableInfo")) continue;
                    parameter.append(ConvertServer.getCommRA(parameterfrom, "@KEY|@VALUE", String.valueOf(param) + "|" + this.getB(this.convertParamMap.get(param))));
                }
                parametertree = ConvertServer.getCommRA(parametertree, "@DATA", parameter.toString());
            }
        }
        return parametertree;
    }

    public String getFolderGet() {
        this.aiServerService();
        return this.crtDirectory;
    }

    public String getFolderPost() {
        this.methodType = "POST";
        this.aiServerService();
        return this.crtDirectory;
    }

    public List<String> getListStrGet() {
        return this.aiServerService();
    }

    public List<String> getListStrPost() {
        this.methodType = "POST";
        return this.aiServerService();
    }

    public List<String> getListJsonGet() {
        this.retrunType = "JSON";
        return this.aiServerService();
    }

    public List<String> getListJsonPost() {
        this.retrunType = "JSON";
        this.methodType = "POST";
        return this.aiServerService();
    }

    public boolean initZipGet() throws Exception {
        return this.aiCompressionService();
    }

    public boolean initZipPost() throws Exception {
        this.methodType = "POST";
        return this.aiCompressionService();
    }

    public String getZipFilePath() {
        return this.crtDirectory;
    }

    public String getZipFileNm() {
        return this.crtFolderNm;
    }

    public String getHtmlTag() {
        return this.convertHtmlTag();
    }

    public List<String> getFilePaths() {
        return this.convertFilePaths;
    }
}

