/*
 * Decompiled with CFR 0.152.
 */
package com.solbitech.common.util;

import ai.org.apache.commons.codec.binary.Base64;
import com.solbitech.common.sys.CommControl;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertCode
extends CommControl {
    protected Map<String, String> paramMap;
    protected String extension;
    private final String paramNm = "fileNm";
    private Key convertSecurityKey;
    private String securityKey = "";

    public void setConvertCode() throws UnsupportedEncodingException {
        String key = "vip125_security_";
        this.securityKey = key.substring(0, 16);
        byte[] keyBytes = new byte[16];
        byte[] b = key.getBytes("UTF-8");
        int len = b.length;
        if (len > keyBytes.length) {
            len = keyBytes.length;
        }
        System.arraycopy(b, 0, keyBytes, 0, len);
        SecretKeySpec convertSecurityKey = new SecretKeySpec(keyBytes, "AES");
        this.convertSecurityKey = convertSecurityKey;
    }

    public Map<String, Object> setSecuredKey() {
        HashMap<String, Object> securedKeyGenerator = new HashMap<String, Object>();
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(512);
            KeyPair keyPair = generator.genKeyPair();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            RSAPublicKeySpec publicSpec = keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
            securedKeyGenerator.put("privateKey", privateKey);
            securedKeyGenerator.put("publicKeyModulus", publicSpec.getModulus().toString(16));
            securedKeyGenerator.put("publicKeyExponent", publicSpec.getPublicExponent().toString(16));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return securedKeyGenerator;
    }

    public Map<String, String> getSecuredKey(Object rsaPrivateKey, String securedKey, String securedCode) {
        PrivateKey privateKey;
        HashMap<String, String> securedKeyGenerator;
        block3: {
            securedKeyGenerator = new HashMap<String, String>();
            privateKey = (PrivateKey)rsaPrivateKey;
            if (privateKey != null) break block3;
            return null;
        }
        try {
            securedKeyGenerator.put("managerId", this.decryptRsa(privateKey, securedKey));
            securedKeyGenerator.put("managerPw", this.decryptRsa(privateKey, securedCode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return securedKeyGenerator;
    }

    public Map<String, String> getSecuredKey(Object rsaPrivateKey, Map<String, String> webInfoParamMap, String[] securedArr) {
        PrivateKey privateKey;
        HashMap<String, String> securedKeyGenerator;
        block4: {
            securedKeyGenerator = new HashMap<String, String>();
            privateKey = (PrivateKey)rsaPrivateKey;
            if (privateKey != null) break block4;
            return null;
        }
        try {
            String[] stringArray = securedArr;
            int n = securedArr.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                securedKeyGenerator.put(key, this.decryptRsa(privateKey, this.getB(webInfoParamMap.get(key))));
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return securedKeyGenerator;
    }

    public String getUniEncode(String paramValue, String type) {
        return this.enCodeEngine(paramValue, type);
    }

    public String getEncoder(String str) throws NoSuchAlgorithmException, GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, this.convertSecurityKey, new IvParameterSpec(this.securityKey.getBytes()));
        byte[] encrypted = cipher.doFinal(str.getBytes("UTF-8"));
        String enStr = new String(Base64.encodeBase64((byte[])encrypted));
        return enStr;
    }

    protected void getUniDecode() {
        String paramValue = "";
        if (this.paramMap == null && (paramValue = this.getB(this.commHttpRequest.getParameter("fileNm"))).equals("")) {
            paramValue = this.getB(this.commHttpRequest.getAttribute("fileNm"));
        }
        this.uniDecode(paramValue);
    }

    public String getDecoder(String str) throws NoSuchAlgorithmException, GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, this.convertSecurityKey, new IvParameterSpec(this.securityKey.getBytes()));
        byte[] byteStr = Base64.decodeBase64((byte[])str.getBytes());
        return new String(cipher.doFinal(byteStr), "UTF-8");
    }

    private String enCodeEngine(String paramValue, String type) {
        StringBuffer encode = null;
        try {
            if (!paramValue.equals("")) {
                if (type.equals("")) {
                    type = "-";
                }
                encode = new StringBuffer();
                int j = 0;
                while (j < paramValue.length()) {
                    encode.append(String.valueOf((int)paramValue.charAt(j)) + type);
                    ++j;
                }
                paramValue = encode.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paramValue;
    }

    private void uniDecode(String paramValue) {
        try {
            if (paramValue.equals("")) {
                if (this.paramMap != null) {
                    Set<String> setKey = this.paramMap.keySet();
                    for (String mapKey : setKey) {
                        String mapValue = this.getB(this.paramMap.get(mapKey));
                        mapValue = this.deCodeEngine(mapValue);
                        this.paramMap.put(mapKey, mapValue);
                    }
                }
            } else {
                paramValue = this.deCodeEngine(paramValue);
                if (!this.extension.equals("")) {
                    paramValue = String.valueOf(paramValue) + "." + this.extension;
                }
                this.paramMap.put("fileNm", paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String uniDecoder(String paramValue) {
        return this.deCodeEngine(paramValue);
    }

    private String deCodeEngine(String mapValue) {
        String valueType = "";
        if (mapValue.replaceAll("\\d{1,5}-", "").equals("")) {
            valueType = "-";
        } else if (mapValue.replaceAll("\\d{1,5}z", "").equals("")) {
            valueType = "z";
        } else if (mapValue.replaceAll("\\d{1,5}:", "").equals("")) {
            valueType = ":";
        }
        if (!valueType.equals("")) {
            StringBuffer decode = new StringBuffer();
            String[] strDecode = mapValue.split(valueType);
            int i = 0;
            while (i < strDecode.length) {
                String value = strDecode[i];
                if (value.equals("")) {
                    value = "0";
                }
                try {
                    decode.append((char)Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    decode.append(value);
                }
                ++i;
            }
            mapValue = decode.toString();
        }
        return mapValue;
    }

    private String decryptRsa(PrivateKey privateKey, String securedValue) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        byte[] encryptedBytes = ConvertCode.hexToByteArray(securedValue);
        cipher.init(2, privateKey);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        String decryptedValue = new String(decryptedBytes, "utf-8");
        return decryptedValue;
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null || hex.length() % 2 != 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[hex.length() / 2];
        int i = 0;
        while (i < hex.length()) {
            byte value;
            bytes[(int)Math.floor((double)((double)(i / 2)))] = value = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
            i += 2;
        }
        return bytes;
    }
}

