/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Line
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2185952238314399110L;
    private static final int DIMENSION = 2;
    private double slope;
    private double y0;
    private double x0;

    public Line() {
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        this.slope = Double.NaN;
    }

    public Line(double d, double d2) {
        this.slope = d;
        this.y0 = d2;
        this.x0 = -d2 / d;
    }

    public final double slope() {
        return this.slope;
    }

    public final double x0() {
        return this.x0;
    }

    public final double x(double d) {
        return this.x0 + d / this.slope;
    }

    public final double y0() {
        return this.y0;
    }

    public final double y(double d) {
        return this.y0 + d * this.slope;
    }

    public void translate(double d, double d2) {
        if (this.slope == 0.0 || Double.isInfinite(this.slope)) {
            this.x0 += d;
            this.y0 += d2;
        } else {
            this.x0 += d - d2 / this.slope;
            this.y0 += d2 - this.slope * d;
        }
    }

    public void setEquation(double d, double d2) {
        this.slope = d;
        this.y0 = d2;
        this.x0 = -d2 / d;
    }

    public void setFromPoints(double d, double d2, double d3, double d4) {
        this.slope = (d4 - d2) / (d3 - d);
        this.x0 = d3 - d4 / this.slope;
        this.y0 = d4 - this.slope * d3;
        if (Double.isNaN(this.x0) && this.slope == 0.0) {
            this.x0 = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(this.y0) && Double.isInfinite(this.slope)) {
            this.y0 = Double.POSITIVE_INFINITY;
        }
    }

    public double fit(double[] dArray, double[] dArray2) {
        return this.doFit(new CompoundDirectPositions(dArray, dArray2));
    }

    public double fit(Iterable<? extends DirectPosition> iterable) {
        return this.doFit(iterable);
    }

    private double doFit(Iterable<? extends DirectPosition> iterable) {
        int n = 0;
        int n2 = 0;
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        for (DirectPosition object2 : iterable) {
            double doubleDouble5;
            int doubleDouble4 = object2.getDimension();
            if (doubleDouble4 != 2) {
                throw new MismatchedDimensionException(Errors.format((short)59, "points[" + n + ']', 2, doubleDouble4));
            }
            ++n;
            double d = object2.getOrdinate(1);
            if (Double.isNaN(d) || Double.isNaN(doubleDouble5 = object2.getOrdinate(0))) continue;
            doubleDouble.add(doubleDouble5);
            doubleDouble2.add(d);
            ++n2;
        }
        doubleDouble.divide(n2, 0.0);
        doubleDouble2.divide(n2, 0.0);
        DoubleDouble doubleDouble3 = new DoubleDouble();
        DoubleDouble doubleDouble4 = new DoubleDouble();
        DoubleDouble doubleDouble5 = new DoubleDouble();
        DoubleDouble doubleDouble6 = new DoubleDouble();
        DoubleDouble doubleDouble7 = new DoubleDouble();
        for (DirectPosition directPosition : iterable) {
            double d = directPosition.getOrdinate(1);
            if (Double.isNaN(d) || Double.isNaN(doubleDouble3.value = directPosition.getOrdinate(0))) continue;
            doubleDouble3.error = 0.0;
            doubleDouble3.subtract(doubleDouble);
            doubleDouble4.setFrom(doubleDouble3);
            doubleDouble4.multiply(doubleDouble3);
            doubleDouble5.add(doubleDouble4);
            doubleDouble3.multiply(d);
            doubleDouble7.add(doubleDouble3);
            doubleDouble3.setToProduct(d, d);
            doubleDouble6.add(doubleDouble3);
        }
        doubleDouble5.divide(n2, 0.0);
        doubleDouble6.divide(n2, 0.0);
        doubleDouble7.divide(n2, 0.0);
        doubleDouble3.setFrom(doubleDouble7);
        doubleDouble3.divide(doubleDouble5);
        doubleDouble4.setFrom(doubleDouble);
        doubleDouble4.multiply(doubleDouble3);
        doubleDouble4.negate();
        doubleDouble4.add(doubleDouble2);
        this.setEquation(doubleDouble3.value, doubleDouble4.value);
        doubleDouble3.setFrom(doubleDouble2);
        doubleDouble3.multiply(doubleDouble2);
        doubleDouble3.negate();
        doubleDouble3.add(doubleDouble6);
        doubleDouble3.multiply(doubleDouble5);
        doubleDouble3.sqrt();
        doubleDouble3.inverseDivide(doubleDouble7);
        return doubleDouble3.value;
    }

    public Line clone() {
        try {
            return (Line)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Line line = (Line)object;
            return Numerics.equals(this.slope, line.slope) && Numerics.equals(this.y0, line.y0) && Numerics.equals(this.x0, line.x0);
        }
        return false;
    }

    public int hashCode() {
        return Numerics.hashCode(0x1E560FFAA4B32586L ^ Double.doubleToLongBits(this.slope) + 31L * Double.doubleToLongBits(this.y0));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        if (Double.isInfinite(this.slope)) {
            stringBuilder.append("x = ").append(this.x0);
        } else {
            stringBuilder.append("y = ");
            String string = "";
            if (this.slope != 0.0) {
                stringBuilder.append(this.slope).append("\u22c5x");
                string = " + ";
            }
            if (this.y0 != 0.0) {
                stringBuilder.append(string).append(this.y0);
            }
        }
        return stringBuilder.toString();
    }
}

