/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Date;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.geoapi.temporal.TemporalFactory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class TemporalUtilities
extends Static {
    private TemporalUtilities() {
    }

    public static TemporalFactory getTemporalFactory() throws UnsupportedOperationException {
        TemporalFactory temporalFactory = DefaultFactories.forClass(TemporalFactory.class);
        if (temporalFactory != null) {
            return temporalFactory;
        }
        throw new UnsupportedOperationException(Errors.format((short)61, "sis-temporal"));
    }

    private static Instant createInstant(TemporalFactory temporalFactory, Date date) {
        return temporalFactory.createInstant(date);
    }

    public static Instant createInstant(Date date) throws UnsupportedOperationException {
        return TemporalUtilities.createInstant(TemporalUtilities.getTemporalFactory(), date);
    }

    public static Period createPeriod(Date date, Date date2) throws UnsupportedOperationException {
        TemporalFactory temporalFactory = TemporalUtilities.getTemporalFactory();
        return temporalFactory.createPeriod(TemporalUtilities.createInstant(temporalFactory, date), TemporalUtilities.createInstant(temporalFactory, date2));
    }
}

