/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;

public final class Numerics
extends Static {
    private static final Map<Object, Object> CACHE = new HashMap<Object, Object>(32);
    public static final double COMPARISON_THRESHOLD = 1.0E-14;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final int SIGNIFICAND_SIZE = 52;
    public static final int SIGNIFICAND_SIZE_OF_FLOAT = 23;

    private static void cache(double d) {
        Double d2 = d;
        CACHE.put(d2, d2);
        d2 = -d;
        CACHE.put(d2, d2);
    }

    private Numerics() {
    }

    public static <T> T cached(T t) {
        Object object = CACHE.get(t);
        return (T)(object != null ? object : t);
    }

    public static Double valueOf(double d) {
        Double d2 = d;
        Object object = CACHE.get(d);
        return object != null ? (Double)object : d2;
    }

    public static float[] copyAsFloats(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static int[] copyAsInts(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)Math.round(dArray[i]);
        }
        return nArray;
    }

    public static boolean equals(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equalsIgnoreZeroSign(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean epsilonEqual(double d, double d2) {
        double d3 = 1.0E-14 * Math.max(Math.abs(d), Math.abs(d2));
        if (d3 == Double.POSITIVE_INFINITY || Double.isNaN(d3)) {
            return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
        }
        return Math.abs(d - d2) <= d3;
    }

    public static boolean epsilonEqual(double d, double d2, ComparisonMode comparisonMode) {
        switch (comparisonMode) {
            default: {
                return Numerics.equals(d, d2);
            }
            case APPROXIMATIVE: {
                return Numerics.epsilonEqual(d, d2);
            }
            case DEBUG: 
        }
        boolean bl = Numerics.epsilonEqual(d, d2);
        assert (bl) : "v1=" + d + " v2=" + d2 + " \u0394v=" + Math.abs(d - d2);
        return bl;
    }

    public static boolean floatEpsilonEqual(Object object, Object object2) {
        return !(!(object instanceof Float) && !(object instanceof Double) || !(object2 instanceof Float) && !(object2 instanceof Double) || !Numerics.epsilonEqual(((Number)object).doubleValue(), ((Number)object2).doubleValue()));
    }

    public static int hashCode(long l) {
        return (int)l ^ (int)(l >>> 32);
    }

    public static int toExp10(int n) {
        assert (n >= -2620 && n <= 2620) : n;
        return n * 315653 >> 20;
    }

    public static long getSignificand(double d) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        l &= 0xFFFFFFFFFFFFFL;
        l = l2 != 0L ? (l |= 0x10000000000000L) : (l <<= 1);
        return l;
    }

    public static int getSignificand(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = n & 0x7F800000;
        n = (int)((long)n & 0x7FFFFFL);
        n = n2 != 0 ? (int)((long)n | 0x800000L) : (n <<= 1);
        return n;
    }

    static {
        Numerics.cache(0.0);
        Numerics.cache(1.0);
        Numerics.cache(10.0);
        Numerics.cache(60.0);
        Numerics.cache(90.0);
        Numerics.cache(100.0);
        Numerics.cache(180.0);
        Numerics.cache(648000.0);
        Numerics.cache(360.0);
        Numerics.cache(1000.0);
        Numerics.cache(Double.POSITIVE_INFINITY);
        Numerics.cache(Double.NaN);
    }
}

