/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    public static final String EPSG = "EPSG";

    private Citations() {
    }

    public static <E> Iterator<E> iterator(Collection<E> collection) {
        return collection != null && !collection.isEmpty() ? collection.iterator() : null;
    }

    private static String toString(InternationalString internationalString) {
        return internationalString != null ? CharSequences.trimWhitespaces(internationalString.toString(Locale.ROOT)) : null;
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            InternationalString internationalString = citation2.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(Locale.ROOT);
                    if (Citations.titleMatches(citation, string)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (!Objects.equals(string2, string) && Citations.titleMatches(citation, string2)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation2.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean titleMatches(Citation citation, CharSequence charSequence) {
        if (citation != null && charSequence != null) {
            InternationalString internationalString = citation.getTitle();
            Iterator iterator = null;
            while (true) {
                if (internationalString != null) {
                    String string = internationalString.toString(Locale.ROOT);
                    if (CharSequences.equalsFiltered(string, charSequence, Characters.Filter.LETTERS_AND_DIGITS, true)) {
                        return true;
                    }
                    String string2 = internationalString.toString();
                    if (!Objects.equals(string2, string) && CharSequences.equalsFiltered(string2, charSequence, Characters.Filter.LETTERS_AND_DIGITS, true)) {
                        return true;
                    }
                }
                if (iterator == null && (iterator = Citations.iterator(citation.getAlternateTitles())) == null || !iterator.hasNext()) break;
                internationalString = (InternationalString)iterator.next();
            }
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        if (citation != null && citation2 != null) {
            if (citation == citation2) {
                return true;
            }
            Iterator iterator = Citations.iterator(citation2.getIdentifiers());
            if (iterator == null) {
                iterator = Citations.iterator(citation.getIdentifiers());
                if (iterator == null) {
                    return Citations.titleMatches(citation, citation2);
                }
                citation = citation2;
            }
            do {
                Identifier identifier;
                if ((identifier = (Identifier)iterator.next()) == null || !Citations.identifierMatches(citation, identifier, identifier.getCode())) continue;
                return true;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static boolean identifierMatches(Citation citation, Identifier identifier, CharSequence charSequence) {
        if (citation != null && charSequence != null) {
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator == null) {
                return Citations.titleMatches(citation, charSequence);
            }
            while (iterator.hasNext()) {
                String string;
                String string2;
                Identifier identifier2 = (Identifier)iterator.next();
                if (identifier2 == null || !CharSequences.equalsFiltered(charSequence, identifier2.getCode(), Characters.Filter.LETTERS_AND_DIGITS, true)) continue;
                if (identifier instanceof ReferenceIdentifier && (string2 = ((ReferenceIdentifier)identifier).getCodeSpace()) != null && identifier2 instanceof ReferenceIdentifier && (string = ((ReferenceIdentifier)identifier2).getCodeSpace()) != null) {
                    return CharSequences.equalsFiltered(string2, string, Characters.Filter.LETTERS_AND_DIGITS, true);
                }
                return true;
            }
        }
        return false;
    }

    public static String getIdentifier(Citation citation) {
        boolean bl = false;
        String string = null;
        if (citation != null) {
            boolean bl2;
            int n;
            String string2;
            Object object;
            Iterator iterator = Citations.iterator(citation.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (Identifier)iterator.next();
                    if (object == null || (string2 = CharSequences.trimWhitespaces(object.getCode())) == null || (n = string2.length()) == 0 || string != null && n >= string.length() || !(bl2 = CharSequences.isUnicodeIdentifier(string2)) && bl) continue;
                    string = string2;
                    bl = bl2;
                }
            }
            if (string == null) {
                string = Citations.toString(citation.getTitle());
                if (string != null) {
                    if (string.isEmpty()) {
                        string = null;
                    } else {
                        bl = CharSequences.isUnicodeIdentifier(string);
                    }
                }
                if ((object = Citations.iterator(citation.getAlternateTitles())) != null) {
                    while (object.hasNext()) {
                        string2 = Citations.toString((InternationalString)object.next());
                        if (string2 == null || (n = string2.length()) == 0 || string != null && n >= string.length() || !(bl2 = CharSequences.isUnicodeIdentifier(string2)) && bl) continue;
                        string = string2;
                        bl = bl2;
                    }
                }
            }
        }
        return string;
    }
}

