/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

public final class Semaphores {
    public static final byte COMPARING = 1;
    public static final byte PROJCS = 2;
    public static final byte NULL_COLLECTION = 4;
    private static final ThreadLocal<Semaphores> FLAGS = new ThreadLocal();
    private byte flags;

    private Semaphores() {
    }

    public static boolean query(byte by) {
        Semaphores semaphores = FLAGS.get();
        return semaphores != null && (semaphores.flags & by) != 0;
    }

    public static boolean queryAndSet(byte by) {
        Semaphores semaphores = FLAGS.get();
        if (semaphores == null) {
            semaphores = new Semaphores();
            FLAGS.set(semaphores);
        }
        boolean bl = (semaphores.flags & by) != 0;
        semaphores.flags = (byte)(semaphores.flags | by);
        return bl;
    }

    public static void clear(byte by) {
        Semaphores semaphores = FLAGS.get();
        if (semaphores != null) {
            semaphores.flags = (byte)(semaphores.flags & ~by);
        }
    }
}

