/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class SimpleIdentifiedObject
implements IdentifiedObject,
LenientComparable,
Serializable {
    private static final long serialVersionUID = 5297493321524903545L;
    protected ReferenceIdentifier name;

    protected SimpleIdentifiedObject() {
    }

    public SimpleIdentifiedObject(IdentifiedObject identifiedObject) {
        this.name = identifiedObject.getName();
    }

    public SimpleIdentifiedObject(ReferenceIdentifier referenceIdentifier) {
        this.name = referenceIdentifier;
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public final Set<ReferenceIdentifier> getIdentifiers() {
        return Collections.emptySet();
    }

    public final Collection<GenericName> getAlias() {
        return Collections.emptySet();
    }

    public final Extent getDomainOfValidity() {
        return null;
    }

    public final InternationalString getScope() {
        return null;
    }

    public final InternationalString getRemarks() {
        return null;
    }

    public final int hashCode() {
        int n = -847315335;
        ReferenceIdentifier referenceIdentifier = this.getName();
        if (referenceIdentifier != null) {
            n ^= referenceIdentifier.hashCode();
        }
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentifiedObject && (comparisonMode != ComparisonMode.STRICT || object.getClass() == this.getClass())) {
            IdentifiedObject identifiedObject = (IdentifiedObject)object;
            if (comparisonMode.ordinal() >= ComparisonMode.IGNORE_METADATA.ordinal()) {
                return true;
            }
            return Objects.equals(this.getName(), identifiedObject.getName()) && Containers.isNullOrEmpty(identifiedObject.getIdentifiers()) && Containers.isNullOrEmpty(identifiedObject.getAlias()) && identifiedObject.getRemarks() == null;
        }
        return false;
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Citation citation;
        String string;
        String string2;
        ReferenceIdentifier referenceIdentifier = this.name;
        if (referenceIdentifier != null) {
            string2 = referenceIdentifier.getCode();
            string = referenceIdentifier.getCodeSpace();
            citation = referenceIdentifier.getAuthority();
        } else {
            string2 = null;
            string = null;
            citation = null;
        }
        StringBuilder stringBuilder = new StringBuilder("IdentifiedObject[\"");
        if (string != null) {
            stringBuilder.append(string).append(':');
        }
        stringBuilder.append(string2).append('\"');
        if (citation != null) {
            stringBuilder.append(", ID[\"").append(Citations.getIdentifier(citation)).append("\"]");
        }
        return stringBuilder.append(']').toString();
    }
}

