/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.util.Version;

public class ProbeResult
implements Serializable {
    private static final long serialVersionUID = -4977853847503500550L;
    public static final ProbeResult SUPPORTED = new Constant(true, "SUPPORTED");
    public static final ProbeResult UNSUPPORTED_STORAGE = new Constant(false, "UNSUPPORTED_STORAGE");
    public static final ProbeResult INSUFFICIENT_BYTES = new Constant(false, "INSUFFICIENT_BYTES");
    public static final ProbeResult UNDETERMINED = new Constant(false, "UNDETERMINED");
    private final boolean isSupported;
    private final String mimeType;
    private final Version version;

    public ProbeResult(boolean bl, String string, Version version) {
        this.isSupported = bl;
        this.mimeType = string;
        this.version = version;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.isSupported, this.mimeType, this.version}) ^ 0xABBE0AFA;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ProbeResult probeResult = (ProbeResult)object;
            return this.isSupported == probeResult.isSupported && Objects.equals((Object)this.mimeType, (Object)probeResult.mimeType) && Objects.equals((Object)this.version, (Object)probeResult.version);
        }
        return false;
    }

    public String toString() {
        return Utilities.toString(this.getClass(), (Object[])new Object[]{"isSupported", this.isSupported, "mimeType", this.mimeType, "version", this.version});
    }

    private static final class Constant
    extends ProbeResult {
        private static final long serialVersionUID = -5239064423134309133L;
        private final String name;

        Constant(boolean bl, String string) {
            super(bl, null, null);
            this.name = string;
        }

        Object readResolve() {
            try {
                return ProbeResult.class.getField(this.name).get(null);
            }
            catch (Exception exception) {
                return this;
            }
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Constant && this.name.equals(((Constant)object).name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() ^ 0x37B154F3;
        }

        @Override
        public String toString() {
            return "ProbeResult[" + this.name + ']';
        }
    }
}

