/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int n) {
        ArgumentChecks.ensureStrictlyPositive((String)"dimension", (int)n);
        return IdentityTransform.create(n);
    }

    public static LinearTransform linear(double d, double d2) {
        return LinearTransform1D.create(d, d2);
    }

    public static LinearTransform linear(Matrix matrix) {
        CopyTransform copyTransform;
        ArgumentChecks.ensureNonNull((String)"matrix", (Object)matrix);
        int n = matrix.getNumCol() - 1;
        int n2 = matrix.getNumRow() - 1;
        if (n == n2) {
            if (matrix.isIdentity()) {
                return MathTransforms.identity(n);
            }
            if (Matrices.isAffine(matrix)) {
                switch (n) {
                    case 1: {
                        return MathTransforms.linear(matrix.getElement(0, 0), matrix.getElement(0, 1));
                    }
                    case 2: {
                        if (matrix instanceof ExtendedPrecisionMatrix) {
                            return new AffineTransform2D(((ExtendedPrecisionMatrix)matrix).getExtendedElements());
                        }
                        return new AffineTransform2D(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
                    }
                }
            } else if (n == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((copyTransform = CopyTransform.create(matrix)) != null) {
            return copyTransform;
        }
        return new ProjectiveTransform(matrix);
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)mathTransform);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)mathTransform2);
        return ConcatenatedTransform.create(mathTransform, mathTransform2);
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2) throws MismatchedDimensionException {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2);
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2, MathTransform mathTransform3) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)mathTransform);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)mathTransform2);
        ArgumentChecks.ensureNonNull((String)"tr3", (Object)mathTransform3);
        return MathTransforms.concatenate(MathTransforms.concatenate(mathTransform, mathTransform2), mathTransform3);
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2, MathTransform1D mathTransform1D3) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2, (MathTransform)mathTransform1D3);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2, MathTransform2D mathTransform2D3) throws MismatchedDimensionException {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2, (MathTransform)mathTransform2D3);
    }

    public static List<MathTransform> getSteps(MathTransform mathTransform) {
        if (mathTransform != null) {
            if (mathTransform instanceof ConcatenatedTransform) {
                return ((ConcatenatedTransform)mathTransform).getSteps();
            }
            return Collections.singletonList(mathTransform);
        }
        return Collections.emptyList();
    }

    public static Matrix getMatrix(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            return ((LinearTransform)mathTransform).getMatrix();
        }
        if (mathTransform instanceof AffineTransform) {
            return AffineTransforms2D.toMatrix((AffineTransform)mathTransform);
        }
        return null;
    }

    public static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, true);
        }
        Matrix matrix = mathTransform.derivative((DirectPosition)new DirectPositionView(dArray, n, mathTransform.getSourceDimensions()));
        if (dArray2 != null) {
            mathTransform.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }
}

