/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Line;
import org.apache.sis.math.Plane;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class LinearTransformBuilder {
    private double[][] sources;
    private double[][] targets;
    private LinearTransform transform;
    private double[] correlation;

    private static double[][] toArrays(DirectPosition[] directPositionArray, int n) {
        int n2 = directPositionArray.length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            DirectPosition directPosition = directPositionArray[i];
            int n3 = directPosition.getDimension();
            if (n3 != n) {
                throw new MismatchedDimensionException(Errors.format((short)59, (Object)("points[" + i + ']'), (Object)n, (Object)n3));
            }
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = directPosition.getOrdinate(j);
            }
        }
        return dArray;
    }

    public void setSourcePoints(DirectPosition ... directPositionArray) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"points", (Object)directPositionArray);
        this.sources = directPositionArray.length != 0 ? LinearTransformBuilder.toArrays(directPositionArray, directPositionArray[0].getDimension() == 1 ? 1 : 2) : (double[][])null;
        this.transform = null;
        this.correlation = null;
    }

    public void setTargetPoints(DirectPosition ... directPositionArray) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"points", (Object)directPositionArray);
        this.targets = directPositionArray.length != 0 ? LinearTransformBuilder.toArrays(directPositionArray, directPositionArray[0].getDimension()) : (double[][])null;
        this.transform = null;
        this.correlation = null;
    }

    public LinearTransform create() {
        if (this.transform == null) {
            double[][] dArray = this.sources;
            double[][] dArray2 = this.targets;
            if (dArray == null || dArray2 == null) {
                throw new IllegalStateException(Errors.format((short)64, (Object)(dArray == null ? "sources" : "targets")));
            }
            int n = dArray.length;
            int n2 = dArray2.length;
            this.correlation = new double[n2];
            MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
            matrixSIS.setElement(n2, n, 1.0);
            switch (n) {
                case 1: {
                    Line line = new Line();
                    for (int i = 0; i < dArray2.length; ++i) {
                        this.correlation[i] = line.fit(dArray[0], dArray2[i]);
                        matrixSIS.setElement(i, 0, line.slope());
                        matrixSIS.setElement(i, 1, line.y0());
                    }
                    break;
                }
                case 2: {
                    Plane plane = new Plane();
                    for (int i = 0; i < dArray2.length; ++i) {
                        this.correlation[i] = plane.fit(dArray[0], dArray[1], dArray2[i]);
                        matrixSIS.setElement(i, 0, plane.slopeX());
                        matrixSIS.setElement(i, 1, plane.slopeY());
                        matrixSIS.setElement(i, 2, plane.z0());
                    }
                    break;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
            this.transform = MathTransforms.linear(matrixSIS);
        }
        return this.transform;
    }

    public double[] correlation() {
        return this.correlation != null ? (double[])this.correlation.clone() : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        if (this.sources != null) {
            stringBuilder.append(this.sources[0].length).append(" points");
        }
        stringBuilder.append(']');
        if (this.transform != null) {
            String string = JDK7.lineSeparator();
            stringBuilder.append(':').append(string);
            TableAppender tableAppender = new TableAppender((Appendable)stringBuilder, " ");
            tableAppender.setMultiLinesCells(true);
            tableAppender.append((CharSequence)Matrices.toString(this.transform.getMatrix()));
            tableAppender.nextColumn();
            tableAppender.append((CharSequence)string);
            tableAppender.append((CharSequence)"  ");
            tableAppender.append((CharSequence)Vocabulary.format((short)83));
            tableAppender.append((CharSequence)" =");
            tableAppender.nextColumn();
            tableAppender.append((CharSequence)Matrices.create(this.correlation.length, 1, this.correlation).toString());
            try {
                tableAppender.flush();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return stringBuilder.toString();
    }
}

