/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gml.UniversalTimeAdapter;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalDatumType")
@XmlRootElement(name="TemporalDatum")
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    private long origin;

    private DefaultTemporalDatum() {
        this.origin = Long.MIN_VALUE;
    }

    public DefaultTemporalDatum(Map<String, ?> map, Date date) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"origin", (Object)date);
        this.origin = date.getTime();
    }

    protected DefaultTemporalDatum(TemporalDatum temporalDatum) {
        super((Datum)temporalDatum);
        this.origin = MetadataUtilities.toMilliseconds((Date)temporalDatum.getOrigin());
    }

    public static DefaultTemporalDatum castOrCopy(TemporalDatum temporalDatum) {
        return temporalDatum == null || temporalDatum instanceof DefaultTemporalDatum ? (DefaultTemporalDatum)temporalDatum : new DefaultTemporalDatum(temporalDatum);
    }

    public Class<? extends TemporalDatum> getInterface() {
        return TemporalDatum.class;
    }

    @XmlElement(name="origin")
    @XmlJavaTypeAdapter(value=UniversalTimeAdapter.class)
    public Date getOrigin() {
        return MetadataUtilities.toDate((long)this.origin);
    }

    private void setOrigin(Date date) {
        if (date != null && ReferencingUtilities.canSetProperty(DefaultTemporalDatum.class, "setOrigin", "origin", this.origin != Long.MIN_VALUE)) {
            this.origin = date.getTime();
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return this.origin == ((DefaultTemporalDatum)object).origin;
            }
        }
        return Objects.equals((Object)this.getOrigin(), (Object)((TemporalDatum)object).getOrigin());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + this.origin;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append((FormattableObject)new Origin(MetadataUtilities.toDate((long)this.origin)));
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT((IdentifiedObject)this, null);
        }
        return "TimeDatum";
    }

    private static final class Origin
    extends FormattableObject {
        private final Date origin;

        Origin(Date date) {
            this.origin = date;
        }

        protected String formatTo(Formatter formatter) {
            formatter.append(this.origin);
            return "TimeOrigin";
        }
    }
}

