/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

@XmlType(name="VerticalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="VerticalCRS")
public class DefaultVerticalCRS
extends AbstractCRS
implements VerticalCRS {
    private static final long serialVersionUID = 3565878468719941800L;
    @XmlElement(name="verticalDatum")
    private final VerticalDatum datum;

    private DefaultVerticalCRS() {
        this.datum = null;
    }

    public DefaultVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) {
        super(map, (CoordinateSystem)verticalCS);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)verticalDatum);
        this.datum = verticalDatum;
    }

    protected DefaultVerticalCRS(VerticalCRS verticalCRS) {
        super((CoordinateReferenceSystem)verticalCRS);
        this.datum = verticalCRS.getDatum();
    }

    public static DefaultVerticalCRS castOrCopy(VerticalCRS verticalCRS) {
        return verticalCRS == null || verticalCRS instanceof DefaultVerticalCRS ? (DefaultVerticalCRS)verticalCRS : new DefaultVerticalCRS(verticalCRS);
    }

    public Class<? extends VerticalCRS> getInterface() {
        return VerticalCRS.class;
    }

    public final VerticalDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="verticalCS")
    public VerticalCS getCoordinateSystem() {
        return (VerticalCS)super.getCoordinateSystem();
    }

    private void setCoordinateSystem(VerticalCS verticalCS) {
        super.setCoordinateSystem("verticalCS", (CoordinateSystem)verticalCS);
    }

    @Override
    public DefaultVerticalCRS forConvention(AxesConvention axesConvention) {
        return (DefaultVerticalCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultVerticalCRS(map, this.datum, (VerticalCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Vert_CS" : "VerticalCRS";
    }
}

