/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.ImageDatum;

@XmlType(name="ImageCRSType", propOrder={"cartesianCS", "affineCS", "datum"})
@XmlRootElement(name="ImageCRS")
public class DefaultImageCRS
extends AbstractCRS
implements ImageCRS {
    private static final long serialVersionUID = 7312452786096397847L;
    @XmlElement(name="imageDatum")
    private final ImageDatum datum;

    private DefaultImageCRS() {
        this.datum = null;
    }

    public DefaultImageCRS(Map<String, ?> map, ImageDatum imageDatum, AffineCS affineCS) {
        super(map, (CoordinateSystem)affineCS);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)imageDatum);
        this.datum = imageDatum;
    }

    protected DefaultImageCRS(ImageCRS imageCRS) {
        super((CoordinateReferenceSystem)imageCRS);
        this.datum = imageCRS.getDatum();
    }

    public static DefaultImageCRS castOrCopy(ImageCRS imageCRS) {
        return imageCRS == null || imageCRS instanceof DefaultImageCRS ? (DefaultImageCRS)imageCRS : new DefaultImageCRS(imageCRS);
    }

    public Class<? extends ImageCRS> getInterface() {
        return ImageCRS.class;
    }

    public final ImageDatum getDatum() {
        return this.datum;
    }

    public AffineCS getCoordinateSystem() {
        return (AffineCS)super.getCoordinateSystem();
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    private void setAffineCS(AffineCS affineCS) {
        super.setCoordinateSystem("affineCS", (CoordinateSystem)affineCS);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cartesianCS);
    }

    @Override
    public DefaultImageCRS forConvention(AxesConvention axesConvention) {
        return (DefaultImageCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultImageCRS(map, this.datum, (AffineCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return "ImageCRS";
    }
}

