/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="CompoundCRSType")
@XmlRootElement(name="CompoundCRS")
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private final List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;

    private DefaultCompoundCRS() {
        this.components = null;
    }

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(coordinateReferenceSystemArray));
        this.components = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        ArgumentChecks.ensureNonNull((String)"components", (Object)coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.format((short)104, (Object)2, (Object)coordinateReferenceSystemArray.length));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)coordinateReferenceSystem);
            coordinateSystemArray[i] = coordinateReferenceSystem.getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = ReferencingUtilities.getSingleComponents(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap((Object[])this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> object) {
        object = this.computeSingleCRS((List<? extends CoordinateReferenceSystem>)object) ? this.singles : UnmodifiableArrayList.wrap((Object[])object.toArray(new CoordinateReferenceSystem[object.size()]));
        return object;
    }

    protected DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super((CoordinateReferenceSystem)compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.components = defaultCompoundCRS.components;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.components = this.copy(compoundCRS.getComponents());
        }
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS compoundCRS) {
        return compoundCRS == null || compoundCRS instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)compoundCRS : new DefaultCompoundCRS(compoundCRS);
    }

    public Class<? extends CompoundCRS> getInterface() {
        return CompoundCRS.class;
    }

    @Override
    final Datum getDatum() {
        return null;
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    public List<SingleCRS> getSingleComponents() {
        return this.singles;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.components instanceof CheckedContainer && (clazz = ((CheckedContainer)this.components).getElementType()) == SingleCRS.class) {
            this.singles = this.components;
            return;
        }
        this.computeSingleCRS(this.components);
    }

    @Override
    public synchronized DefaultCompoundCRS forConvention(AxesConvention axesConvention) {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)axesConvention));
        DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)this.getCached(axesConvention);
        if (defaultCompoundCRS == null) {
            defaultCompoundCRS = this;
            boolean bl = false;
            boolean bl2 = axesConvention.ordinal() <= AxesConvention.CONVENTIONALLY_ORIENTED.ordinal();
            List<SingleCRS> list = bl2 ? this.singles : this.components;
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
            for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)list.get(i);
                AbstractCRS abstractCRS = DefaultCompoundCRS.castOrCopy(coordinateReferenceSystem);
                if (abstractCRS != (abstractCRS = abstractCRS.forConvention(axesConvention))) {
                    coordinateReferenceSystem = abstractCRS;
                    bl = true;
                }
                coordinateReferenceSystemArray[i] = coordinateReferenceSystem;
            }
            if (bl) {
                if (bl2) {
                    Arrays.sort(coordinateReferenceSystemArray, SubTypes.BY_TYPE);
                }
                defaultCompoundCRS = new DefaultCompoundCRS(IdentifiedObjects.getProperties(this, "identifiers"), coordinateReferenceSystemArray);
            }
            defaultCompoundCRS = (DefaultCompoundCRS)this.setCached(axesConvention, defaultCompoundCRS);
        }
        return defaultCompoundCRS;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    return this.components.equals(((DefaultCompoundCRS)object).components);
                }
            }
            return Utilities.deepEquals(this.getComponents(), (Object)((CompoundCRS)object).getComponents(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.components.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        for (CoordinateReferenceSystem coordinateReferenceSystem : bl || convention == Convention.INTERNAL ? this.components : this.singles) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
        }
        formatter.newLine();
        return bl ? "Compd_CS" : "CompoundCRS";
    }
}

