/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.Properties;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject, String ... stringArray) {
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        ArgumentChecks.ensureNonNull((String)"excludes", (Object)stringArray);
        return new Properties(identifiedObject, stringArray);
    }

    public static Set<String> getNames(IdentifiedObject identifiedObject, Citation citation) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(identifiedObject, citation, linkedHashSet);
        return linkedHashSet;
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        return IdentifiedObjects.getName(identifiedObject, citation, null);
    }

    private static String getName(IdentifiedObject identifiedObject, Citation citation, Collection<String> collection) {
        block11: {
            Object object;
            ReferenceIdentifier referenceIdentifier;
            block12: {
                Object object2;
                if (identifiedObject == null) break block11;
                referenceIdentifier = identifiedObject.getName();
                if (citation != null) break block12;
                if (referenceIdentifier != null && (object2 = referenceIdentifier.getCode()) != null) {
                    if (collection == null) {
                        return object2;
                    }
                    collection.add((String)object2);
                }
                if ((object2 = Citations.iterator((Collection)identifiedObject.getAlias())) == null) break block11;
                while (object2.hasNext()) {
                    String string;
                    GenericName genericName = (GenericName)object2.next();
                    if (genericName == null || (string = genericName instanceof Identifier ? ((Identifier)genericName).getCode() : genericName.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
                break block11;
            }
            if (referenceIdentifier != null && Citations.identifierMatches((Citation)citation, (Citation)referenceIdentifier.getAuthority()) && (object = referenceIdentifier.getCode()) != null) {
                if (collection == null) {
                    return object;
                }
                collection.add((String)object);
            }
            if ((object = Citations.iterator((Collection)identifiedObject.getAlias())) != null) {
                while (object.hasNext()) {
                    String string;
                    GenericName genericName;
                    Object object3;
                    GenericName genericName2 = (GenericName)object.next();
                    if (genericName2 == null) continue;
                    if (genericName2 instanceof Identifier) {
                        referenceIdentifier = (Identifier)genericName2;
                        if (!Citations.identifierMatches((Citation)citation, (Citation)referenceIdentifier.getAuthority()) || (object3 = referenceIdentifier.getCode()) == null) continue;
                        if (collection == null) {
                            return object3;
                        }
                        collection.add((String)object3);
                        continue;
                    }
                    object3 = genericName2.scope();
                    if (object3 == null || (genericName = object3.name()) == null || !Citations.identifierMatches((Citation)citation, null, (CharSequence)genericName.toString()) || (string = genericName2.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        Iterator iterator;
        if (identifiedObject != null && (iterator = Citations.iterator((Collection)identifiedObject.getIdentifiers())) != null) {
            while (iterator.hasNext()) {
                Identifier identifier = (Identifier)iterator.next();
                if (identifier == null || citation != null && !Citations.identifierMatches((Citation)citation, (Citation)identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Iterator iterator = Citations.iterator((Collection)identifiedObject.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    string = IdentifiedObjects.toString((Identifier)iterator.next());
                    if (string == null) continue;
                    return string;
                }
            }
            if ((string = IdentifiedObjects.toString((Identifier)identifiedObject.getName())) != null) {
                return string;
            }
        }
        return null;
    }

    public static String getUnicodeIdentifier(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Iterator iterator;
            Object object;
            ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
            if (referenceIdentifier != null && CharSequences.isUnicodeIdentifier((CharSequence)(object = referenceIdentifier.getCode()))) {
                return object;
            }
            object = Citations.iterator((Collection)identifiedObject.getAlias());
            if (object != null) {
                while (object.hasNext()) {
                    iterator = (GenericName)object.next();
                    if (iterator == null || (iterator = iterator.tip()) == null || !CharSequences.isUnicodeIdentifier((CharSequence)(string = iterator.toString()))) continue;
                    return string;
                }
            }
            if ((iterator = Citations.iterator((Collection)identifiedObject.getIdentifiers())) != null) {
                while (iterator.hasNext()) {
                    referenceIdentifier = (Identifier)iterator.next();
                    if (referenceIdentifier == null || !CharSequences.isUnicodeIdentifier((CharSequence)(string = referenceIdentifier.getCode()))) continue;
                    return string;
                }
            }
        }
        return null;
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).isHeuristicMatchForName(string);
        }
        ArgumentChecks.ensureNonNull((String)"object", (Object)identifiedObject);
        return IdentifiedObjects.isHeuristicMatchForName(identifiedObject, identifiedObject.getAlias(), string);
    }

    static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, Collection<GenericName> collection, CharSequence charSequence) {
        Object object;
        charSequence = CharSequences.toASCII((CharSequence)charSequence);
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier != null && (object = CharSequences.toASCII((CharSequence)referenceIdentifier.getCode())) != null && CharSequences.equalsFiltered((CharSequence)charSequence, (CharSequence)object, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
            return true;
        }
        if (collection != null) {
            for (GenericName genericName : collection) {
                CharSequence charSequence2;
                if (genericName == null || !CharSequences.equalsFiltered((CharSequence)charSequence, (CharSequence)(charSequence2 = CharSequences.toASCII((CharSequence)genericName.tip().toString())), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String string = identifier.getCode();
        String string2 = null;
        if (identifier instanceof ReferenceIdentifier) {
            string2 = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string2 == null) {
            string2 = Citations.getIdentifier((Citation)identifier.getAuthority());
        }
        if (string2 != null && !string2.isEmpty()) {
            return string2 + ':' + string;
        }
        return string;
    }
}

