/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.HashMap;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jaxb.metadata.replace.ServiceParameter;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.MemberName;

public final class Parameters
extends Static {
    private Parameters() {
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameterDescriptor) {
        return ServiceParameter.getMemberName(parameterDescriptor);
    }

    public static Range<?> getValueDomain(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor != null) {
            if (parameterDescriptor instanceof DefaultParameterDescriptor) {
                return ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain();
            }
            Class clazz = parameterDescriptor.getValueClass();
            Comparable comparable = parameterDescriptor.getMinimumValue();
            Comparable comparable2 = parameterDescriptor.getMaximumValue();
            if ((comparable == null || clazz.isInstance(comparable)) && (comparable2 == null || clazz.isInstance(comparable2))) {
                if (Number.class.isAssignableFrom(clazz)) {
                    Unit unit = parameterDescriptor.getUnit();
                    if (unit != null) {
                        return new MeasurementRange(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true, unit);
                    }
                    if (comparable != null || comparable2 != null) {
                        return new NumberRange(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true);
                    }
                } else if (comparable != null || comparable2 != null) {
                    return new Range(clazz, comparable, true, comparable2, true);
                }
            }
        }
        return null;
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class clazz2;
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, (Object)parameterDescriptor.getName().getCode(), (Object)clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        ParameterDescriptor parameterDescriptor;
        Class clazz2;
        if (parameterValue != null && !clazz.equals(clazz2 = (parameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, (Object)parameterDescriptor.getName().getCode(), (Object)clazz2));
        }
        return parameterValue;
    }

    public static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        Integer n = 1;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Integer n2;
            Object object;
            ParameterValueGroup parameterValueGroup3;
            ParameterValue parameterValue;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                parameterValue = parameterValueGroup2.getDescriptor().descriptor(string);
                if (parameterValue instanceof ParameterDescriptorGroup) {
                    parameterValueGroup3 = (ParameterValueGroup)parameterValue.createValue();
                    Parameters.copy((ParameterValueGroup)generalParameterValue, parameterValueGroup3);
                    parameterValueGroup.groups(string).add(parameterValueGroup3);
                    continue;
                }
                throw new InvalidParameterNameException(Errors.format((short)152, (Object)string), string);
            }
            parameterValue = (ParameterValue)generalParameterValue;
            Integer n3 = (Integer)hashMap.get(string);
            if (n3 == null) {
                n3 = n;
                try {
                    parameterValueGroup3 = parameterValueGroup2.parameter(string);
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)152, (Object)string), string).initCause((Throwable)parameterNotFoundException);
                }
            } else {
                parameterValueGroup3 = (ParameterValue)Parameters.getOrCreate(parameterValueGroup2, string, n3);
                object = n3;
                n2 = n3 = Integer.valueOf(n3 + 1);
            }
            hashMap.put(string, n3);
            object = parameterValue.getValue();
            n2 = parameterValue.getUnit();
            if (n2 == null) {
                parameterValueGroup3.setValue(object);
                continue;
            }
            if (object instanceof Number) {
                parameterValueGroup3.setValue(((Number)object).doubleValue(), (Unit)n2);
                continue;
            }
            if (object instanceof double[]) {
                parameterValueGroup3.setValue((double[])object, (Unit)n2);
                continue;
            }
            throw new InvalidParameterValueException(Errors.format((short)31, (Object)string, (Object)object), string, object);
        }
    }

    private static GeneralParameterValue getOrCreate(ParameterValueGroup parameterValueGroup, String string, int n) {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            if (!string.equals(generalParameterValue.getDescriptor().getName().getCode()) || --n >= 0) continue;
            return generalParameterValue;
        }
        if (n == 0) {
            GeneralParameterValue generalParameterValue = parameterValueGroup.getDescriptor().descriptor(string).createValue();
            parameterValueGroup.values().add(generalParameterValue);
            return generalParameterValue;
        }
        throw new IndexOutOfBoundsException(string);
    }
}

