/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class DefaultParameterValue<T>
extends FormattableObject
implements ParameterValue<T>,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5837826787089486776L;
    private final ParameterDescriptor<T> descriptor;
    private T value;
    private Unit<?> unit;

    public DefaultParameterValue(ParameterDescriptor<T> parameterDescriptor) {
        ArgumentChecks.ensureNonNull((String)"descriptor", parameterDescriptor);
        this.descriptor = parameterDescriptor;
        this.value = parameterDescriptor.getDefaultValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public DefaultParameterValue(ParameterValue<T> parameterValue) {
        ArgumentChecks.ensureNonNull((String)"parameter", parameterValue);
        this.descriptor = parameterValue.getDescriptor();
        this.value = parameterValue.getValue();
        this.unit = parameterValue.getUnit();
    }

    public ParameterDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public T getValue() {
        return this.value;
    }

    public boolean booleanValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        throw this.incompatibleValue(t);
    }

    public int intValue() throws IllegalStateException {
        int n;
        T t = this.getValue();
        if (t instanceof Number && (double)(n = ((Number)t).intValue()) == ((Number)t).doubleValue()) {
            return n;
        }
        throw this.incompatibleValue(t);
    }

    public int[] intValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof int[]) {
            return (int[])((int[])t).clone();
        }
        throw this.incompatibleValue(t);
    }

    public double doubleValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof Number) {
            return ((Number)t).doubleValue();
        }
        throw this.incompatibleValue(t);
    }

    public double[] doubleValueList() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof double[]) {
            return (double[])((double[])t).clone();
        }
        throw this.incompatibleValue(t);
    }

    private UnitConverter getConverterTo(Unit<?> unit) {
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw new IllegalStateException(Errors.format((short)139, (Object)Verifier.getName(this.descriptor)));
        }
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        short s = Verifier.getUnitMessageID(unit2);
        if (Verifier.getUnitMessageID(unit) != s) {
            throw new IllegalArgumentException(Errors.format((short)s, unit));
        }
        try {
            return unit2.getConverterToAny(unit);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format((short)46, unit2, unit), conversionException);
        }
    }

    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        return this.getConverterTo(unit).convert(this.doubleValue());
    }

    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter unitConverter = this.getConverterTo(unit);
        double[] dArray = this.doubleValueList();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = unitConverter.convert(dArray[i]);
        }
        return dArray;
    }

    public String stringValue() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof CharSequence) {
            return t.toString();
        }
        throw this.incompatibleValue(t);
    }

    public URI valueFile() throws IllegalStateException {
        T t = this.getValue();
        if (t instanceof URI) {
            return (URI)t;
        }
        if (t instanceof File) {
            return ((File)t).toURI();
        }
        URISyntaxException uRISyntaxException = null;
        try {
            if (t instanceof URL) {
                return ((URL)t).toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException2) {
            uRISyntaxException = uRISyntaxException2;
        }
        String string = Verifier.getName(this.descriptor);
        if (t != null) {
            throw new InvalidParameterTypeException(this.getClassTypeError(), string);
        }
        throw new IllegalStateException(Errors.format((short)142, (Object)uRISyntaxException, (Object)string));
    }

    private IllegalStateException incompatibleValue(Object object) {
        String string = Verifier.getName(this.descriptor);
        if (object != null) {
            return new InvalidParameterTypeException(this.getClassTypeError(), string);
        }
        return new IllegalStateException(Errors.format((short)142, (Object)string));
    }

    private String getClassTypeError() {
        return Errors.format((short)141, (Object)this.descriptor.getValueClass());
    }

    public void setValue(Object object) throws InvalidParameterValueException {
        this.setValue(object, this.unit);
    }

    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setValue(bl, this.unit);
    }

    public void setValue(int n) throws InvalidParameterValueException {
        Number number;
        Number number2 = n;
        Class clazz = this.descriptor.getValueClass();
        if (Number.class.isAssignableFrom(clazz) && (number = Numbers.cast((Number)n, (Class)clazz)).intValue() == n) {
            number2 = number;
        }
        this.setValue(number2, this.unit);
    }

    private static Number wrap(double d, Class<?> clazz) throws IllegalArgumentException {
        if (Number.class.isAssignableFrom(clazz)) {
            return Numbers.wrap((double)d, clazz);
        }
        return Numerics.valueOf((double)d);
    }

    public void setValue(double d) throws InvalidParameterValueException {
        try {
            this.setValue(DefaultParameterValue.wrap(d, this.descriptor.getValueClass()), this.unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getName(this.descriptor), d);
        }
    }

    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        try {
            this.setValue(DefaultParameterValue.wrap(d, this.descriptor.getValueClass()), unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Verifier.getName(this.descriptor), d);
        }
    }

    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        this.setValue((Object)dArray, unit);
    }

    protected void setValue(Object object, Unit<?> unit) throws InvalidParameterValueException {
        T t = Verifier.ensureValidValue(this.descriptor, object, unit);
        if (object != null) {
            this.validate(t);
            this.value = object;
        } else {
            this.value = this.descriptor.getDefaultValue();
        }
        this.unit = unit;
    }

    protected void validate(T t) throws InvalidParameterValueException {
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValue defaultParameterValue = (DefaultParameterValue)object;
                    return Objects.equals(this.descriptor, defaultParameterValue.descriptor) && Objects.equals(this.value, defaultParameterValue.value) && Objects.equals(this.unit, defaultParameterValue.unit);
                }
            } else if (object instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)object;
                return Utilities.deepEquals(this.getDescriptor(), (Object)parameterValue.getDescriptor(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getValue(), (Object)parameterValue.getValue(), (ComparisonMode)comparisonMode) && Objects.equals(this.getUnit(), (Object)parameterValue.getUnit());
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int n = 37 * this.descriptor.hashCode();
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.unit != null) {
            n += 31 * this.unit.hashCode();
        }
        return n;
    }

    public DefaultParameterValue<T> clone() {
        try {
            return (DefaultParameterValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    protected String formatTo(Formatter formatter) {
        boolean bl;
        WKTUtilities.appendName(this.descriptor, formatter, ElementKind.PARAMETER);
        Unit unit = formatter.toContextualUnit(this.descriptor.getUnit());
        Convention convention = formatter.getConvention();
        boolean bl2 = bl = convention.majorVersion() == 1;
        if (bl && unit != null) {
            double d;
            try {
                d = this.doubleValue(unit);
            }
            catch (IllegalStateException illegalStateException) {
                formatter.setInvalidWKT(this.descriptor, (Exception)illegalStateException);
                d = Double.NaN;
            }
            formatter.append(d);
        } else {
            formatter.appendAny(this.value);
        }
        if (!(this.unit == null || bl || convention.isSimplified() && this.unit.equals((Object)unit))) {
            formatter.append(this.unit);
        }
        return "Parameter";
    }
}

