/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    private static CoordinateOperationFactory getFactory() throws TransformException {
        CoordinateOperationFactory coordinateOperationFactory = (CoordinateOperationFactory)DefaultFactories.forClass(CoordinateOperationFactory.class);
        if (coordinateOperationFactory != null) {
            return coordinateOperationFactory;
        }
        throw new TransformException(Errors.format((short)61, (Object)"geotk-referencing"));
    }

    private static boolean isWrapAround(CoordinateSystemAxis coordinateSystemAxis) {
        return RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning());
    }

    private static void recoverableException(TransformException transformException) {
        Logging.recoverableException(Envelopes.class, (String)"transform", (Throwable)transformException);
    }

    private static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, double[] dArray2, int n, boolean bl) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, 0, dArray2, n, bl);
        }
        Matrix matrix = bl ? mathTransform.derivative((DirectPosition)new DirectPositionView(dArray, 0, mathTransform.getSourceDimensions())) : null;
        mathTransform.transform(dArray, 0, dArray2, n, 1);
        return matrix;
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != coordinateReferenceSystem) {
            if (coordinateReferenceSystem2 == null) {
                envelope = new GeneralEnvelope(envelope);
                ((GeneralEnvelope)envelope).setCoordinateReferenceSystem(coordinateReferenceSystem);
            } else {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = Envelopes.getFactory().createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((short)176), (Throwable)factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
            assert (Utilities.deepEquals((Object)coordinateReferenceSystem, (Object)envelope.getCoordinateReferenceSystem(), (ComparisonMode)ComparisonMode.DEBUG));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        return envelope != null ? Envelopes.transform(mathTransform, envelope, null) : null;
    }

    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, double[] dArray) throws TransformException {
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (dArray != null) {
                int n = envelope.getDimension();
                while (--n >= 0) {
                    dArray[n] = generalEnvelope.getMedian(n);
                }
            }
            return generalEnvelope;
        }
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        if (envelope.getDimension() != n) {
            throw new MismatchedDimensionException(Errors.format((short)58, (Object)n, (Object)envelope.getDimension()));
        }
        if (n >= 20) {
            throw new IllegalArgumentException(Errors.format((short)177));
        }
        int n3 = 0;
        boolean bl = true;
        GeneralEnvelope generalEnvelope = null;
        Matrix[] matrixArray = new Matrix[Formulas.pow3(n)];
        double[] dArray2 = new double[matrixArray.length * n2];
        double[] dArray3 = new double[n];
        int n4 = n;
        while (--n4 >= 0) {
            dArray3[n4] = envelope.getMinimum(n4);
        }
        DirectPositionView directPositionView = new DirectPositionView(dArray2, 0, n2);
        block14: while (true) {
            int n5 = n3 * n2;
            try {
                matrixArray[n3] = Envelopes.derivativeAndTransform(mathTransform, dArray3, dArray2, n5, bl);
            }
            catch (TransformException transformException) {
                if (!bl) {
                    throw transformException;
                }
                bl = false;
                mathTransform.transform(dArray3, 0, dArray2, n5, 1);
                Envelopes.recoverableException(transformException);
            }
            if (generalEnvelope == null) {
                generalEnvelope = new GeneralEnvelope(n2);
                for (int i = 0; i < n2; ++i) {
                    double d = dArray2[n5 + i];
                    generalEnvelope.setRange(i, d, d);
                }
            } else {
                directPositionView.offset = n5;
                generalEnvelope.add(directPositionView);
            }
            int n6 = ++n3;
            int n7 = n;
            while (--n7 >= 0) {
                switch (n6 % 3) {
                    case 0: {
                        dArray3[n7] = envelope.getMinimum(n7);
                        break;
                    }
                    case 1: {
                        dArray3[n7] = envelope.getMaximum(n7);
                        continue block14;
                    }
                    case 2: {
                        dArray3[n7] = envelope.getMedian(n7);
                        continue block14;
                    }
                    default: {
                        throw new AssertionError(n6);
                    }
                }
                n6 /= 3;
            }
            break;
        }
        assert (n3 == matrixArray.length) : n3;
        DirectPosition directPosition = null;
        DirectPositionView directPositionView2 = new DirectPositionView(dArray3, 0, n);
        CurveExtremum curveExtremum = new CurveExtremum();
        for (n3 = 0; n3 < matrixArray.length; ++n3) {
            Matrix matrix = matrixArray[n3];
            if (matrix == null) continue;
            int n8 = n3;
            int n9 = 1;
            int n10 = n;
            while (--n10 >= 0) {
                int n11;
                Matrix matrix2;
                int n12 = n8 % 3;
                if (n12 != 2 && (matrix2 = matrixArray[n11 = n3 + n9 * (2 - n12)]) != null) {
                    double d = envelope.getMinimum(n10);
                    double d2 = envelope.getMaximum(n10);
                    double d3 = envelope.getMedian(n10);
                    double d4 = n12 == 0 ? d : d2;
                    int n13 = n2 * n3;
                    int n14 = n2 * n11;
                    for (int i = 0; i < n2; ++i) {
                        curveExtremum.resolve(d4, dArray2[n13 + i], matrix.getElement(i, n10), d3, dArray2[n14 + i], matrix2.getElement(i, n10));
                        boolean bl2 = false;
                        do {
                            double d5;
                            double d6;
                            double d7 = d6 = bl2 ? curveExtremum.ex2 : curveExtremum.ex1;
                            if (!(d6 > d) || !(d6 < d2)) continue;
                            double d8 = d5 = bl2 ? curveExtremum.ey2 : curveExtremum.ey1;
                            if (!(d5 < generalEnvelope.getMinimum(i)) && !(d5 > generalEnvelope.getMaximum(i))) continue;
                            int n15 = n3;
                            int n16 = n;
                            while (--n16 >= 0) {
                                double d9;
                                if (n16 == n10) {
                                    d9 = d6;
                                } else {
                                    switch (n15 % 3) {
                                        case 0: {
                                            d9 = envelope.getMinimum(n16);
                                            break;
                                        }
                                        case 1: {
                                            d9 = envelope.getMaximum(n16);
                                            break;
                                        }
                                        case 2: {
                                            d9 = envelope.getMedian(n16);
                                            break;
                                        }
                                        default: {
                                            throw new AssertionError(n15);
                                        }
                                    }
                                }
                                dArray3[n16] = d9;
                                n15 /= 3;
                            }
                            directPosition = mathTransform.transform((DirectPosition)directPositionView2, directPosition);
                            generalEnvelope.add(directPosition);
                        } while (bl2 = !bl2);
                    }
                }
                n8 /= 3;
                n9 *= 3;
            }
            matrixArray[n3] = null;
        }
        if (dArray != null) {
            System.arraycopy(dArray2, dArray2.length - n2, dArray, 0, n2);
        }
        return generalEnvelope;
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        CoordinateSystem coordinateSystem;
        Object object4;
        CoordinateReferenceSystem coordinateReferenceSystem;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)coordinateOperation);
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2)) {
            try {
                object4 = Envelopes.getFactory().createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
            }
            catch (FactoryException factoryException) {
                throw new TransformException(Errors.format((short)176), (Throwable)factoryException);
            }
            if (!object4.isIdentity()) {
                envelope = Envelopes.transform((MathTransform)object4, envelope);
            }
        }
        coordinateReferenceSystem = coordinateOperation.getMathTransform();
        object4 = new double[coordinateReferenceSystem.getTargetDimensions()];
        GeneralEnvelope generalEnvelope = Envelopes.transform((MathTransform)coordinateReferenceSystem, envelope, object4);
        if (coordinateReferenceSystem2 != null && (coordinateSystem = coordinateReferenceSystem2.getCoordinateSystem()) != null) {
            object3 = null;
            object2 = null;
            int n4 = coordinateSystem.getDimension();
            for (int i = 0; i < n4; ++i) {
                object = coordinateSystem.getAxis(i);
                if (object == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = object.getMinimumValue();
                double d4 = object.getMaximumValue();
                n3 = d3 > d && d3 < d2 ? 1 : 0;
                int n5 = n2 = d4 > d && d4 < d2 ? 1 : 0;
                if (n3 == 0 && n2 == 0) continue;
                if (object3 == null) {
                    object3 = new GeneralDirectPosition(n4);
                    for (int j = 0; j < n4; ++j) {
                        object3.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (n3 != 0) {
                    object3.setOrdinate(i, d3);
                    object2 = coordinateReferenceSystem.transform((DirectPosition)object3, object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                if (n2 != 0) {
                    object3.setOrdinate(i, d4);
                    object2 = coordinateReferenceSystem.transform((DirectPosition)object3, object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                object3.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((coordinateSystem = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope;
        }
        generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)coordinateSystem);
        object3 = coordinateSystem.getCoordinateSystem();
        if (object3 == null) {
            return generalEnvelope;
        }
        object2 = null;
        AbstractEnvelope abstractEnvelope = null;
        DirectPosition directPosition = null;
        object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        n3 = object3.getDimension();
        n2 = 0;
        while (n2 < n3) {
            CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n2);
            if (coordinateSystemAxis != null) {
                n = 0;
                do {
                    double d;
                    double d5 = d = n != 0 ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                    if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                    if (object == null) {
                        try {
                            coordinateReferenceSystem = coordinateReferenceSystem.inverse();
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            if (n3 >= coordinateReferenceSystem.getSourceDimensions()) {
                                Envelopes.recoverableException((TransformException)((Object)noninvertibleTransformException));
                            }
                            return generalEnvelope;
                        }
                        object = new GeneralDirectPosition(coordinateReferenceSystem.getSourceDimensions());
                        for (int i = 0; i < n3; ++i) {
                            object.setOrdinate(i, object4[i]);
                        }
                        abstractEnvelope = AbstractEnvelope.castOrCopy(envelope);
                    }
                    object.setOrdinate(n2, d);
                    try {
                        directPosition = coordinateReferenceSystem.transform((DirectPosition)object, directPosition);
                    }
                    catch (TransformException transformException) {
                        if (object2 != null) continue;
                        object2 = transformException;
                        continue;
                    }
                    if (!abstractEnvelope.contains(directPosition)) continue;
                    generalEnvelope.add((DirectPosition)object);
                    if (n != 0) {
                        l2 |= l4;
                        continue;
                    }
                    l |= l4;
                } while ((n = n == 0 ? 1 : 0) == 1);
                if ((l & l2 & l4) == 0L && Envelopes.isWrapAround(coordinateSystemAxis)) {
                    l3 |= l4;
                }
                if (object != null) {
                    object.setOrdinate(n2, object4[n2]);
                }
            }
            ++n2;
            l4 <<= 1;
        }
        long l5 = l | l2;
        if (l5 != 0L) {
            while (l3 != 0L) {
                long l6;
                n = Long.numberOfTrailingZeros(l3);
                l4 = 1 << n;
                l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n);
                double d = coordinateSystemAxis.getMinimumValue();
                double d6 = coordinateSystemAxis.getMaximumValue();
                for (long i = l5 & (l4 ^ 0xFFFFFFFFFFFFFFFFL); i != 0L; i &= l6 ^ 0xFFFFFFFFFFFFFFFFL) {
                    l6 = Long.lowestOneBit(i);
                    int n6 = Long.numberOfTrailingZeros(l6);
                    CoordinateSystemAxis coordinateSystemAxis2 = object3.getAxis(n6);
                    for (int j = 0; j < 4; ++j) {
                        double d7 = d6;
                        if ((j & 1) == 0) {
                            if (((j == 0 ? l : l2) & l6) == 0L) {
                                ++j;
                                continue;
                            }
                            object.setOrdinate(n6, j == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue());
                            d7 = d;
                        }
                        object.setOrdinate(n, d7);
                        try {
                            directPosition = coordinateReferenceSystem.transform((DirectPosition)object, directPosition);
                        }
                        catch (TransformException transformException) {
                            if (object2 != null) continue;
                            object2 = transformException;
                            continue;
                        }
                        if (!abstractEnvelope.contains(directPosition)) continue;
                        generalEnvelope.add((DirectPosition)object);
                    }
                    object.setOrdinate(n6, object4[n6]);
                }
                object.setOrdinate(n, object4[n]);
            }
        }
        if (object2 != null) {
            Envelopes.recoverableException(object2);
        }
        return generalEnvelope;
    }

    public static Envelope fromWKT(CharSequence charSequence) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"wkt", (Object)charSequence);
        try {
            return new GeneralEnvelope(charSequence);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(Errors.format((short)124, Envelope.class), (Throwable)illegalArgumentException);
        }
    }

    public static String toString(Envelope envelope) {
        return AbstractEnvelope.toString(envelope, false);
    }

    public static String toPolygonWKT(Envelope envelope) throws IllegalArgumentException {
        double d;
        int n;
        for (n = envelope.getDimension(); n != 0 && (Double.isNaN(d = envelope.getSpan(n - 1)) || Double.isInfinite(d)); --n) {
        }
        if (n < 2) {
            throw new IllegalArgumentException(Errors.format((short)22));
        }
        StringBuilder stringBuilder = new StringBuilder("POLYGON(");
        String string = "(";
        for (int i = 0; i < CORNERS.length; i += 2) {
            for (int j = 0; j < n; ++j) {
                double d2;
                switch (j) {
                    case 0: 
                    case 1: {
                        d2 = CORNERS[i + j] ? envelope.getMaximum(j) : envelope.getMinimum(j);
                        break;
                    }
                    default: {
                        d2 = envelope.getMedian(j);
                    }
                }
                StringBuilders.trimFractionalPart((StringBuilder)stringBuilder.append(string).append(d2));
                string = " ";
            }
            string = ", ";
        }
        return stringBuilder.append("))").toString();
    }
}

