/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.List;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="DQ_QuantitativeResult_Type", propOrder={"valueType", "valueUnit", "errorStatistic"})
@XmlRootElement(name="DQ_QuantitativeResult")
public class DefaultQuantitativeResult
extends AbstractResult
implements QuantitativeResult {
    private static final long serialVersionUID = -403671810118461829L;
    private List<Record> values;
    private RecordType valueType;
    private Unit<?> valueUnit;
    private InternationalString errorStatistic;

    public DefaultQuantitativeResult() {
    }

    public DefaultQuantitativeResult(QuantitativeResult quantitativeResult) {
        super((Result)quantitativeResult);
        if (quantitativeResult != null) {
            this.valueType = quantitativeResult.getValueType();
            this.valueUnit = quantitativeResult.getValueUnit();
            this.errorStatistic = quantitativeResult.getErrorStatistic();
            this.values = this.copyList(quantitativeResult.getValues(), Record.class);
        }
    }

    public static DefaultQuantitativeResult castOrCopy(QuantitativeResult quantitativeResult) {
        if (quantitativeResult == null || quantitativeResult instanceof DefaultQuantitativeResult) {
            return (DefaultQuantitativeResult)quantitativeResult;
        }
        return new DefaultQuantitativeResult(quantitativeResult);
    }

    public List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public void setValues(List<Record> list) {
        this.values = this.writeList(list, this.values, Record.class);
    }

    @XmlElement(name="valueType")
    public RecordType getValueType() {
        return this.valueType;
    }

    public void setValueType(RecordType recordType) {
        this.checkWritePermission();
        this.valueType = recordType;
    }

    @XmlElement(name="valueUnit", required=true)
    public Unit<?> getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(Unit<?> unit) {
        this.checkWritePermission();
        this.valueUnit = unit;
    }

    @XmlElement(name="errorStatistic")
    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public void setErrorStatistic(InternationalString internationalString) {
        this.checkWritePermission();
        this.errorStatistic = internationalString;
    }
}

