/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.lineage.NominalResolution;

@XmlType(name="LE_NominalResolution_Type", propOrder={"scanningResolution", "groundResolution"})
@XmlRootElement(name="LE_NominalResolution", namespace="http://www.isotc211.org/2005/gmi")
public class DefaultNominalResolution
extends ISOMetadata
implements NominalResolution {
    private static final long serialVersionUID = -4000422414866855607L;
    private Double scanningResolution;
    private Double groundResolution;

    public DefaultNominalResolution() {
    }

    public DefaultNominalResolution(NominalResolution nominalResolution) {
        super(nominalResolution);
        if (nominalResolution != null) {
            this.scanningResolution = nominalResolution.getScanningResolution();
            this.groundResolution = nominalResolution.getGroundResolution();
        }
    }

    public static DefaultNominalResolution castOrCopy(NominalResolution nominalResolution) {
        if (nominalResolution == null || nominalResolution instanceof DefaultNominalResolution) {
            return (DefaultNominalResolution)nominalResolution;
        }
        return new DefaultNominalResolution(nominalResolution);
    }

    private static void ensurePositive(String string, Double d) throws IllegalArgumentException {
        if (d != null && !(d > 0.0)) {
            MetadataUtilities.warnNonPositiveArgument(DefaultNominalResolution.class, string, true, d);
        }
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="scanningResolution", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Double getScanningResolution() {
        return this.scanningResolution;
    }

    public void setScanningResolution(Double d) {
        this.checkWritePermission();
        DefaultNominalResolution.ensurePositive("scanningResolution", d);
        this.scanningResolution = d;
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="groundResolution", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Double getGroundResolution() {
        return this.groundResolution;
    }

    public void setGroundResolution(Double d) {
        this.checkWritePermission();
        DefaultNominalResolution.ensurePositive("groundResolution", d);
        this.groundResolution = d;
    }
}

