/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_KeywordClass_Type", propOrder={"className", "conceptIdentifier", "ontology"})
@XmlRootElement(name="MD_KeywordClass")
public class DefaultKeywordClass
extends ISOMetadata {
    private static final long serialVersionUID = 5353835680916000713L;
    private InternationalString className;
    private URI conceptIdentifier;
    private Citation ontology;

    public DefaultKeywordClass() {
    }

    public DefaultKeywordClass(CharSequence charSequence, Citation citation) {
        this.className = Types.toInternationalString((CharSequence)charSequence);
        this.ontology = citation;
    }

    public DefaultKeywordClass(DefaultKeywordClass defaultKeywordClass) {
        super(defaultKeywordClass);
        if (defaultKeywordClass != null) {
            this.className = defaultKeywordClass.getClassName();
            this.conceptIdentifier = defaultKeywordClass.getConceptIdentifier();
            this.ontology = defaultKeywordClass.getOntology();
        }
    }

    @XmlElement(name="className", required=true)
    public InternationalString getClassName() {
        return this.className;
    }

    public void setClassName(InternationalString internationalString) {
        this.checkWritePermission();
        this.className = internationalString;
    }

    @XmlElement(name="conceptIdentifier")
    public URI getConceptIdentifier() {
        return this.conceptIdentifier;
    }

    public void setConceptIdentifier(URI uRI) {
        this.checkWritePermission();
        this.conceptIdentifier = uRI;
    }

    @XmlElement(name="ontology", required=true)
    public Citation getOntology() {
        return this.ontology;
    }

    public void setOntology(Citation citation) {
        this.checkWritePermission();
        this.ontology = citation;
    }
}

