/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Date;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    public static final Extent WORLD;

    private Extents() {
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        GeographicBoundingBox geographicBoundingBox = null;
        if (extent != null) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) {
                    if (!(geographicExtent instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    if (!MetadataUtilities.getInclusion(geographicBoundingBox2.getInclusion())) continue;
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                    defaultGeographicBoundingBox.setBounds(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange measurementRange = null;
        if (extent != null) {
            for (VerticalExtent verticalExtent : extent.getVerticalElements()) {
                CoordinateSystemAxis coordinateSystemAxis;
                double d = verticalExtent.getMinimumValue();
                double d2 = verticalExtent.getMaximumValue();
                VerticalCRS verticalCRS = verticalExtent.getVerticalCRS();
                Unit unit = null;
                if (verticalCRS != null) {
                    coordinateSystemAxis = verticalCRS.getCoordinateSystem().getAxis(0);
                    unit = coordinateSystemAxis.getUnit();
                    if (AxisDirection.DOWN.equals((Object)coordinateSystemAxis.getDirection())) {
                        double d3 = d;
                        d = -d2;
                        d2 = -d3;
                    }
                }
                if (measurementRange != null) {
                    if (unit == null) continue;
                    coordinateSystemAxis = measurementRange.unit();
                    if (coordinateSystemAxis != null) {
                        if (!coordinateSystemAxis.isCompatible(unit)) continue;
                        measurementRange = (MeasurementRange)measurementRange.union((Range)MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, (Unit)unit));
                        continue;
                    }
                }
                measurementRange = MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, (Unit)unit);
            }
        }
        return measurementRange;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                Date date3;
                Date date4;
                DefaultTemporalExtent defaultTemporalExtent;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    defaultTemporalExtent = (DefaultTemporalExtent)temporalExtent;
                    date4 = defaultTemporalExtent.getStartTime();
                    date3 = defaultTemporalExtent.getEndTime();
                } else {
                    defaultTemporalExtent = temporalExtent.getExtent();
                    date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, true);
                    date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, false);
                }
                if (date4 != null && (date == null || date4.before(date))) {
                    date = date4;
                }
                if (date3 == null || date2 != null && !date3.after(date2)) continue;
                date2 = date3;
            }
        }
        if (date == null && date2 == null) {
            return null;
        }
        return new Range(Date.class, date, true, date2, true);
    }

    public static Date getDate(Extent extent, double d) {
        ArgumentChecks.ensureFinite((String)"location", (double)d);
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : extent.getTemporalElements()) {
                DefaultTemporalExtent defaultTemporalExtent;
                Date date3 = null;
                Date date4 = null;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    defaultTemporalExtent = (DefaultTemporalExtent)temporalExtent;
                    if (d != 1.0) {
                        date3 = defaultTemporalExtent.getStartTime();
                    }
                    if (d != 0.0) {
                        date4 = defaultTemporalExtent.getEndTime();
                    }
                } else {
                    defaultTemporalExtent = temporalExtent.getExtent();
                    if (d != 1.0) {
                        date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, true);
                    }
                    if (d != 0.0) {
                        date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, false);
                    }
                }
                if (date3 != null && (date == null || date3.before(date))) {
                    date = date3;
                }
                if (date4 == null || date2 != null && !date4.after(date2)) continue;
                date2 = date4;
            }
        }
        if (date == null) {
            return date2;
        }
        if (date2 == null) {
            return date;
        }
        long l = date.getTime();
        return new Date(l + Math.round((double)(date2.getTime() - l) * d));
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox geographicBoundingBox, GeographicBoundingBox geographicBoundingBox2) {
        if (geographicBoundingBox == null) {
            return geographicBoundingBox2;
        }
        if (geographicBoundingBox2 == null || geographicBoundingBox2 == geographicBoundingBox) {
            return geographicBoundingBox;
        }
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
        defaultGeographicBoundingBox.intersect(geographicBoundingBox2);
        return defaultGeographicBoundingBox;
    }

    public static double area(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null) {
            return Double.NaN;
        }
        double d = geographicBoundingBox.getEastBoundLongitude() - geographicBoundingBox.getWestBoundLongitude();
        d -= Math.floor(d / 360.0) * 360.0;
        return 4.0589730194049E13 * Math.toRadians(d) * Math.max(0.0, Math.sin(Math.toRadians(geographicBoundingBox.getNorthBoundLatitude())) - Math.sin(Math.toRadians(geographicBoundingBox.getSouthBoundLatitude())));
    }

    static {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        defaultGeographicBoundingBox.freeze();
        DefaultExtent defaultExtent = new DefaultExtent((CharSequence)Vocabulary.formatInternational((short)64), defaultGeographicBoundingBox, null, null);
        defaultExtent.freeze();
        WORLD = defaultExtent;
    }
}

