/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_VerticalExtent_Type", propOrder={"minimumValue", "maximumValue", "verticalCRS"})
@XmlRootElement(name="EX_VerticalExtent")
public class DefaultVerticalExtent
extends ISOMetadata
implements VerticalExtent {
    private static final long serialVersionUID = -1963873471175296153L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public DefaultVerticalExtent() {
    }

    public DefaultVerticalExtent(double d, double d2, VerticalCRS verticalCRS) {
        if (!Double.isNaN(d)) {
            this.minimumValue = d;
        }
        if (!Double.isNaN(d2)) {
            this.maximumValue = d2;
        }
        this.verticalCRS = verticalCRS;
    }

    public DefaultVerticalExtent(VerticalExtent verticalExtent) {
        super(verticalExtent);
        if (verticalExtent != null) {
            this.minimumValue = verticalExtent.getMinimumValue();
            this.maximumValue = verticalExtent.getMaximumValue();
            this.verticalCRS = verticalExtent.getVerticalCRS();
        }
    }

    public static DefaultVerticalExtent castOrCopy(VerticalExtent verticalExtent) {
        if (verticalExtent == null || verticalExtent instanceof DefaultVerticalExtent) {
            return (DefaultVerticalExtent)verticalExtent;
        }
        return new DefaultVerticalExtent(verticalExtent);
    }

    @XmlElement(name="minimumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double d) {
        this.checkWritePermission();
        this.minimumValue = d;
    }

    @XmlElement(name="maximumValue", required=true)
    @XmlJavaTypeAdapter(value=GO_Real.class)
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double d) {
        this.checkWritePermission();
        this.maximumValue = d;
    }

    @XmlElement(name="verticalCRS", required=true)
    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public void setVerticalCRS(VerticalCRS verticalCRS) {
        this.checkWritePermission();
        this.verticalCRS = verticalCRS;
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
    }
}

