/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends ISOMetadata
implements TemporalExtent {
    private static final long serialVersionUID = -6149873501105795242L;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent temporalExtent) {
        super(temporalExtent);
        if (temporalExtent != null) {
            this.extent = temporalExtent.getExtent();
        }
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent temporalExtent) {
        if (temporalExtent instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)temporalExtent);
        }
        if (temporalExtent == null || temporalExtent instanceof DefaultTemporalExtent) {
            return (DefaultTemporalExtent)temporalExtent;
        }
        return new DefaultTemporalExtent(temporalExtent);
    }

    @XmlElement(name="extent", required=true)
    public TemporalPrimitive getExtent() {
        return this.extent;
    }

    public void setExtent(TemporalPrimitive temporalPrimitive) {
        this.checkWritePermission();
        this.extent = temporalPrimitive;
    }

    static Date getTime(TemporalPrimitive temporalPrimitive, boolean bl) {
        Instant instant;
        if (temporalPrimitive instanceof Instant) {
            instant = (Instant)temporalPrimitive;
        } else if (temporalPrimitive instanceof Period) {
            instant = bl ? ((Period)temporalPrimitive).getBeginning() : ((Period)temporalPrimitive).getEnding();
        } else {
            return null;
        }
        return instant.getDate();
    }

    public Date getStartTime() {
        return DefaultTemporalExtent.getTime(this.extent, true);
    }

    public Date getEndTime() {
        return DefaultTemporalExtent.getTime(this.extent, false);
    }

    public void setBounds(Date date, Date date2) throws UnsupportedOperationException {
        Object object = null;
        if (date != null || date2 != null) {
            object = date2 == null || date2.equals(date) ? TemporalUtilities.createInstant((Date)date) : (date == null ? TemporalUtilities.createInstant((Date)date2) : TemporalUtilities.createPeriod((Date)date, (Date)date2));
        }
        this.setExtent((TemporalPrimitive)object);
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
    }
}

