/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.distribution.DataFile;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.LocalName;

@XmlType(name="MX_DataFile_Type", propOrder={"featureTypes", "fileFormat"})
@XmlRootElement(name="MX_DataFile", namespace="http://www.isotc211.org/2005/gmx")
public class DefaultDataFile
extends ISOMetadata
implements DataFile {
    private static final long serialVersionUID = -4556006719009557349L;
    private Collection<LocalName> featureTypes;
    private Format fileFormat;

    public DefaultDataFile() {
    }

    public DefaultDataFile(DataFile dataFile) {
        super(dataFile);
        if (dataFile != null) {
            this.featureTypes = this.copyCollection(dataFile.getFeatureTypes(), LocalName.class);
            this.fileFormat = dataFile.getFileFormat();
        }
    }

    public static DefaultDataFile castOrCopy(DataFile dataFile) {
        if (dataFile == null || dataFile instanceof DefaultDataFile) {
            return (DefaultDataFile)dataFile;
        }
        return new DefaultDataFile(dataFile);
    }

    @XmlElement(name="featureType", namespace="http://www.isotc211.org/2005/gmx")
    public Collection<LocalName> getFeatureTypes() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, LocalName.class);
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<? extends LocalName> collection) {
        this.featureTypes = this.writeCollection(collection, this.featureTypes, LocalName.class);
    }

    @XmlElement(name="fileFormat", namespace="http://www.isotc211.org/2005/gmx", required=true)
    public Format getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(Format format) {
        this.checkWritePermission();
        this.fileFormat = format;
    }
}

