/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;

@XmlType(name="MD_RangeDimension_Type", propOrder={"sequenceIdentifier", "descriptor"})
@XmlRootElement(name="MD_RangeDimension")
@XmlSeeAlso(value={DefaultBand.class})
public class DefaultRangeDimension
extends ISOMetadata
implements RangeDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private MemberName sequenceIdentifier;
    private InternationalString description;
    private Collection<Identifier> names;

    public DefaultRangeDimension() {
    }

    public DefaultRangeDimension(RangeDimension rangeDimension) {
        super(rangeDimension);
        if (rangeDimension != null) {
            this.sequenceIdentifier = rangeDimension.getSequenceIdentifier();
            this.description = rangeDimension.getDescriptor();
            if (rangeDimension instanceof DefaultRangeDimension) {
                this.names = this.copyCollection(((DefaultRangeDimension)rangeDimension).getNames(), Identifier.class);
            }
        }
    }

    public static DefaultRangeDimension castOrCopy(RangeDimension rangeDimension) {
        if (rangeDimension instanceof Band) {
            return DefaultBand.castOrCopy((Band)rangeDimension);
        }
        if (rangeDimension == null || rangeDimension instanceof DefaultRangeDimension) {
            return (DefaultRangeDimension)rangeDimension;
        }
        return new DefaultRangeDimension(rangeDimension);
    }

    @XmlElement(name="sequenceIdentifier")
    public MemberName getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public void setSequenceIdentifier(MemberName memberName) {
        this.checkWritePermission();
        this.sequenceIdentifier = memberName;
    }

    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Deprecated
    @XmlElement(name="descriptor")
    public InternationalString getDescriptor() {
        return this.getDescription();
    }

    @Deprecated
    public void setDescriptor(InternationalString internationalString) {
        this.setDescription(internationalString);
    }

    @UML(identifier="name", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Identifier> getNames() {
        this.names = this.nonNullCollection(this.names, Identifier.class);
        return this.names;
    }

    public void setNames(Collection<? extends Identifier> collection) {
        this.names = this.writeCollection(collection, this.names, Identifier.class);
    }
}

