/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.metadata.iso.citation.Authority;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.citation.Citation;

public final class Citations
extends Static {
    public static final Citation ISO = new SimpleCitation("ISO");
    public static final Citation OGC = new SimpleCitation("OGC");
    public static final Citation OGP = new SimpleCitation("OGP");
    public static final Citation SIS = new SimpleCitation("SIS");
    public static final Citation ESRI = new SimpleCitation("ESRI");
    public static final Citation ORACLE = new SimpleCitation("Oracle");
    public static final Citation NETCDF = new SimpleCitation("NetCDF");
    public static final Citation GEOTIFF = new SimpleCitation("GeoTIFF");
    public static final IdentifierSpace<String> PROJ4 = new Authority<String>("Proj.4", "PROJ4");
    public static final IdentifierSpace<Integer> EPSG = new Authority<Integer>("EPSG", "EPSG");
    public static final IdentifierSpace<String> ISBN = DefaultCitation.ISBN;
    public static final IdentifierSpace<String> ISSN = DefaultCitation.ISSN;
    private static final Citation[] CITATIONS = new Citation[]{ISO, OGC, OGP, SIS, ESRI, ORACLE, NETCDF, GEOTIFF, PROJ4, EPSG, ISBN, ISSN};

    private Citations() {
    }

    public static Citation fromName(String string) {
        if (string == null || (string = CharSequences.trimWhitespaces((String)string)).isEmpty()) {
            return null;
        }
        for (Citation citation : CITATIONS) {
            if (!Citations.titleMatches(citation, string)) continue;
            return citation;
        }
        return new SimpleCitation(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.titleMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean titleMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.titleMatches((Citation)citation, (CharSequence)string);
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.identifierMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean identifierMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.identifierMatches((Citation)citation, null, (CharSequence)string);
    }

    public static String getIdentifier(Citation citation) {
        return org.apache.sis.internal.util.Citations.getIdentifier((Citation)citation);
    }
}

