/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.RequestedDate;

@XmlType(name="MI_RequestedDate_Type", propOrder={"requestedDateOfCollection", "latestAcceptableDate"})
@XmlRootElement(name="MI_RequestedDate")
public class DefaultRequestedDate
extends ISOMetadata
implements RequestedDate {
    private static final long serialVersionUID = 942236885315159329L;
    private long requestedDateOfCollection = Long.MIN_VALUE;
    private long latestAcceptableDate = Long.MIN_VALUE;

    public DefaultRequestedDate() {
    }

    public DefaultRequestedDate(RequestedDate requestedDate) {
        super(requestedDate);
        if (requestedDate != null) {
            this.requestedDateOfCollection = MetadataUtilities.toMilliseconds(requestedDate.getRequestedDateOfCollection());
            this.latestAcceptableDate = MetadataUtilities.toMilliseconds(requestedDate.getLatestAcceptableDate());
        }
    }

    public static DefaultRequestedDate castOrCopy(RequestedDate requestedDate) {
        if (requestedDate == null || requestedDate instanceof DefaultRequestedDate) {
            return (DefaultRequestedDate)requestedDate;
        }
        return new DefaultRequestedDate(requestedDate);
    }

    @XmlElement(name="requestedDateOfCollection", required=true)
    public Date getRequestedDateOfCollection() {
        return MetadataUtilities.toDate(this.requestedDateOfCollection);
    }

    public void setRequestedDateOfCollection(Date date) {
        this.checkWritePermission();
        this.requestedDateOfCollection = MetadataUtilities.toMilliseconds(date);
    }

    @XmlElement(name="latestAcceptableDate", required=true)
    public Date getLatestAcceptableDate() {
        return MetadataUtilities.toDate(this.latestAcceptableDate);
    }

    public void setLatestAcceptableDate(Date date) {
        this.checkWritePermission();
        this.latestAcceptableDate = MetadataUtilities.toMilliseconds(date);
    }
}

