/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.PsdHeaderDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsdHeaderDescriptor
extends TagDescriptor<PsdHeaderDirectory> {
    public PsdHeaderDescriptor(@NotNull PsdHeaderDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getChannelCountDescription();
            }
            case 4: {
                return this.getBitsPerChannelDescription();
            }
            case 5: {
                return this.getColorModeDescription();
            }
            case 2: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getChannelCountDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(1);
            if (value == null) {
                return null;
            }
            return value + " channel" + (value == 1 ? "" : "s");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getBitsPerChannelDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(4);
            if (value == null) {
                return null;
            }
            return value + " bit" + (value == 1 ? "" : "s") + " per channel";
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getColorModeDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(5);
            if (value == null) {
                return null;
            }
            switch (value) {
                case 0: {
                    return "Bitmap";
                }
                case 1: {
                    return "Grayscale";
                }
                case 2: {
                    return "Indexed";
                }
                case 3: {
                    return "RGB";
                }
                case 4: {
                    return "CMYK";
                }
                case 7: {
                    return "Multichannel";
                }
                case 8: {
                    return "Duotone";
                }
                case 9: {
                    return "Lab";
                }
            }
            return "Unknown color mode (" + value + ")";
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getImageHeightDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(2);
            if (value == null) {
                return null;
            }
            return value + " pixel" + (value == 1 ? "" : "s");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getImageWidthDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(3);
            if (value == null) {
                return null;
            }
            return value + " pixel" + (value == 1 ? "" : "s");
        }
        catch (Exception e) {
            return null;
        }
    }
}

